/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.aggregated;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintDeclarationException;
import javax.validation.metadata.ElementDescriptor;
import javax.validation.metadata.ParameterDescriptor;
import javax.validation.metadata.ReturnValueDescriptor;
import org.hibernate.validator.internal.metadata.aggregated.AbstractConstraintMetaData;
import org.hibernate.validator.internal.metadata.aggregated.ConstraintMetaData;
import org.hibernate.validator.internal.metadata.aggregated.MetaDataBuilder;
import org.hibernate.validator.internal.metadata.aggregated.ParameterListMetaData;
import org.hibernate.validator.internal.metadata.aggregated.ParameterMetaData;
import org.hibernate.validator.internal.metadata.aggregated.ReturnValueMetaData;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.descriptor.ExecutableDescriptorImpl;
import org.hibernate.validator.internal.metadata.descriptor.ReturnValueDescriptorImpl;
import org.hibernate.validator.internal.metadata.location.ExecutableConstraintLocation;
import org.hibernate.validator.internal.metadata.raw.ConstrainedElement;
import org.hibernate.validator.internal.metadata.raw.ConstrainedExecutable;
import org.hibernate.validator.internal.metadata.raw.ConstrainedParameter;
import org.hibernate.validator.internal.metadata.raw.ExecutableElement;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.ReflectionHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public class ExecutableMetaData
extends AbstractConstraintMetaData {
    private static final Log log = LoggerFactory.make();
    private final Class<?>[] parameterTypes;
    private final List<ParameterMetaData> parameterMetaDataList;
    private final ConstraintDeclarationException parameterConstraintDeclarationException;
    private final Set<MetaConstraint<?>> crossParameterConstraints;
    private final String identifier;
    private final Map<Class<?>, Class<?>> returnValueGroupConversions;

    private ExecutableMetaData(String name, Class<?> returnType, Class<?>[] parameterTypes, ConstraintMetaData.ConstraintMetaDataKind kind, Set<MetaConstraint<?>> returnValueConstraints, List<ParameterMetaData> parameterMetaData, Set<MetaConstraint<?>> crossParameterConstraints, ConstraintDeclarationException parameterConstraintDeclarationException, boolean isCascading, boolean isConstrained, Map<Class<?>, Class<?>> returnValueGroupConversions) {
        super(name, returnType, returnValueConstraints, kind, isCascading, isConstrained);
        this.parameterTypes = parameterTypes;
        this.parameterMetaDataList = Collections.unmodifiableList(parameterMetaData);
        this.parameterConstraintDeclarationException = parameterConstraintDeclarationException;
        this.crossParameterConstraints = Collections.unmodifiableSet(crossParameterConstraints);
        this.returnValueGroupConversions = returnValueGroupConversions;
        this.identifier = name + Arrays.toString(parameterTypes);
    }

    public void assertCorrectnessOfMethodParameterConstraints() throws ConstraintDeclarationException {
        if (this.parameterConstraintDeclarationException != null) {
            throw this.parameterConstraintDeclarationException;
        }
    }

    public ParameterMetaData getParameterMetaData(int parameterIndex) {
        if (parameterIndex < 0 || parameterIndex > this.parameterMetaDataList.size() - 1) {
            throw log.getInvalidMethodParameterIndexException(this.getName(), parameterIndex);
        }
        return this.parameterMetaDataList.get(parameterIndex);
    }

    public List<ParameterMetaData> getAllParameterMetaData() {
        return this.parameterMetaDataList;
    }

    public Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Iterable<MetaConstraint<?>> getCrossParameterConstraints() {
        return this.crossParameterConstraints;
    }

    public ParameterListMetaData getParameterListMetaData() {
        HashSet cascadedParameters = CollectionHelper.newHashSet();
        for (ParameterMetaData oneParameter : this.parameterMetaDataList) {
            if (!oneParameter.isCascading()) continue;
            cascadedParameters.add(oneParameter);
        }
        return new ParameterListMetaData(cascadedParameters);
    }

    public ReturnValueMetaData getReturnValueMetaData() {
        return new ReturnValueMetaData(this.returnValueGroupConversions);
    }

    @Override
    public ElementDescriptor asDescriptor(boolean defaultGroupSequenceRedefined, List<Class<?>> defaultGroupSequence) {
        return new ExecutableDescriptorImpl(this.getKind() == ConstraintMetaData.ConstraintMetaDataKind.METHOD ? ElementDescriptor.Kind.METHOD : ElementDescriptor.Kind.CONSTRUCTOR, this.getType(), this.getName(), this.asDescriptors(this.getConstraints()), this.returnValueAsDescriptor(defaultGroupSequenceRedefined, defaultGroupSequence), this.parametersAsDescriptors(defaultGroupSequenceRedefined, defaultGroupSequence), defaultGroupSequenceRedefined, defaultGroupSequence);
    }

    private List<ParameterDescriptor> parametersAsDescriptors(boolean defaultGroupSequenceRedefined, List<Class<?>> defaultGroupSequence) {
        ArrayList<ParameterDescriptor> theValue = CollectionHelper.newArrayList();
        for (ParameterMetaData parameterMetaData : this.parameterMetaDataList) {
            theValue.add((ParameterDescriptor)parameterMetaData.asDescriptor(defaultGroupSequenceRedefined, (List)defaultGroupSequence));
        }
        return theValue;
    }

    private ReturnValueDescriptor returnValueAsDescriptor(boolean defaultGroupSequenceRedefined, List<Class<?>> defaultGroupSequence) {
        Type returnType = this.getType();
        return returnType.equals(Void.TYPE) ? null : new ReturnValueDescriptorImpl(returnType, this.asDescriptors(this.getConstraints()), this.isCascading(), defaultGroupSequenceRedefined, defaultGroupSequence);
    }

    @Override
    public String toString() {
        StringBuilder parameterBuilder = new StringBuilder();
        for (Class<?> oneParameterType : this.getParameterTypes()) {
            parameterBuilder.append(oneParameterType.getSimpleName());
            parameterBuilder.append(", ");
        }
        String parameters = parameterBuilder.length() > 0 ? parameterBuilder.substring(0, parameterBuilder.length() - 2) : parameterBuilder.toString();
        return "ExecutableMetaData [executable=" + this.getType() + " " + this.getName() + "(" + parameters + "), isCascading=" + this.isCascading() + ", isConstrained=" + this.isConstrained() + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.parameterTypes);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExecutableMetaData other = (ExecutableMetaData)obj;
        return Arrays.equals(this.parameterTypes, other.parameterTypes);
    }

    public static class Builder
    extends MetaDataBuilder {
        private final ConstrainedElement.ConstrainedElementKind kind;
        private final Set<ConstrainedExecutable> constrainedExecutables = CollectionHelper.newHashSet();
        private final ExecutableConstraintLocation location;
        private final Set<MetaConstraint<?>> crossParameterConstraints = CollectionHelper.newHashSet();
        private boolean isConstrained = false;

        public Builder(ConstrainedExecutable constrainedExecutable, ConstraintHelper constraintHelper) {
            super(constraintHelper);
            this.kind = constrainedExecutable.getKind();
            this.location = constrainedExecutable.getLocation();
            this.add(constrainedExecutable);
        }

        @Override
        public boolean accepts(ConstrainedElement constrainedElement) {
            return this.kind == constrainedElement.getKind() && ReflectionHelper.haveSameSignature(this.location.getExecutableElement(), ((ConstrainedExecutable)constrainedElement).getLocation().getExecutableElement());
        }

        @Override
        public void add(ConstrainedElement constrainedElement) {
            super.add(constrainedElement);
            ConstrainedExecutable constrainedExecutable = (ConstrainedExecutable)constrainedElement;
            this.constrainedExecutables.add(constrainedExecutable);
            this.isConstrained = this.isConstrained || constrainedExecutable.isConstrained();
            this.crossParameterConstraints.addAll(constrainedExecutable.getCrossParameterConstraints());
        }

        @Override
        public ExecutableMetaData build() {
            ExecutableElement executableElement = this.location.getExecutableElement();
            return new ExecutableMetaData(executableElement.getSimpleName(), executableElement.getReturnType(), executableElement.getParameterTypes(), this.kind == ConstrainedElement.ConstrainedElementKind.CONSTRUCTOR ? ConstraintMetaData.ConstraintMetaDataKind.CONSTRUCTOR : ConstraintMetaData.ConstraintMetaDataKind.METHOD, this.adaptOriginsAndImplicitGroups(this.location.getBeanClass(), this.getConstraints()), this.findParameterMetaData(), this.crossParameterConstraints, this.checkParameterConstraints(), this.isCascading(), this.isConstrained, this.getGroupConversions());
        }

        private List<ParameterMetaData> findParameterMetaData() {
            ArrayList<ParameterMetaData.Builder> parameterBuilders = null;
            for (ConstrainedExecutable oneExecutable : this.constrainedExecutables) {
                if (parameterBuilders == null) {
                    parameterBuilders = CollectionHelper.newArrayList();
                    for (ConstrainedParameter oneParameter : oneExecutable.getAllParameterMetaData()) {
                        parameterBuilders.add(new ParameterMetaData.Builder(this.location.getBeanClass(), oneParameter, this.constraintHelper));
                    }
                    continue;
                }
                int i = 0;
                for (ConstrainedParameter oneParameter : oneExecutable.getAllParameterMetaData()) {
                    ((ParameterMetaData.Builder)parameterBuilders.get(i)).add(oneParameter);
                    ++i;
                }
            }
            ArrayList<ParameterMetaData> parameterMetaDatas = CollectionHelper.newArrayList();
            for (ParameterMetaData.Builder oneBuilder : parameterBuilders) {
                parameterMetaDatas.add(oneBuilder.build());
            }
            return parameterMetaDatas;
        }

        private ConstraintDeclarationException checkParameterConstraints() {
            Set<ConstrainedExecutable> executablesWithParameterConstraints = this.executablesWithParameterConstraints(this.constrainedExecutables);
            if (executablesWithParameterConstraints.isEmpty()) {
                return null;
            }
            HashSet definingTypes = CollectionHelper.newHashSet();
            for (ConstrainedExecutable constrainedExecutable : executablesWithParameterConstraints) {
                definingTypes.add(constrainedExecutable.getLocation().getBeanClass());
            }
            if (definingTypes.size() > 1) {
                return new ConstraintDeclarationException("Only the root method of an overridden method in an inheritance hierarchy may be annotated with parameter constraints, but there are parameter constraints defined at all of the following overridden methods: " + executablesWithParameterConstraints);
            }
            ConstrainedExecutable constrainedExecutable = executablesWithParameterConstraints.iterator().next();
            for (ConstrainedExecutable oneExecutable : this.constrainedExecutables) {
                if (constrainedExecutable.getLocation().getBeanClass().isAssignableFrom(oneExecutable.getLocation().getBeanClass())) continue;
                return new ConstraintDeclarationException("Only the root method of an overridden method in an inheritance hierarchy may be annotated with parameter constraints. The following method itself has no parameter constraints but it is not defined on a sub-type of " + constrainedExecutable.getLocation().getBeanClass() + ": " + oneExecutable);
            }
            return null;
        }

        private Set<ConstrainedExecutable> executablesWithParameterConstraints(Iterable<ConstrainedExecutable> executables) {
            HashSet<ConstrainedExecutable> theValue = CollectionHelper.newHashSet();
            for (ConstrainedExecutable oneExecutable : executables) {
                if (!oneExecutable.hasParameterConstraints()) continue;
                theValue.add(oneExecutable);
            }
            return theValue;
        }
    }
}

