/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.aggregated;

import java.lang.annotation.ElementType;
import java.util.Arrays;
import java.util.Map;
import org.hibernate.validator.internal.metadata.aggregated.Cascadable;
import org.hibernate.validator.internal.metadata.aggregated.GroupConverter;
import org.hibernate.validator.internal.metadata.aggregated.Validatable;

public class ReturnValueMetaData
implements Validatable {
    public static final String RETURN_VALUE_NODE_NAME = "$retval";
    private final Map<Class<?>, Class<?>> groupConversions;

    public ReturnValueMetaData(Map<Class<?>, Class<?>> groupConversions) {
        this.groupConversions = groupConversions;
    }

    @Override
    public Iterable<Cascadable> getCascadables() {
        return Arrays.asList(new ReturnValueCascadable(this.groupConversions));
    }

    private class ReturnValueCascadable
    implements Cascadable {
        private final GroupConverter groupConverter;

        public ReturnValueCascadable(Map<Class<?>, Class<?>> groupConversions) {
            this.groupConverter = new GroupConverter(groupConversions);
        }

        @Override
        public String getName() {
            return ReturnValueMetaData.RETURN_VALUE_NODE_NAME;
        }

        @Override
        public Class<?> convertGroup(Class<?> originalGroup) {
            return this.groupConverter.convertGroup(originalGroup);
        }

        @Override
        public ElementType getElementType() {
            return ElementType.METHOD;
        }

        @Override
        public Object getValue(Object parent) {
            return parent;
        }
    }
}

