/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.raw;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.validation.GroupSequence;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.location.ConstraintLocation;
import org.hibernate.validator.internal.metadata.raw.ConfigurationSource;
import org.hibernate.validator.internal.metadata.raw.ConstrainedElement;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public abstract class AbstractConstrainedElement
implements ConstrainedElement {
    private static final Log log = LoggerFactory.make();
    private final ConstrainedElement.ConstrainedElementKind kind;
    private final ConfigurationSource source;
    private final ConstraintLocation location;
    private final Set<MetaConstraint<?>> constraints;
    private final Map<Class<?>, Class<?>> groupConversions;
    private final boolean isCascading;

    public AbstractConstrainedElement(ConfigurationSource source, ConstrainedElement.ConstrainedElementKind kind, ConstraintLocation location, Set<MetaConstraint<?>> constraints, Map<Class<?>, Class<?>> groupConversions, boolean isCascading) {
        this.kind = kind;
        this.source = source;
        this.location = location;
        this.constraints = constraints != null ? Collections.unmodifiableSet(constraints) : Collections.emptySet();
        this.groupConversions = Collections.unmodifiableMap(groupConversions);
        this.isCascading = isCascading;
        this.validateGroupConversions();
    }

    private void validateGroupConversions() {
        if (!this.isCascading && !this.groupConversions.isEmpty()) {
            throw log.getGroupConversionOnNonCascadingElementException(this.location);
        }
        for (Class<?> oneGroup : this.groupConversions.keySet()) {
            if (!this.isGroupSequence(oneGroup)) continue;
            throw log.getGroupConversionForSequenceException(oneGroup);
        }
    }

    private boolean isGroupSequence(Class<?> oneGroup) {
        return oneGroup.isAnnotationPresent(GroupSequence.class);
    }

    @Override
    public ConstrainedElement.ConstrainedElementKind getKind() {
        return this.kind;
    }

    @Override
    public ConstraintLocation getLocation() {
        return this.location;
    }

    @Override
    public Iterator<MetaConstraint<?>> iterator() {
        return this.constraints.iterator();
    }

    @Override
    public Set<MetaConstraint<?>> getConstraints() {
        return this.constraints;
    }

    @Override
    public Map<Class<?>, Class<?>> getGroupConversions() {
        return this.groupConversions;
    }

    @Override
    public boolean isCascading() {
        return this.isCascading;
    }

    @Override
    public boolean isConstrained() {
        return this.isCascading || !this.constraints.isEmpty();
    }

    public String toString() {
        return "AbstractConstrainedElement [kind=" + (Object)((Object)this.kind) + ", source=" + (Object)((Object)this.source) + ", location=" + this.location + ", constraints=" + this.constraints + ", isCascading=" + this.isCascading + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractConstrainedElement other = (AbstractConstrainedElement)obj;
        if (this.location == null ? other.location != null : !this.location.equals(other.location)) {
            return false;
        }
        return !(this.source == null ? other.source != null : !this.source.equals((Object)other.source));
    }
}

