/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine;

import javax.validation.ConstraintValidatorFactory;
import javax.validation.ConstraintViolation;
import javax.validation.MessageInterpolator;
import javax.validation.TraversableResolver;
import javax.validation.metadata.ConstraintDescriptor;
import org.hibernate.validator.internal.engine.ConstraintViolationImpl;
import org.hibernate.validator.internal.engine.MessageInterpolatorContext;
import org.hibernate.validator.internal.engine.ValidationContext;
import org.hibernate.validator.internal.engine.ValueContext;
import org.hibernate.validator.internal.engine.constraintvalidation.ConstraintValidatorManager;
import org.hibernate.validator.internal.engine.path.MessageAndPath;
import org.hibernate.validator.internal.metadata.BeanMetaDataManager;

public class StandardValidationContext<T>
extends ValidationContext<T, ConstraintViolation<T>> {
    protected StandardValidationContext(BeanMetaDataManager beanMetaDataManager, ConstraintValidatorManager constraintValidatorManager, Class<T> rootBeanClass, T rootBean, MessageInterpolator messageInterpolator, ConstraintValidatorFactory constraintValidatorFactory, TraversableResolver traversableResolver, boolean failFast) {
        super(beanMetaDataManager, constraintValidatorManager, rootBeanClass, rootBean, messageInterpolator, constraintValidatorFactory, traversableResolver, failFast);
    }

    @Override
    public <U, V> ConstraintViolation<T> createConstraintViolation(ValueContext<U, V> localContext, MessageAndPath messageAndPath, ConstraintDescriptor<?> descriptor) {
        String messageTemplate = messageAndPath.getMessage();
        String interpolatedMessage = this.messageInterpolator.interpolate(messageTemplate, new MessageInterpolatorContext(descriptor, localContext.getCurrentValidatedValue(), this.getRootBeanClass()));
        return new ConstraintViolationImpl(messageTemplate, interpolatedMessage, this.getRootBeanClass(), this.getRootBean(), localContext.getCurrentBean(), localContext.getCurrentValidatedValue(), messageAndPath.getPath(), descriptor, localContext.getElementType());
    }
}

