/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.aggregated;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintDeclarationException;
import javax.validation.metadata.ElementDescriptor;
import javax.validation.metadata.ParameterDescriptor;
import javax.validation.metadata.ReturnValueDescriptor;
import org.hibernate.validator.internal.metadata.aggregated.AbstractConstraintMetaData;
import org.hibernate.validator.internal.metadata.aggregated.ConstraintMetaData;
import org.hibernate.validator.internal.metadata.aggregated.MetaDataBuilder;
import org.hibernate.validator.internal.metadata.aggregated.ParameterMetaData;
import org.hibernate.validator.internal.metadata.aggregated.ReturnValueMetaData;
import org.hibernate.validator.internal.metadata.aggregated.ValidatableParametersMetaData;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.descriptor.ExecutableDescriptorImpl;
import org.hibernate.validator.internal.metadata.location.ExecutableConstraintLocation;
import org.hibernate.validator.internal.metadata.raw.ConstrainedElement;
import org.hibernate.validator.internal.metadata.raw.ConstrainedExecutable;
import org.hibernate.validator.internal.metadata.raw.ConstrainedParameter;
import org.hibernate.validator.internal.metadata.raw.ExecutableElement;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public class ExecutableMetaData
extends AbstractConstraintMetaData {
    private static final Log log = LoggerFactory.make();
    private final Class<?>[] parameterTypes;
    private final List<ParameterMetaData> parameterMetaDataList;
    private final ConstraintDeclarationException parameterConstraintDeclarationException;
    private final ConstraintDeclarationException returnValueConstraintDeclarationException;
    private final Set<MetaConstraint<?>> crossParameterConstraints;
    private final String identifier;
    private final ReturnValueMetaData returnValueMetaData;

    private ExecutableMetaData(String name, Class<?> returnType, Class<?>[] parameterTypes, ConstraintMetaData.ConstraintMetaDataKind kind, Set<MetaConstraint<?>> returnValueConstraints, List<ParameterMetaData> parameterMetaData, Set<MetaConstraint<?>> crossParameterConstraints, ConstraintDeclarationException parameterConstraintDeclarationException, ConstraintDeclarationException returnValueConstraintDeclarationException, boolean isCascading, boolean isConstrained, Map<Class<?>, Class<?>> returnValueGroupConversions) {
        super(name, returnType, returnValueConstraints, kind, isCascading, isConstrained);
        this.parameterTypes = parameterTypes;
        this.parameterMetaDataList = Collections.unmodifiableList(parameterMetaData);
        this.parameterConstraintDeclarationException = parameterConstraintDeclarationException;
        this.returnValueConstraintDeclarationException = returnValueConstraintDeclarationException;
        this.crossParameterConstraints = Collections.unmodifiableSet(crossParameterConstraints);
        this.identifier = name + Arrays.toString(parameterTypes);
        this.returnValueMetaData = new ReturnValueMetaData(returnType, returnValueConstraints, isCascading, returnValueGroupConversions);
    }

    public void assertCorrectnessOfConfiguration() throws ConstraintDeclarationException {
        if (this.parameterConstraintDeclarationException != null) {
            throw this.parameterConstraintDeclarationException;
        }
        if (this.returnValueConstraintDeclarationException != null) {
            throw this.returnValueConstraintDeclarationException;
        }
    }

    public ParameterMetaData getParameterMetaData(int parameterIndex) {
        if (parameterIndex < 0 || parameterIndex > this.parameterMetaDataList.size() - 1) {
            throw log.getInvalidMethodParameterIndexException(this.getName(), parameterIndex);
        }
        return this.parameterMetaDataList.get(parameterIndex);
    }

    public Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Set<MetaConstraint<?>> getCrossParameterConstraints() {
        return this.crossParameterConstraints;
    }

    public ValidatableParametersMetaData getValidatableParametersMetaData() {
        HashSet cascadedParameters = CollectionHelper.newHashSet();
        for (ParameterMetaData parameterMetaData : this.parameterMetaDataList) {
            if (!parameterMetaData.isCascading()) continue;
            cascadedParameters.add(parameterMetaData);
        }
        return new ValidatableParametersMetaData(cascadedParameters);
    }

    public ReturnValueMetaData getReturnValueMetaData() {
        return this.returnValueMetaData;
    }

    @Override
    public ElementDescriptor asDescriptor(boolean defaultGroupSequenceRedefined, List<Class<?>> defaultGroupSequence) {
        return new ExecutableDescriptorImpl(this.getKind() == ConstraintMetaData.ConstraintMetaDataKind.METHOD ? ElementDescriptor.Kind.METHOD : ElementDescriptor.Kind.CONSTRUCTOR, this.getType(), this.getName(), this.asDescriptors(this.getCrossParameterConstraints()), (ReturnValueDescriptor)this.returnValueMetaData.asDescriptor(defaultGroupSequenceRedefined, (List)defaultGroupSequence), this.parametersAsDescriptors(defaultGroupSequenceRedefined, defaultGroupSequence), defaultGroupSequenceRedefined, defaultGroupSequence);
    }

    public ElementDescriptor getDescriptor() {
        return this.asDescriptor(false, Collections.<Class<?>>emptyList());
    }

    private List<ParameterDescriptor> parametersAsDescriptors(boolean defaultGroupSequenceRedefined, List<Class<?>> defaultGroupSequence) {
        ArrayList<ParameterDescriptor> parameterDescriptorList = CollectionHelper.newArrayList();
        for (ParameterMetaData parameterMetaData : this.parameterMetaDataList) {
            parameterDescriptorList.add((ParameterDescriptor)parameterMetaData.asDescriptor(defaultGroupSequenceRedefined, (List)defaultGroupSequence));
        }
        return parameterDescriptorList;
    }

    @Override
    public String toString() {
        StringBuilder parameterBuilder = new StringBuilder();
        for (Class<?> oneParameterType : this.getParameterTypes()) {
            parameterBuilder.append(oneParameterType.getSimpleName());
            parameterBuilder.append(", ");
        }
        String parameters = parameterBuilder.length() > 0 ? parameterBuilder.substring(0, parameterBuilder.length() - 2) : parameterBuilder.toString();
        return "ExecutableMetaData [executable=" + this.getType() + " " + this.getName() + "(" + parameters + "), isCascading=" + this.isCascading() + ", isConstrained=" + this.isConstrained() + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.parameterTypes);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExecutableMetaData other = (ExecutableMetaData)obj;
        return Arrays.equals(this.parameterTypes, other.parameterTypes);
    }

    public static class Builder
    extends MetaDataBuilder {
        private final ConstrainedElement.ConstrainedElementKind kind;
        private final Set<ConstrainedExecutable> constrainedExecutables = CollectionHelper.newHashSet();
        private final ExecutableConstraintLocation location;
        private final Set<MetaConstraint<?>> crossParameterConstraints = CollectionHelper.newHashSet();
        private boolean isConstrained = false;

        public Builder(Class<?> beanClass, ConstrainedExecutable constrainedExecutable, ConstraintHelper constraintHelper) {
            super(beanClass, constraintHelper);
            this.kind = constrainedExecutable.getKind();
            this.location = constrainedExecutable.getLocation();
            this.add(constrainedExecutable);
        }

        @Override
        public boolean accepts(ConstrainedElement constrainedElement) {
            if (this.kind != constrainedElement.getKind()) {
                return false;
            }
            ExecutableElement executableElement = ((ConstrainedExecutable)constrainedElement).getLocation().getExecutableElement();
            return this.location.getExecutableElement().overrides(executableElement) || executableElement.overrides(this.location.getExecutableElement());
        }

        @Override
        public void add(ConstrainedElement constrainedElement) {
            super.add(constrainedElement);
            ConstrainedExecutable constrainedExecutable = (ConstrainedExecutable)constrainedElement;
            this.constrainedExecutables.add(constrainedExecutable);
            this.isConstrained = this.isConstrained || constrainedExecutable.isConstrained();
            this.crossParameterConstraints.addAll(constrainedExecutable.getCrossParameterConstraints());
        }

        @Override
        public ExecutableMetaData build() {
            ExecutableElement executableElement = this.location.getExecutableElement();
            return new ExecutableMetaData(executableElement.getSimpleName(), executableElement.getReturnType(), executableElement.getParameterTypes(), this.kind == ConstrainedElement.ConstrainedElementKind.CONSTRUCTOR ? ConstraintMetaData.ConstraintMetaDataKind.CONSTRUCTOR : ConstraintMetaData.ConstraintMetaDataKind.METHOD, this.adaptOriginsAndImplicitGroups(this.getConstraints()), this.findParameterMetaData(), this.adaptOriginsAndImplicitGroups(this.crossParameterConstraints), this.checkParameterConstraints(), this.checkReturnValueConfiguration(), this.isCascading(), this.isConstrained, this.getGroupConversions());
        }

        private List<ParameterMetaData> findParameterMetaData() {
            ArrayList<ParameterMetaData.Builder> parameterBuilders = null;
            for (ConstrainedExecutable oneExecutable : this.constrainedExecutables) {
                if (parameterBuilders == null) {
                    parameterBuilders = CollectionHelper.newArrayList();
                    for (ConstrainedParameter oneParameter : oneExecutable.getAllParameterMetaData()) {
                        parameterBuilders.add(new ParameterMetaData.Builder(this.location.getBeanClass(), oneParameter, this.constraintHelper));
                    }
                    continue;
                }
                int i = 0;
                for (ConstrainedParameter oneParameter : oneExecutable.getAllParameterMetaData()) {
                    ((ParameterMetaData.Builder)parameterBuilders.get(i)).add(oneParameter);
                    ++i;
                }
            }
            ArrayList<ParameterMetaData> parameterMetaDatas = CollectionHelper.newArrayList();
            for (ParameterMetaData.Builder oneBuilder : parameterBuilders) {
                parameterMetaDatas.add(oneBuilder.build());
            }
            return parameterMetaDatas;
        }

        private ConstraintDeclarationException checkParameterConstraints() {
            Set<ConstrainedExecutable> executablesWithParameterConstraints = this.executablesWithParameterConstraints(this.constrainedExecutables);
            if (executablesWithParameterConstraints.isEmpty()) {
                return null;
            }
            HashSet definingTypes = CollectionHelper.newHashSet();
            for (ConstrainedExecutable constrainedExecutable : executablesWithParameterConstraints) {
                definingTypes.add(constrainedExecutable.getLocation().getBeanClass());
            }
            if (definingTypes.size() > 1) {
                return new ConstraintDeclarationException("Only the root method of an overridden method in an inheritance hierarchy may be annotated with parameter constraints, but there are parameter constraints defined at all of the following overridden methods: " + executablesWithParameterConstraints);
            }
            ConstrainedExecutable constrainedExecutable = executablesWithParameterConstraints.iterator().next();
            for (ConstrainedExecutable oneExecutable : this.constrainedExecutables) {
                if (constrainedExecutable.getLocation().getBeanClass().isAssignableFrom(oneExecutable.getLocation().getBeanClass())) continue;
                return new ConstraintDeclarationException("Only the root method of an overridden method in an inheritance hierarchy may be annotated with parameter constraints. The following method itself has no parameter constraints but it is not defined on a sub-type of " + constrainedExecutable.getLocation().getBeanClass() + ": " + oneExecutable);
            }
            return null;
        }

        private ConstraintDeclarationException checkReturnValueConfiguration() {
            ConstrainedExecutable methodWithCascadingReturnValue = null;
            for (ConstrainedExecutable executable : this.constrainedExecutables) {
                if (executable.getLocation().getExecutableElement().getReturnType() == Void.TYPE && (!executable.getConstraints().isEmpty() || executable.isCascading())) {
                    return log.voidMethodsMustNotBeConstrained(executable.getLocation().getMember());
                }
                if (!executable.isCascading()) continue;
                if (methodWithCascadingReturnValue != null) {
                    return log.methodReturnValueMustNotBeMarkedMoreThanOnceForCascadedValidation(methodWithCascadingReturnValue.getLocation().getMember(), executable.getLocation().getMember());
                }
                methodWithCascadingReturnValue = executable;
            }
            return null;
        }

        private Set<ConstrainedExecutable> executablesWithParameterConstraints(Iterable<ConstrainedExecutable> executables) {
            HashSet<ConstrainedExecutable> theValue = CollectionHelper.newHashSet();
            for (ConstrainedExecutable oneExecutable : executables) {
                if (!oneExecutable.hasParameterConstraints()) continue;
                theValue.add(oneExecutable);
            }
            return theValue;
        }
    }
}

