/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.provider;

import java.io.InputStream;
import java.lang.annotation.ElementType;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.validator.internal.metadata.core.AnnotationProcessingOptions;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.location.BeanConstraintLocation;
import org.hibernate.validator.internal.metadata.location.ConstraintLocation;
import org.hibernate.validator.internal.metadata.location.ExecutableConstraintLocation;
import org.hibernate.validator.internal.metadata.provider.MetaDataProviderKeyedByClassName;
import org.hibernate.validator.internal.metadata.raw.ConfigurationSource;
import org.hibernate.validator.internal.metadata.raw.ConstrainedElement;
import org.hibernate.validator.internal.metadata.raw.ConstrainedExecutable;
import org.hibernate.validator.internal.metadata.raw.ConstrainedField;
import org.hibernate.validator.internal.metadata.raw.ConstrainedType;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.xml.XmlMappingParser;

public class XmlMetaDataProvider
extends MetaDataProviderKeyedByClassName {
    private final AnnotationProcessingOptions annotationProcessingOptions;

    public XmlMetaDataProvider(ConstraintHelper constraintHelper, Set<InputStream> mappingStreams) {
        super(constraintHelper);
        XmlMappingParser mappingParser = new XmlMappingParser(constraintHelper);
        mappingParser.parse(mappingStreams);
        for (Class<?> clazz : mappingParser.getXmlConfiguredClasses()) {
            Map<ConstraintLocation, Set<MetaConstraint<?>>> constraintsByLocation = CollectionHelper.partition(mappingParser.getConstraintsForClass(clazz), this.byLocation());
            Set<ConstraintLocation> cascades = this.getCascades(mappingParser, clazz);
            Set<ConstrainedElement> constrainedElements = this.getConstrainedElements(constraintsByLocation, cascades);
            this.addBeanConfiguration(clazz, this.createBeanConfiguration(ConfigurationSource.XML, clazz, constrainedElements, mappingParser.getDefaultSequenceForClass(clazz), null));
        }
        this.annotationProcessingOptions = mappingParser.getAnnotationProcessingOptions();
    }

    @Override
    public AnnotationProcessingOptions getAnnotationProcessingOptions() {
        return this.annotationProcessingOptions;
    }

    private Set<ConstrainedElement> getConstrainedElements(Map<ConstraintLocation, Set<MetaConstraint<?>>> constraintsByLocation, Set<ConstraintLocation> cascades) {
        HashSet<ConstraintLocation> configuredLocations = new HashSet<ConstraintLocation>(cascades);
        configuredLocations.addAll(constraintsByLocation.keySet());
        HashSet<ConstrainedElement> propertyMetaData = CollectionHelper.newHashSet();
        for (ConstraintLocation oneConfiguredLocation : configuredLocations) {
            if (oneConfiguredLocation.getElementType() == ElementType.FIELD) {
                propertyMetaData.add(new ConstrainedField(ConfigurationSource.XML, (BeanConstraintLocation)oneConfiguredLocation, constraintsByLocation.get(oneConfiguredLocation), Collections.<Class<?>, Class<?>>emptyMap(), cascades.contains(oneConfiguredLocation)));
                continue;
            }
            if (oneConfiguredLocation.getElementType() == ElementType.METHOD) {
                propertyMetaData.add(new ConstrainedExecutable(ConfigurationSource.XML, new ExecutableConstraintLocation((Method)oneConfiguredLocation.getMember()), constraintsByLocation.get(oneConfiguredLocation), cascades.contains(oneConfiguredLocation)));
                continue;
            }
            if (oneConfiguredLocation.getElementType() != ElementType.TYPE) continue;
            propertyMetaData.add(new ConstrainedType(ConfigurationSource.XML, (BeanConstraintLocation)oneConfiguredLocation, constraintsByLocation.get(oneConfiguredLocation)));
        }
        return propertyMetaData;
    }

    private Set<ConstraintLocation> getCascades(XmlMappingParser mappingParser, Class<?> clazz) {
        HashSet<ConstraintLocation> cascadedConstraintSet = CollectionHelper.newHashSet();
        for (Member member : mappingParser.getCascadedMembersForClass(clazz)) {
            cascadedConstraintSet.add(new BeanConstraintLocation(member));
        }
        return cascadedConstraintSet;
    }

    protected CollectionHelper.Partitioner<ConstraintLocation, MetaConstraint<?>> byLocation() {
        return new CollectionHelper.Partitioner<ConstraintLocation, MetaConstraint<?>>(){

            @Override
            public ConstraintLocation getPartition(MetaConstraint<?> constraint) {
                return constraint.getLocation();
            }
        };
    }
}

