/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine;

import javax.validation.ConstraintValidatorFactory;
import javax.validation.ConstraintViolation;
import javax.validation.MessageInterpolator;
import javax.validation.Path;
import javax.validation.TraversableResolver;
import javax.validation.metadata.ConstraintDescriptor;
import org.hibernate.validator.internal.engine.ConstraintViolationImpl;
import org.hibernate.validator.internal.engine.MessageInterpolatorContext;
import org.hibernate.validator.internal.engine.ValidationContext;
import org.hibernate.validator.internal.engine.ValueContext;
import org.hibernate.validator.internal.engine.constraintvalidation.ConstraintValidatorManager;
import org.hibernate.validator.internal.engine.path.MessageAndPath;
import org.hibernate.validator.internal.metadata.BeanMetaDataManager;
import org.hibernate.validator.internal.metadata.raw.ExecutableElement;

public class MethodValidationContext<T>
extends ValidationContext<T, ConstraintViolation<T>> {
    private final ExecutableElement method;

    protected MethodValidationContext(BeanMetaDataManager beanMetaDataManager, ConstraintValidatorManager constraintValidatorManager, Class<T> rootBeanClass, T rootBean, ExecutableElement method, MessageInterpolator messageInterpolator, ConstraintValidatorFactory constraintValidatorFactory, TraversableResolver traversableResolver, boolean failFast) {
        super(beanMetaDataManager, constraintValidatorManager, rootBeanClass, rootBean, messageInterpolator, constraintValidatorFactory, traversableResolver, failFast);
        this.method = method;
    }

    public ExecutableElement getExecutable() {
        return this.method;
    }

    @Override
    public <U, V> ConstraintViolation<T> createConstraintViolation(ValueContext<U, V> localContext, MessageAndPath messageAndPath, ConstraintDescriptor<?> descriptor) {
        String messageTemplate = messageAndPath.getMessage();
        String interpolatedMessage = this.messageInterpolator.interpolate(messageTemplate, new MessageInterpolatorContext(descriptor, localContext.getCurrentValidatedValue(), this.getRootBeanClass()));
        Path path = messageAndPath.getPath();
        return new ConstraintViolationImpl(messageTemplate, interpolatedMessage, this.getRootBeanClass(), this.getRootBean(), localContext.getCurrentBean(), localContext.getCurrentValidatedValue(), path, descriptor, localContext.getElementType());
    }
}

