/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.descriptor;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.validation.metadata.ConstructorDescriptor;
import javax.validation.metadata.ElementDescriptor;
import javax.validation.metadata.MethodDescriptor;
import javax.validation.metadata.ParameterDescriptor;
import javax.validation.metadata.ReturnValueDescriptor;
import org.hibernate.validator.internal.metadata.descriptor.ConstraintDescriptorImpl;
import org.hibernate.validator.internal.metadata.descriptor.ElementDescriptorImpl;

public class ExecutableDescriptorImpl
extends ElementDescriptorImpl
implements ConstructorDescriptor,
MethodDescriptor {
    private final ElementDescriptor.Kind kind;
    private final String name;
    private final List<ParameterDescriptor> parameters;
    private final ReturnValueDescriptor returnValueDescriptor;

    public ExecutableDescriptorImpl(ElementDescriptor.Kind kind, Type returnType, String name, Set<ConstraintDescriptorImpl<?>> crossParameterValueConstraints, ReturnValueDescriptor returnValueDescriptor, List<ParameterDescriptor> parameters, boolean defaultGroupSequenceRedefined, List<Class<?>> defaultGroupSequence) {
        super(returnType, crossParameterValueConstraints, defaultGroupSequenceRedefined, defaultGroupSequence);
        this.kind = kind;
        this.name = name;
        this.parameters = Collections.unmodifiableList(parameters);
        this.returnValueDescriptor = returnValueDescriptor;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<ParameterDescriptor> getParameterDescriptors() {
        return this.parameters;
    }

    @Override
    public ReturnValueDescriptor getReturnValueDescriptor() {
        return this.returnValueDescriptor;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ExecutableDescriptorImpl");
        sb.append("{name='").append(this.name).append('\'');
        sb.append('}');
        return sb.toString();
    }

    @Override
    public ElementDescriptor.Kind getKind() {
        return this.kind;
    }

    @Override
    public boolean areParametersConstrained() {
        if (this.hasConstraints()) {
            return true;
        }
        for (ParameterDescriptor oneParameter : this.parameters) {
            if (!oneParameter.hasConstraints() && !oneParameter.isCascaded()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isReturnValueConstrained() {
        return this.returnValueDescriptor != null && (this.returnValueDescriptor.hasConstraints() || this.returnValueDescriptor.isCascaded());
    }
}

