/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.xml;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ParameterNameProvider;
import javax.validation.ValidationException;
import org.hibernate.validator.internal.metadata.core.AnnotationProcessingOptionsImpl;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.location.CrossParameterConstraintLocation;
import org.hibernate.validator.internal.metadata.location.ExecutableConstraintLocation;
import org.hibernate.validator.internal.metadata.raw.ConfigurationSource;
import org.hibernate.validator.internal.metadata.raw.ConstrainedExecutable;
import org.hibernate.validator.internal.metadata.raw.ConstrainedParameter;
import org.hibernate.validator.internal.metadata.raw.ExecutableElement;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.ReflectionHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.internal.xml.ConstrainedParameterBuilder;
import org.hibernate.validator.internal.xml.ConstraintType;
import org.hibernate.validator.internal.xml.ConstructorType;
import org.hibernate.validator.internal.xml.GroupConversionBuilder;
import org.hibernate.validator.internal.xml.MetaConstraintBuilder;
import org.hibernate.validator.internal.xml.MethodType;
import org.hibernate.validator.internal.xml.ParameterType;
import org.hibernate.validator.internal.xml.ReturnValueType;

public class ConstrainedExecutableBuilder {
    private static final Log log = LoggerFactory.make();

    private ConstrainedExecutableBuilder() {
    }

    public static Set<ConstrainedExecutable> buildMethodConstrainedExecutable(List<MethodType> methods, Class<?> beanClass, String defaultPackage, ParameterNameProvider parameterNameProvider, ConstraintHelper constraintHelper, AnnotationProcessingOptionsImpl annotationProcessingOptions) {
        HashSet<ConstrainedExecutable> constrainedExecutables = CollectionHelper.newHashSet();
        ArrayList alreadyProcessedMethods = CollectionHelper.newArrayList();
        for (MethodType methodType : methods) {
            boolean ignoreConstructorAnnotations;
            List<Class<?>> parameterTypes = ConstrainedExecutableBuilder.createParameterTypes(methodType.getParameter(), beanClass, defaultPackage);
            String methodName = methodType.getName();
            Method method = ReflectionHelper.getDeclaredMethod(beanClass, methodName, parameterTypes.toArray(new Class[parameterTypes.size()]));
            if (method == null) {
                throw log.getBeanDoesNotContainMethodException(beanClass.getName(), methodName, parameterTypes);
            }
            if (alreadyProcessedMethods.contains(method)) {
                throw log.getMethodIsDefinedTwiceInMappingXmlForBeanException(method.toString(), beanClass.getName());
            }
            alreadyProcessedMethods.add(method);
            ExecutableElement methodExecutableElement = ExecutableElement.forMethod(method);
            boolean bl = ignoreConstructorAnnotations = methodType.getIgnoreAnnotations() == null ? false : methodType.getIgnoreAnnotations();
            if (ignoreConstructorAnnotations) {
                annotationProcessingOptions.ignoreConstraintAnnotationsOnMember(method);
            }
            ConstrainedExecutable constrainedExecutable = ConstrainedExecutableBuilder.parseExecutableType(defaultPackage, methodType.getParameter(), methodType.getCrossParameterConstraint(), methodType.getReturnValue(), methodExecutableElement, constraintHelper, parameterNameProvider, annotationProcessingOptions);
            constrainedExecutables.add(constrainedExecutable);
        }
        return constrainedExecutables;
    }

    public static Set<ConstrainedExecutable> buildConstructorConstrainedExecutable(List<ConstructorType> constructors, Class<?> beanClass, String defaultPackage, ParameterNameProvider parameterNameProvider, ConstraintHelper constraintHelper, AnnotationProcessingOptionsImpl annotationProcessingOptions) {
        HashSet<ConstrainedExecutable> constrainedExecutables = CollectionHelper.newHashSet();
        ArrayList alreadyProcessedConstructors = CollectionHelper.newArrayList();
        for (ConstructorType constructorType : constructors) {
            boolean ignoreConstructorAnnotations;
            List<Class<?>> constructorParameterTypes = ConstrainedExecutableBuilder.createParameterTypes(constructorType.getParameter(), beanClass, defaultPackage);
            Constructor<?> constructor = ReflectionHelper.getConstructor(beanClass, constructorParameterTypes.toArray(new Class[constructorParameterTypes.size()]));
            if (constructor == null) {
                throw log.getBeanDoesNotContainConstructorException(beanClass.getName(), constructorParameterTypes);
            }
            if (alreadyProcessedConstructors.contains(constructor)) {
                throw log.getConstructorIsDefinedTwiceInMappingXmlForBeanException(constructor.toString(), beanClass.getName());
            }
            alreadyProcessedConstructors.add(constructor);
            ExecutableElement constructorExecutableElement = ExecutableElement.forConstructor(constructor);
            boolean bl = ignoreConstructorAnnotations = constructorType.getIgnoreAnnotations() == null ? false : constructorType.getIgnoreAnnotations();
            if (ignoreConstructorAnnotations) {
                annotationProcessingOptions.ignoreConstraintAnnotationsOnMember(constructor);
            }
            ConstrainedExecutable constrainedExecutable = ConstrainedExecutableBuilder.parseExecutableType(defaultPackage, constructorType.getParameter(), constructorType.getCrossParameterConstraint(), constructorType.getReturnValue(), constructorExecutableElement, constraintHelper, parameterNameProvider, annotationProcessingOptions);
            constrainedExecutables.add(constrainedExecutable);
        }
        return constrainedExecutables;
    }

    private static ConstrainedExecutable parseExecutableType(String defaultPackage, List<ParameterType> parameterTypeList, List<ConstraintType> crossParameterConstraintList, ReturnValueType returnValueType, ExecutableElement executableElement, ConstraintHelper constraintHelper, ParameterNameProvider parameterNameProvider, AnnotationProcessingOptionsImpl annotationProcessingOptions) {
        List<ConstrainedParameter> parameterMetaData = ConstrainedParameterBuilder.buildConstrainedParameters(parameterTypeList, executableElement, defaultPackage, constraintHelper, parameterNameProvider, annotationProcessingOptions);
        HashSet<MetaConstraint<?>> crossParameterConstraints = CollectionHelper.newHashSet();
        CrossParameterConstraintLocation constraintLocation = new CrossParameterConstraintLocation(executableElement);
        for (ConstraintType constraintType : crossParameterConstraintList) {
            MetaConstraint metaConstraint = MetaConstraintBuilder.buildMetaConstraint(constraintLocation, constraintType, executableElement.getElementType(), defaultPackage, constraintHelper);
            crossParameterConstraints.add(metaConstraint);
        }
        HashSet<MetaConstraint<?>> returnValueConstraints = CollectionHelper.newHashSet();
        HashMap<Class<?>, Class<?>> groupConversions = CollectionHelper.newHashMap();
        boolean isCascaded = ConstrainedExecutableBuilder.parseReturnValueType(returnValueType, executableElement, returnValueConstraints, groupConversions, defaultPackage, constraintHelper, annotationProcessingOptions);
        return new ConstrainedExecutable(ConfigurationSource.XML, new ExecutableConstraintLocation(executableElement), parameterMetaData, crossParameterConstraints, returnValueConstraints, groupConversions, isCascaded);
    }

    private static boolean parseReturnValueType(ReturnValueType returnValueType, ExecutableElement executableElement, Set<MetaConstraint<?>> returnValueConstraints, Map<Class<?>, Class<?>> groupConversions, String defaultPackage, ConstraintHelper constraintHelper, AnnotationProcessingOptionsImpl annotationProcessingOptions) {
        boolean ignoreConstructorAnnotations;
        if (returnValueType == null) {
            return false;
        }
        ExecutableConstraintLocation constraintLocation = new ExecutableConstraintLocation(executableElement);
        for (ConstraintType constraintType : returnValueType.getConstraint()) {
            MetaConstraint metaConstraint = MetaConstraintBuilder.buildMetaConstraint(constraintLocation, constraintType, executableElement.getElementType(), defaultPackage, constraintHelper);
            returnValueConstraints.add(metaConstraint);
        }
        groupConversions.putAll(GroupConversionBuilder.buildGroupConversionMap(returnValueType.getConvertGroup(), defaultPackage));
        boolean bl = ignoreConstructorAnnotations = returnValueType.getIgnoreAnnotations() == null ? false : returnValueType.getIgnoreAnnotations();
        if (ignoreConstructorAnnotations) {
            annotationProcessingOptions.ignoreConstraintAnnotationsOnReturnValue(executableElement.getMember());
        }
        return returnValueType.getValid() != null;
    }

    private static List<Class<?>> createParameterTypes(List<ParameterType> parameterList, Class<?> beanClass, String defaultPackage) {
        ArrayList<Class<?>> parameterTypes = CollectionHelper.newArrayList();
        for (ParameterType parameterType : parameterList) {
            String type = null;
            try {
                type = parameterType.getType();
                Class<?> parameterClass = ReflectionHelper.loadClass(type, defaultPackage);
                parameterTypes.add(parameterClass);
            }
            catch (ValidationException e) {
                throw log.getInvalidParameterTypeException(type, beanClass.getName());
            }
        }
        return parameterTypes;
    }
}

