/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.xml;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.validation.Payload;
import javax.validation.ValidationException;
import javax.xml.bind.JAXBElement;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.internal.metadata.core.ConstraintOrigin;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.descriptor.ConstraintDescriptorImpl;
import org.hibernate.validator.internal.metadata.location.ConstraintLocation;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.ReflectionHelper;
import org.hibernate.validator.internal.util.annotationfactory.AnnotationDescriptor;
import org.hibernate.validator.internal.util.annotationfactory.AnnotationFactory;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.internal.xml.AnnotationType;
import org.hibernate.validator.internal.xml.ConstraintType;
import org.hibernate.validator.internal.xml.ElementType;
import org.hibernate.validator.internal.xml.GroupsType;
import org.hibernate.validator.internal.xml.PayloadType;

public class MetaConstraintBuilder {
    private static final Log log = LoggerFactory.make();
    private static final String MESSAGE_PARAM = "message";
    private static final String GROUPS_PARAM = "groups";
    private static final String PAYLOAD_PARAM = "payload";

    private MetaConstraintBuilder() {
    }

    public static <A extends Annotation> MetaConstraint<A> buildMetaConstraint(ConstraintLocation constraintLocation, ConstraintType constraint, java.lang.annotation.ElementType type, String defaultPackage, ConstraintHelper constraintHelper) {
        Object annotation;
        Class<?> annotationClass;
        try {
            annotationClass = ReflectionHelper.loadClass(constraint.getAnnotation(), defaultPackage);
        }
        catch (ValidationException e) {
            throw log.unableToLoadConstraintAnnotationClassException(constraint.getAnnotation(), e);
        }
        AnnotationDescriptor annotationDescriptor = new AnnotationDescriptor(annotationClass);
        if (constraint.getMessage() != null) {
            annotationDescriptor.setValue(MESSAGE_PARAM, constraint.getMessage());
        }
        annotationDescriptor.setValue(GROUPS_PARAM, MetaConstraintBuilder.getGroups(constraint.getGroups(), defaultPackage));
        annotationDescriptor.setValue(PAYLOAD_PARAM, MetaConstraintBuilder.getPayload(constraint.getPayload(), defaultPackage));
        for (ElementType elementType : constraint.getElement()) {
            String name = elementType.getName();
            MetaConstraintBuilder.checkNameIsValid(name);
            Class<?> returnType = MetaConstraintBuilder.getAnnotationParameterType(annotationClass, name);
            Object elementValue = MetaConstraintBuilder.getElementValue(elementType, returnType);
            annotationDescriptor.setValue(name, elementValue);
        }
        try {
            annotation = AnnotationFactory.create(annotationDescriptor);
        }
        catch (RuntimeException e) {
            throw log.getUnableToCreateAnnotationForConfiguredConstraintException(e);
        }
        ConstraintDescriptorImpl constraintDescriptor = new ConstraintDescriptorImpl(constraintLocation.getMember(), annotation, constraintHelper, type, ConstraintOrigin.DEFINED_LOCALLY);
        return new MetaConstraint(constraintDescriptor, constraintLocation);
    }

    public static <A extends Annotation> Annotation buildAnnotation(AnnotationType annotationType, Class<A> returnType) {
        AnnotationDescriptor<A> annotationDescriptor = new AnnotationDescriptor<A>(returnType);
        for (ElementType elementType : annotationType.getElement()) {
            String name = elementType.getName();
            Class<?> parameterType = MetaConstraintBuilder.getAnnotationParameterType(returnType, name);
            Object elementValue = MetaConstraintBuilder.getElementValue(elementType, parameterType);
            annotationDescriptor.setValue(name, elementValue);
        }
        return AnnotationFactory.create(annotationDescriptor);
    }

    private static void checkNameIsValid(String name) {
        if (MESSAGE_PARAM.equals(name) || GROUPS_PARAM.equals(name)) {
            throw log.getReservedParameterNamesException(MESSAGE_PARAM, GROUPS_PARAM, PAYLOAD_PARAM);
        }
    }

    private static <A extends Annotation> Class<?> getAnnotationParameterType(Class<A> annotationClass, String name) {
        Method m = ReflectionHelper.getMethod(annotationClass, name);
        if (m == null) {
            throw log.getAnnotationDoesNotContainAParameterException(annotationClass.getName(), name);
        }
        return m.getReturnType();
    }

    private static Object getElementValue(ElementType elementType, Class<?> returnType) {
        MetaConstraintBuilder.removeEmptyContentElements(elementType);
        boolean isArray = returnType.isArray();
        if (!isArray) {
            if (elementType.getContent().size() != 1) {
                throw log.getAttemptToSpecifyAnArrayWhereSingleValueIsExpectedException();
            }
            return MetaConstraintBuilder.getSingleValue(elementType.getContent().get(0), returnType);
        }
        ArrayList<Object> values = CollectionHelper.newArrayList();
        for (Serializable s : elementType.getContent()) {
            values.add(MetaConstraintBuilder.getSingleValue(s, returnType.getComponentType()));
        }
        return values.toArray((Object[])Array.newInstance(returnType.getComponentType(), values.size()));
    }

    private static void removeEmptyContentElements(ElementType elementType) {
        ArrayList contentToDelete = CollectionHelper.newArrayList();
        for (Serializable content : elementType.getContent()) {
            if (!(content instanceof String) || !((String)((Object)content)).matches("[\\n ].*")) continue;
            contentToDelete.add(content);
        }
        elementType.getContent().removeAll(contentToDelete);
    }

    private static Object getSingleValue(Serializable serializable, Class<?> returnType) {
        Object returnValue;
        if (serializable instanceof String) {
            String value = (String)((Object)serializable);
            returnValue = MetaConstraintBuilder.convertStringToReturnType(returnType, value);
        } else if (serializable instanceof JAXBElement && ((JAXBElement)serializable).getDeclaredType().equals(String.class)) {
            JAXBElement elem = (JAXBElement)serializable;
            String value = (String)elem.getValue();
            returnValue = MetaConstraintBuilder.convertStringToReturnType(returnType, value);
        } else if (serializable instanceof JAXBElement && ((JAXBElement)serializable).getDeclaredType().equals(AnnotationType.class)) {
            JAXBElement elem = (JAXBElement)serializable;
            AnnotationType annotationType = (AnnotationType)elem.getValue();
            try {
                Class<?> annotationClass = returnType;
                returnValue = MetaConstraintBuilder.buildAnnotation(annotationType, annotationClass);
            }
            catch (ClassCastException e) {
                throw log.getUnexpectedParameterValueException(e);
            }
        } else {
            throw log.getUnexpectedParameterValueException();
        }
        return returnValue;
    }

    private static Object convertStringToReturnType(Class<?> returnType, String value) {
        Class<?> returnValue;
        if (returnType.getName().equals(Byte.TYPE.getName())) {
            try {
                returnValue = Byte.parseByte(value);
            }
            catch (NumberFormatException e) {
                throw log.getInvalidNumberFormatException("byte", e);
            }
        }
        if (returnType.getName().equals(Short.TYPE.getName())) {
            try {
                returnValue = Short.parseShort(value);
            }
            catch (NumberFormatException e) {
                throw log.getInvalidNumberFormatException("short", e);
            }
        }
        if (returnType.getName().equals(Integer.TYPE.getName())) {
            try {
                returnValue = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                throw log.getInvalidNumberFormatException("int", e);
            }
        }
        if (returnType.getName().equals(Long.TYPE.getName())) {
            try {
                returnValue = Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                throw log.getInvalidNumberFormatException("long", e);
            }
        }
        if (returnType.getName().equals(Float.TYPE.getName())) {
            try {
                returnValue = Float.valueOf(Float.parseFloat(value));
            }
            catch (NumberFormatException e) {
                throw log.getInvalidNumberFormatException("float", e);
            }
        }
        if (returnType.getName().equals(Double.TYPE.getName())) {
            try {
                returnValue = Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                throw log.getInvalidNumberFormatException("double", e);
            }
        }
        if (returnType.getName().equals(Boolean.TYPE.getName())) {
            returnValue = Boolean.parseBoolean(value);
        } else if (returnType.getName().equals(Character.TYPE.getName())) {
            if (value.length() != 1) {
                throw log.getInvalidCharValueException(value);
            }
            returnValue = Character.valueOf(value.charAt(0));
        } else if (returnType.getName().equals(String.class.getName())) {
            returnValue = value;
        } else if (returnType.getName().equals(Class.class.getName())) {
            returnValue = ReflectionHelper.loadClass(value, MetaConstraintBuilder.class);
        } else {
            try {
                Class<?> enumClass = returnType;
                returnValue = Enum.valueOf(enumClass, value);
            }
            catch (ClassCastException e) {
                throw log.getInvalidReturnTypeException(returnType, e);
            }
        }
        return returnValue;
    }

    private static Class<?>[] getGroups(GroupsType groupsType, String defaultPackage) {
        if (groupsType == null) {
            return new Class[0];
        }
        ArrayList<Class> groupList = CollectionHelper.newArrayList();
        for (String groupClass : groupsType.getValue()) {
            groupList.add(ReflectionHelper.loadClass(groupClass, defaultPackage));
        }
        return groupList.toArray(new Class[groupList.size()]);
    }

    private static Class<? extends Payload>[] getPayload(PayloadType payloadType, String defaultPackage) {
        if (payloadType == null) {
            return new Class[0];
        }
        ArrayList<Class> payloadList = CollectionHelper.newArrayList();
        for (String groupClass : payloadType.getValue()) {
            Class<?> payload = ReflectionHelper.loadClass(groupClass, defaultPackage);
            if (!Payload.class.isAssignableFrom(payload)) {
                throw log.getWrongPayloadClassException(payload.getName());
            }
            payloadList.add(payload);
        }
        return payloadList.toArray(new Class[payloadList.size()]);
    }
}

