/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.core;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.hibernate.validator.internal.metadata.core.AnnotationProcessingOptions;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public class AnnotationProcessingOptionsImpl
implements AnnotationProcessingOptions {
    private static final Log log = LoggerFactory.make();
    private final Map<Class<?>, Boolean> ignoreAnnotationDefaults = CollectionHelper.newHashMap();
    private final Map<Class<?>, Boolean> annotationIgnoresForClasses = CollectionHelper.newHashMap();
    private final List<Member> annotationIgnoredForMembers = CollectionHelper.newArrayList();
    private final List<Member> annotationIgnoresForReturnValues = CollectionHelper.newArrayList();
    private final Map<Member, List<Integer>> annotationIgnoresForMethodParameter = CollectionHelper.newHashMap();

    @Override
    public boolean areMemberConstraintsIgnoredFor(Member member) {
        Class<?> clazz = member.getDeclaringClass();
        boolean ignoreAnnotation = !this.annotationIgnoredForMembers.contains(member) ? this.areAllConstraintAnnotationsIgnoredFor(clazz) : this.annotationIgnoredForMembers.contains(member);
        if (ignoreAnnotation) {
            this.logMessage(member, clazz);
        }
        return ignoreAnnotation;
    }

    @Override
    public boolean areReturnValueConstraintsIgnoredFor(Member member) {
        if (this.annotationIgnoresForReturnValues.contains(member)) {
            return true;
        }
        return this.areMemberConstraintsIgnoredFor(member);
    }

    @Override
    public boolean areParameterConstraintsIgnoredFor(Member member, int index) {
        List<Integer> parameterIndexes = this.annotationIgnoresForMethodParameter.get(member);
        if (parameterIndexes != null && parameterIndexes.contains(index)) {
            return true;
        }
        return this.areMemberConstraintsIgnoredFor(member);
    }

    @Override
    public boolean areClassLevelConstraintsIgnoredFor(Class<?> clazz) {
        boolean ignoreAnnotation = this.annotationIgnoresForClasses.containsKey(clazz) ? this.annotationIgnoresForClasses.get(clazz).booleanValue() : this.areAllConstraintAnnotationsIgnoredFor(clazz);
        if (log.isDebugEnabled() && ignoreAnnotation) {
            log.debugf("Class level annotation are getting ignored for %s.", (Object)clazz.getName());
        }
        return ignoreAnnotation;
    }

    @Override
    public void merge(AnnotationProcessingOptions annotationProcessingOptions) {
        AnnotationProcessingOptionsImpl annotationProcessingOptionsImpl = (AnnotationProcessingOptionsImpl)annotationProcessingOptions;
        this.ignoreAnnotationDefaults.putAll(annotationProcessingOptionsImpl.ignoreAnnotationDefaults);
        this.annotationIgnoresForClasses.putAll(annotationProcessingOptionsImpl.annotationIgnoresForClasses);
        this.annotationIgnoredForMembers.addAll(annotationProcessingOptionsImpl.annotationIgnoredForMembers);
        this.annotationIgnoresForReturnValues.addAll(annotationProcessingOptionsImpl.annotationIgnoresForReturnValues);
        for (Map.Entry<Member, List<Integer>> entry : annotationProcessingOptionsImpl.annotationIgnoresForMethodParameter.entrySet()) {
            if (this.annotationIgnoresForMethodParameter.containsKey(entry.getKey())) {
                this.annotationIgnoresForMethodParameter.get(entry.getKey()).addAll((Collection<Integer>)entry.getValue());
                continue;
            }
            this.annotationIgnoresForMethodParameter.put(entry.getKey(), entry.getValue());
        }
    }

    public void ignoreAnnotationConstraintForClass(Class<?> clazz, Boolean b) {
        if (b == null) {
            this.ignoreAnnotationDefaults.put(clazz, Boolean.TRUE);
        } else {
            this.ignoreAnnotationDefaults.put(clazz, b);
        }
    }

    public void ignoreConstraintAnnotationsOnMember(Member member) {
        this.annotationIgnoredForMembers.add(member);
    }

    public void ignoreConstraintAnnotationsOnReturnValue(Member member) {
        this.annotationIgnoresForReturnValues.add(member);
    }

    public void ignoreConstraintAnnotationsOnParameter(Member member, int index) {
        if (this.annotationIgnoresForMethodParameter.get(member) == null) {
            ArrayList tmpList = CollectionHelper.newArrayList();
            tmpList.add(index);
            this.annotationIgnoresForMethodParameter.put(member, tmpList);
        } else {
            this.annotationIgnoresForMethodParameter.get(member).add(index);
        }
    }

    public void ignoreClassLevelConstraintAnnotations(Class<?> clazz, boolean b) {
        this.annotationIgnoresForClasses.put(clazz, b);
    }

    private boolean areAllConstraintAnnotationsIgnoredFor(Class<?> clazz) {
        return this.ignoreAnnotationDefaults.containsKey(clazz) && this.ignoreAnnotationDefaults.get(clazz) != false;
    }

    private void logMessage(Member member, Class<?> clazz) {
        if (log.isTraceEnabled()) {
            String type = member instanceof Field ? "Field" : "Property";
            log.debugf("%s level annotations are getting ignored for %s.%s.", (Object)type, (Object)clazz.getName(), (Object)member.getName());
        }
    }
}

