/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.xml;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.validation.ParameterNameProvider;
import org.hibernate.validator.internal.metadata.core.AnnotationProcessingOptionsImpl;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.location.ExecutableConstraintLocation;
import org.hibernate.validator.internal.metadata.raw.ConfigurationSource;
import org.hibernate.validator.internal.metadata.raw.ConstrainedParameter;
import org.hibernate.validator.internal.metadata.raw.ExecutableElement;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.xml.ConstraintType;
import org.hibernate.validator.internal.xml.GroupConversionBuilder;
import org.hibernate.validator.internal.xml.MetaConstraintBuilder;
import org.hibernate.validator.internal.xml.ParameterType;

public class ConstrainedParameterBuilder {
    private ConstrainedParameterBuilder() {
    }

    public static List<ConstrainedParameter> buildConstrainedParameters(List<ParameterType> parameterList, ExecutableElement executableElement, String defaultPackage, ConstraintHelper constraintHelper, ParameterNameProvider parameterNameProvider, AnnotationProcessingOptionsImpl annotationProcessingOptions) {
        ArrayList<ConstrainedParameter> constrainedParameters = CollectionHelper.newArrayList();
        int i = 0;
        List<String> parameterNames = executableElement.getParameterNames(parameterNameProvider);
        for (ParameterType parameterType : parameterList) {
            boolean ignoreConstructorAnnotations;
            ExecutableConstraintLocation constraintLocation = new ExecutableConstraintLocation(executableElement, (Integer)i);
            HashSet<MetaConstraint<?>> metaConstraints = CollectionHelper.newHashSet();
            for (ConstraintType constraint : parameterType.getConstraint()) {
                MetaConstraint metaConstraint = MetaConstraintBuilder.buildMetaConstraint(constraintLocation, constraint, executableElement.getElementType(), defaultPackage, constraintHelper);
                metaConstraints.add(metaConstraint);
            }
            Map<Class<?>, Class<?>> groupConversions = GroupConversionBuilder.buildGroupConversionMap(parameterType.getConvertGroup(), defaultPackage);
            boolean bl = ignoreConstructorAnnotations = parameterType.getIgnoreAnnotations() == null ? false : parameterType.getIgnoreAnnotations();
            if (ignoreConstructorAnnotations) {
                annotationProcessingOptions.ignoreConstraintAnnotationsOnParameter(executableElement.getMember(), i);
            }
            ConstrainedParameter constrainedParameter = new ConstrainedParameter(ConfigurationSource.XML, constraintLocation, parameterNames.get(i), metaConstraints, groupConversions, parameterType.getValid() != null);
            constrainedParameters.add(constrainedParameter);
            ++i;
        }
        return constrainedParameters;
    }
}

