/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.cdi;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedCallable;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessBean;
import javax.enterprise.util.AnnotationLiteral;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.hibernate.validator.cdi.HibernateValidator;
import org.hibernate.validator.internal.cdi.ValidatorBean;
import org.hibernate.validator.internal.cdi.ValidatorFactoryBean;
import org.hibernate.validator.internal.cdi.interceptor.MethodValidated;
import org.hibernate.validator.internal.cdi.interceptor.ValidationEnabledAnnotatedType;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.internal.util.Contracts;

public class ValidationExtension
implements Extension {
    private final ConstraintHelper constraintHelper = new ConstraintHelper();
    private boolean validatorRegisteredUnderDefaultQualifier = false;
    private boolean validatorRegisteredUnderHibernateQualifier = false;

    public void afterBeanDiscovery(@Observes AfterBeanDiscovery afterBeanDiscoveryEvent, BeanManager beanManager) {
        Contracts.assertNotNull(afterBeanDiscoveryEvent, "The AfterBeanDiscovery event cannot be null");
        Contracts.assertNotNull(beanManager, "The BeanManager cannot be null");
        Set<Annotation> missingQualifiers = this.determineMissingQualifiers();
        if (missingQualifiers.isEmpty()) {
            return;
        }
        afterBeanDiscoveryEvent.addBean((Bean)new ValidatorFactoryBean(beanManager, missingQualifiers));
        afterBeanDiscoveryEvent.addBean((Bean)new ValidatorBean(beanManager, missingQualifiers));
    }

    public void processBean(@Observes ProcessBean processBeanEvent) {
        Contracts.assertNotNull(processBeanEvent, "The ProcessBean event cannot be null");
        Bean bean = processBeanEvent.getBean();
        if (!bean.getTypes().contains(ValidatorFactory.class) && !bean.getTypes().contains(Validator.class)) {
            return;
        }
        if (bean instanceof ValidatorFactoryBean || bean instanceof ValidatorBean) {
            return;
        }
        for (Annotation annotation : bean.getQualifiers()) {
            if (HibernateValidator.class.equals(annotation.annotationType())) {
                this.validatorRegisteredUnderHibernateQualifier = true;
            }
            if (!Default.class.equals(annotation.annotationType())) continue;
            this.validatorRegisteredUnderDefaultQualifier = true;
        }
    }

    public void beforeBeanDiscovery(@Observes BeforeBeanDiscovery beforeBeanDiscoveryEvent, BeanManager beanManager) {
        Contracts.assertNotNull(beforeBeanDiscoveryEvent, "The BeforeBeanDiscovery event cannot be null");
        beforeBeanDiscoveryEvent.addInterceptorBinding(MethodValidated.class, new Annotation[0]);
    }

    public <T> void processAnnotatedType(@Observes ProcessAnnotatedType<T> processAnnotatedTypeEvent) {
        Contracts.assertNotNull(processAnnotatedTypeEvent, "The ProcessAnnotatedType event cannot be null");
        AnnotatedType type = processAnnotatedTypeEvent.getAnnotatedType();
        Set<AnnotatedCallable<T>> constrainedCallables = this.determineConstrainedCallables(type);
        if (!constrainedCallables.isEmpty()) {
            ValidationEnabledAnnotatedType<T> wrappedType = new ValidationEnabledAnnotatedType<T>(type, constrainedCallables);
            processAnnotatedTypeEvent.setAnnotatedType(wrappedType);
        }
    }

    private <T> Set<AnnotatedCallable<T>> determineConstrainedCallables(AnnotatedType<T> type) {
        HashSet<AnnotatedCallable<T>> callables = new HashSet<AnnotatedCallable<T>>();
        for (AnnotatedConstructor constructor : type.getConstructors()) {
            if (!this.isCallableConstrained((AnnotatedCallable<? super T>)constructor)) continue;
            callables.add((AnnotatedCallable<T>)constructor);
        }
        for (AnnotatedMethod method : type.getMethods()) {
            if (!this.isCallableConstrained((AnnotatedCallable<? super T>)method)) continue;
            callables.add((AnnotatedCallable<T>)method);
        }
        return callables;
    }

    private <T> boolean isCallableConstrained(AnnotatedCallable<? super T> callable) {
        if (this.containsConstraintAnnotation(callable.getAnnotations())) {
            return true;
        }
        for (AnnotatedParameter parameter : callable.getParameters()) {
            if (!this.containsConstraintAnnotation(parameter.getAnnotations())) continue;
            return true;
        }
        return false;
    }

    private boolean containsConstraintAnnotation(Set<Annotation> annotations) {
        for (Annotation annotation : annotations) {
            if (!this.constraintHelper.isConstraintAnnotation(annotation.annotationType())) continue;
            return true;
        }
        return false;
    }

    private Set<Annotation> determineMissingQualifiers() {
        HashSet<Annotation> annotations = new HashSet<Annotation>(2);
        if (!this.validatorRegisteredUnderDefaultQualifier) {
            annotations.add((Annotation)new AnnotationLiteral<Default>(){});
        }
        if (!this.validatorRegisteredUnderHibernateQualifier) {
            annotations.add((Annotation)new AnnotationLiteral<HibernateValidator>(){});
        }
        return annotations;
    }
}

