/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine;

import java.lang.annotation.ElementType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.ConstraintViolation;
import javax.validation.MessageInterpolator;
import javax.validation.ParameterNameProvider;
import javax.validation.Path;
import javax.validation.TraversableResolver;
import javax.validation.metadata.ConstraintDescriptor;
import org.hibernate.validator.internal.engine.ConstraintViolationImpl;
import org.hibernate.validator.internal.engine.MessageInterpolatorContext;
import org.hibernate.validator.internal.engine.ValueContext;
import org.hibernate.validator.internal.engine.constraintvalidation.ConstraintValidatorContextImpl;
import org.hibernate.validator.internal.engine.constraintvalidation.ConstraintValidatorManager;
import org.hibernate.validator.internal.engine.path.MessageAndPath;
import org.hibernate.validator.internal.engine.path.PathImpl;
import org.hibernate.validator.internal.metadata.BeanMetaDataManager;
import org.hibernate.validator.internal.metadata.raw.ExecutableElement;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.IdentitySet;

public class ValidationContext<T> {
    private final BeanMetaDataManager beanMetaDataManager;
    private final ConstraintValidatorManager constraintValidatorManager;
    private final T rootBean;
    private final Class<T> rootBeanClass;
    private final ExecutableElement executable;
    private final Object[] executableParameters;
    private final Object executableReturnValue;
    private final Map<Class<?>, IdentitySet> processedObjects;
    private final Map<Object, Set<PathImpl>> processedPaths;
    private final Set<ConstraintViolation<T>> failingConstraintViolations;
    private final MessageInterpolator messageInterpolator;
    private final ConstraintValidatorFactory constraintValidatorFactory;
    private final TraversableResolver traversableResolver;
    private final ParameterNameProvider parameterNameProvider;
    private final boolean failFast;

    public static ValidationContextBuilder getValidationContext(BeanMetaDataManager beanMetaDataManager, ConstraintValidatorManager constraintValidatorManager, MessageInterpolator messageInterpolator, ConstraintValidatorFactory constraintValidatorFactory, TraversableResolver traversableResolver, boolean failFast) {
        return new ValidationContextBuilder(beanMetaDataManager, constraintValidatorManager, messageInterpolator, constraintValidatorFactory, traversableResolver, failFast);
    }

    private ValidationContext(BeanMetaDataManager beanMetaDataManager, ConstraintValidatorManager constraintValidatorManager, MessageInterpolator messageInterpolator, ConstraintValidatorFactory constraintValidatorFactory, TraversableResolver traversableResolver, ParameterNameProvider parameterNameProvider, boolean failFast, T rootBean, Class<T> rootBeanClass, ExecutableElement executable, Object[] executableParameters, Object executableReturnValue) {
        this.beanMetaDataManager = beanMetaDataManager;
        this.constraintValidatorManager = constraintValidatorManager;
        this.messageInterpolator = messageInterpolator;
        this.constraintValidatorFactory = constraintValidatorFactory;
        this.traversableResolver = traversableResolver;
        this.parameterNameProvider = parameterNameProvider;
        this.failFast = failFast;
        this.rootBean = rootBean;
        this.rootBeanClass = rootBeanClass;
        this.executable = executable;
        this.executableParameters = executableParameters;
        this.executableReturnValue = executableReturnValue;
        this.processedObjects = CollectionHelper.newHashMap();
        this.processedPaths = new IdentityHashMap<Object, Set<PathImpl>>();
        this.failingConstraintViolations = CollectionHelper.newHashSet();
    }

    public T getRootBean() {
        return this.rootBean;
    }

    public Class<T> getRootBeanClass() {
        return this.rootBeanClass;
    }

    public ExecutableElement getExecutable() {
        return this.executable;
    }

    public TraversableResolver getTraversableResolver() {
        return this.traversableResolver;
    }

    public boolean isFailFastModeEnabled() {
        return this.failFast;
    }

    public BeanMetaDataManager getBeanMetaDataManager() {
        return this.beanMetaDataManager;
    }

    public ConstraintValidatorManager getConstraintValidatorManager() {
        return this.constraintValidatorManager;
    }

    public List<String> getParameterNames() {
        if (this.parameterNameProvider == null) {
            return null;
        }
        if (this.executable.getElementType() == ElementType.METHOD) {
            return this.parameterNameProvider.getParameterNames((Method)this.executable.getMember());
        }
        return this.parameterNameProvider.getParameterNames((Constructor)this.executable.getMember());
    }

    public List<ConstraintViolation<T>> createConstraintViolations(ValueContext<?, ?> localContext, ConstraintValidatorContextImpl constraintValidatorContext) {
        ArrayList<ConstraintViolation<T>> constraintViolations = CollectionHelper.newArrayList();
        for (MessageAndPath messageAndPath : constraintValidatorContext.getMessageAndPathList()) {
            ConstraintViolation<T> violation = this.createConstraintViolation(localContext, messageAndPath, constraintValidatorContext.getConstraintDescriptor());
            constraintViolations.add(violation);
        }
        return constraintViolations;
    }

    public ConstraintValidatorFactory getConstraintValidatorFactory() {
        return this.constraintValidatorFactory;
    }

    public boolean isAlreadyValidated(Object value, Class<?> group, PathImpl path) {
        boolean alreadyValidated = this.isAlreadyValidatedForCurrentGroup(value, group);
        if (alreadyValidated) {
            alreadyValidated = this.isAlreadyValidatedForPath(value, path);
        }
        return alreadyValidated;
    }

    public void markProcessed(ValueContext<?, ?> valueContext) {
        this.markProcessedForCurrentGroup(valueContext.getCurrentBean(), valueContext.getCurrentGroup());
        this.markProcessedForCurrentPath(valueContext.getCurrentBean(), valueContext.getPropertyPath());
    }

    public void addConstraintFailures(Set<ConstraintViolation<T>> failingConstraintViolations) {
        this.failingConstraintViolations.addAll(failingConstraintViolations);
    }

    public Set<ConstraintViolation<T>> getFailingConstraints() {
        return this.failingConstraintViolations;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ValidationContext");
        sb.append("{rootBean=").append(this.rootBean);
        sb.append('}');
        return sb.toString();
    }

    public ConstraintViolation<T> createConstraintViolation(ValueContext<?, ?> localContext, MessageAndPath messageAndPath, ConstraintDescriptor<?> descriptor) {
        String messageTemplate = messageAndPath.getMessage();
        String interpolatedMessage = this.messageInterpolator.interpolate(messageTemplate, new MessageInterpolatorContext(descriptor, localContext.getCurrentValidatedValue(), this.getRootBeanClass()));
        Path path = messageAndPath.getPath();
        if (this.executableParameters != null) {
            return ConstraintViolationImpl.forParameterValidation(messageTemplate, interpolatedMessage, this.getRootBeanClass(), this.getRootBean(), localContext.getCurrentBean(), localContext.getCurrentValidatedValue(), path, descriptor, localContext.getElementType(), this.executableParameters);
        }
        if (this.executableReturnValue != null) {
            return ConstraintViolationImpl.forReturnValueValidation(messageTemplate, interpolatedMessage, this.getRootBeanClass(), this.getRootBean(), localContext.getCurrentBean(), localContext.getCurrentValidatedValue(), path, descriptor, localContext.getElementType(), this.executableReturnValue);
        }
        return ConstraintViolationImpl.forBeanValidation(messageTemplate, interpolatedMessage, this.getRootBeanClass(), this.getRootBean(), localContext.getCurrentBean(), localContext.getCurrentValidatedValue(), path, descriptor, localContext.getElementType());
    }

    private boolean isAlreadyValidatedForPath(Object value, PathImpl path) {
        Set<PathImpl> pathSet = this.processedPaths.get(value);
        if (pathSet == null) {
            return false;
        }
        for (PathImpl p : pathSet) {
            if (!path.isRootPath() && !p.isRootPath() && !this.isSubPathOf(path, p) && !this.isSubPathOf(p, path)) continue;
            return true;
        }
        return false;
    }

    private boolean isSubPathOf(Path p1, Path p2) {
        Iterator p1Iter = p1.iterator();
        Iterator p2Iter = p2.iterator();
        while (p1Iter.hasNext()) {
            Path.Node p1Node = (Path.Node)p1Iter.next();
            if (!p2Iter.hasNext()) {
                return false;
            }
            Path.Node p2Node = (Path.Node)p2Iter.next();
            if (p1Node.equals(p2Node)) continue;
            return false;
        }
        return true;
    }

    private boolean isAlreadyValidatedForCurrentGroup(Object value, Class<?> group) {
        IdentitySet objectsProcessedInCurrentGroups = this.processedObjects.get(group);
        return objectsProcessedInCurrentGroups != null && objectsProcessedInCurrentGroups.contains(value);
    }

    private void markProcessedForCurrentPath(Object value, PathImpl path) {
        if (this.processedPaths.containsKey(value)) {
            this.processedPaths.get(value).add(path);
        } else {
            HashSet<PathImpl> set = new HashSet<PathImpl>();
            set.add(path);
            this.processedPaths.put(value, set);
        }
    }

    private void markProcessedForCurrentGroup(Object value, Class<?> group) {
        if (this.processedObjects.containsKey(group)) {
            this.processedObjects.get(group).add(value);
        } else {
            IdentitySet set = new IdentitySet();
            set.add(value);
            this.processedObjects.put(group, set);
        }
    }

    public static class ValidationContextBuilder {
        private final BeanMetaDataManager beanMetaDataManager;
        private final ConstraintValidatorManager constraintValidatorManager;
        private final MessageInterpolator messageInterpolator;
        private final ConstraintValidatorFactory constraintValidatorFactory;
        private final TraversableResolver traversableResolver;
        private final boolean failFast;

        private ValidationContextBuilder(BeanMetaDataManager beanMetaDataManager, ConstraintValidatorManager constraintValidatorManager, MessageInterpolator messageInterpolator, ConstraintValidatorFactory constraintValidatorFactory, TraversableResolver traversableResolver, boolean failFast) {
            this.beanMetaDataManager = beanMetaDataManager;
            this.constraintValidatorManager = constraintValidatorManager;
            this.messageInterpolator = messageInterpolator;
            this.constraintValidatorFactory = constraintValidatorFactory;
            this.traversableResolver = traversableResolver;
            this.failFast = failFast;
        }

        public <T> ValidationContext<T> forValidate(T rootBean) {
            Class<?> rootBeanClass = rootBean.getClass();
            return new ValidationContext(this.beanMetaDataManager, this.constraintValidatorManager, this.messageInterpolator, this.constraintValidatorFactory, this.traversableResolver, null, this.failFast, rootBean, rootBeanClass, null, null, null);
        }

        public <T> ValidationContext<T> forValidateProperty(T rootBean) {
            Class<?> rootBeanClass = rootBean.getClass();
            return new ValidationContext(this.beanMetaDataManager, this.constraintValidatorManager, this.messageInterpolator, this.constraintValidatorFactory, this.traversableResolver, null, this.failFast, rootBean, rootBeanClass, null, null, null);
        }

        public <T> ValidationContext<T> forValidateValue(Class<T> rootBeanClass) {
            return new ValidationContext(this.beanMetaDataManager, this.constraintValidatorManager, this.messageInterpolator, this.constraintValidatorFactory, this.traversableResolver, null, this.failFast, null, rootBeanClass, null, null, null);
        }

        public <T> ValidationContext<T> forValidateParameters(ParameterNameProvider parameterNameProvider, T rootBean, ExecutableElement executable, Object[] executableParameters) {
            Class<?> rootBeanClass = rootBean != null ? rootBean.getClass() : executable.getMember().getDeclaringClass();
            return new ValidationContext(this.beanMetaDataManager, this.constraintValidatorManager, this.messageInterpolator, this.constraintValidatorFactory, this.traversableResolver, parameterNameProvider, this.failFast, rootBean, rootBeanClass, executable, executableParameters, null);
        }

        public <T> ValidationContext<T> forValidateReturnValue(T rootBean, ExecutableElement executable, Object executableReturnValue) {
            Class<?> rootBeanClass = rootBean != null ? rootBean.getClass() : executable.getMember().getDeclaringClass();
            return new ValidationContext(this.beanMetaDataManager, this.constraintValidatorManager, this.messageInterpolator, this.constraintValidatorFactory, this.traversableResolver, null, this.failFast, rootBean, rootBeanClass, executable, null, executableReturnValue);
        }
    }
}

