/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.cdi;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedCallable;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessBean;
import javax.enterprise.inject.spi.WithAnnotations;
import javax.enterprise.util.AnnotationLiteral;
import javax.validation.BootstrapConfiguration;
import javax.validation.Configuration;
import javax.validation.Constraint;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.executable.ExecutableType;
import javax.validation.executable.ValidateExecutable;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import org.hibernate.validator.cdi.HibernateValidator;
import org.hibernate.validator.internal.cdi.ValidatorBean;
import org.hibernate.validator.internal.cdi.ValidatorFactoryBean;
import org.hibernate.validator.internal.cdi.interceptor.ValidationEnabledAnnotatedType;
import org.hibernate.validator.internal.cdi.interceptor.ValidationInterceptor;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.Contracts;
import org.hibernate.validator.internal.util.ReflectionHelper;

public class ValidationExtension
implements Extension {
    private static final EnumSet<ExecutableType> ALL_EXECUTABLE_TYPES = EnumSet.of(ExecutableType.CONSTRUCTORS, ExecutableType.NON_GETTER_METHODS, ExecutableType.GETTER_METHODS);
    private final Validator validator;
    private final Set<ExecutableType> globalExecutableTypes;
    private boolean validatorRegisteredUnderDefaultQualifier = false;
    private boolean validatorRegisteredUnderHibernateQualifier = false;

    public ValidationExtension() {
        Configuration<?> config = Validation.byDefaultProvider().configure();
        BootstrapConfiguration bootstrap = config.getBootstrapConfiguration();
        this.globalExecutableTypes = bootstrap.getValidatedExecutableTypes();
        this.validator = config.buildValidatorFactory().getValidator();
    }

    public void beforeBeanDiscovery(@Observes BeforeBeanDiscovery beforeBeanDiscoveryEvent, BeanManager beanManager) {
        Contracts.assertNotNull(beforeBeanDiscoveryEvent, "The BeforeBeanDiscovery event cannot be null");
        Contracts.assertNotNull(beanManager, "The BeanManager cannot be null");
        AnnotatedType annotatedType = beanManager.createAnnotatedType(ValidationInterceptor.class);
        beforeBeanDiscoveryEvent.addAnnotatedType(annotatedType);
    }

    public void afterBeanDiscovery(@Observes AfterBeanDiscovery afterBeanDiscoveryEvent, BeanManager beanManager) {
        Contracts.assertNotNull(afterBeanDiscoveryEvent, "The AfterBeanDiscovery event cannot be null");
        Contracts.assertNotNull(beanManager, "The BeanManager cannot be null");
        Set<Annotation> missingQualifiers = this.determineMissingQualifiers();
        if (missingQualifiers.isEmpty()) {
            return;
        }
        afterBeanDiscoveryEvent.addBean((Bean)new ValidatorFactoryBean(beanManager, missingQualifiers));
        afterBeanDiscoveryEvent.addBean((Bean)new ValidatorBean(beanManager, missingQualifiers));
    }

    public void processBean(@Observes ProcessBean<?> processBeanEvent) {
        Contracts.assertNotNull(processBeanEvent, "The ProcessBean event cannot be null");
        Bean bean = processBeanEvent.getBean();
        if (!bean.getTypes().contains(ValidatorFactory.class) && !bean.getTypes().contains(Validator.class)) {
            return;
        }
        if (bean instanceof ValidatorFactoryBean || bean instanceof ValidatorBean) {
            return;
        }
        for (Annotation annotation : bean.getQualifiers()) {
            if (HibernateValidator.class.equals(annotation.annotationType())) {
                this.validatorRegisteredUnderHibernateQualifier = true;
            }
            if (!Default.class.equals(annotation.annotationType())) continue;
            this.validatorRegisteredUnderDefaultQualifier = true;
        }
    }

    public <T> void processAnnotatedType(@Observes @WithAnnotations(value={Constraint.class, ValidateExecutable.class}) ProcessAnnotatedType<T> processAnnotatedTypeEvent) {
        Contracts.assertNotNull(processAnnotatedTypeEvent, "The ProcessAnnotatedType event cannot be null");
        AnnotatedType type = processAnnotatedTypeEvent.getAnnotatedType();
        EnumSet<ExecutableType> classLevelExecutableTypes = this.executableTypesForAnnotatedElement((Annotated)type);
        BeanDescriptor beanDescriptor = this.validator.getConstraintsForClass(type.getJavaClass());
        if (!beanDescriptor.hasConstrainedExecutables()) {
            return;
        }
        Set constrainedCallables = this.determineConstrainedCallables(type, beanDescriptor, classLevelExecutableTypes);
        if (!constrainedCallables.isEmpty()) {
            ValidationEnabledAnnotatedType wrappedType = new ValidationEnabledAnnotatedType(type, constrainedCallables);
            processAnnotatedTypeEvent.setAnnotatedType(wrappedType);
        }
    }

    private <T> Set<AnnotatedCallable<? super T>> determineConstrainedCallables(AnnotatedType<T> type, BeanDescriptor beanDescriptor, EnumSet<ExecutableType> classLevelExecutableTypes) {
        EnumSet<ExecutableType> memberLevelExecutableType;
        HashSet<AnnotatedCallable<T>> callables = CollectionHelper.newHashSet();
        for (AnnotatedConstructor annotatedConstructor : type.getConstructors()) {
            Constructor constructor = annotatedConstructor.getJavaMember();
            memberLevelExecutableType = this.executableTypesForAnnotatedElement((Annotated)annotatedConstructor);
            if (this.veto(classLevelExecutableTypes, memberLevelExecutableType, ExecutableType.CONSTRUCTORS) || beanDescriptor.getConstraintsForConstructor(constructor.getParameterTypes()) == null) continue;
            callables.add((AnnotatedCallable<T>)annotatedConstructor);
        }
        for (AnnotatedMethod annotatedMethod : type.getMethods()) {
            boolean needsValidation;
            boolean isGetter;
            ExecutableType currentExecutableType;
            Method method = annotatedMethod.getJavaMember();
            memberLevelExecutableType = this.executableTypesForAnnotatedElement((Annotated)annotatedMethod);
            if (this.veto(classLevelExecutableTypes, memberLevelExecutableType, currentExecutableType = (isGetter = ReflectionHelper.isGetterMethod(method)) ? ExecutableType.GETTER_METHODS : ExecutableType.NON_GETTER_METHODS) || !(needsValidation = isGetter ? this.isGetterConstrained(method, beanDescriptor) : this.isNonGetterConstrained(method, beanDescriptor))) continue;
            callables.add((AnnotatedCallable<T>)annotatedMethod);
        }
        return callables;
    }

    private boolean isNonGetterConstrained(Method method, BeanDescriptor beanDescriptor) {
        return beanDescriptor.getConstraintsForMethod(method.getName(), method.getParameterTypes()) != null;
    }

    private boolean isGetterConstrained(Method method, BeanDescriptor beanDescriptor) {
        String propertyName = ReflectionHelper.getPropertyName(method);
        PropertyDescriptor propertyDescriptor = beanDescriptor.getConstraintsForProperty(propertyName);
        return propertyDescriptor.findConstraints().declaredOn(ElementType.METHOD).hasConstraints();
    }

    private boolean veto(EnumSet<ExecutableType> classLevelExecutableTypes, EnumSet<ExecutableType> memberLevelExecutableType, ExecutableType currentExecutableType) {
        if (!memberLevelExecutableType.isEmpty()) {
            return !memberLevelExecutableType.contains((Object)currentExecutableType);
        }
        if (!classLevelExecutableTypes.isEmpty()) {
            return !classLevelExecutableTypes.contains((Object)currentExecutableType);
        }
        return !this.globalExecutableTypes.contains((Object)currentExecutableType);
    }

    private Set<Annotation> determineMissingQualifiers() {
        HashSet<Annotation> annotations = CollectionHelper.newHashSet(2);
        if (!this.validatorRegisteredUnderDefaultQualifier) {
            annotations.add((Annotation)new AnnotationLiteral<Default>(){});
        }
        if (!this.validatorRegisteredUnderHibernateQualifier) {
            annotations.add((Annotation)new AnnotationLiteral<HibernateValidator>(){});
        }
        return annotations;
    }

    private EnumSet<ExecutableType> executableTypesForAnnotatedElement(Annotated annotated) {
        if (!annotated.isAnnotationPresent(ValidateExecutable.class)) {
            return EnumSet.noneOf(ExecutableType.class);
        }
        ValidateExecutable executableAnnotation = (ValidateExecutable)annotated.getAnnotation(ValidateExecutable.class);
        EnumSet<ExecutableType> executableTypes = EnumSet.noneOf(ExecutableType.class);
        Collections.addAll(executableTypes, executableAnnotation.value());
        if (executableTypes.contains((Object)ExecutableType.ALL)) {
            return ALL_EXECUTABLE_TYPES;
        }
        if (executableTypes.contains((Object)ExecutableType.NONE) && executableTypes.size() > 1) {
            executableTypes.remove((Object)ExecutableType.NONE);
        }
        return executableTypes;
    }
}

