/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.descriptor;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.Constraint;
import javax.validation.ConstraintTarget;
import javax.validation.ConstraintValidator;
import javax.validation.OverridesAttribute;
import javax.validation.Payload;
import javax.validation.ReportAsSingleViolation;
import javax.validation.ValidationException;
import javax.validation.constraintvalidation.SupportedValidationTarget;
import javax.validation.constraintvalidation.ValidationTarget;
import javax.validation.groups.Default;
import javax.validation.metadata.ConstraintDescriptor;
import org.hibernate.validator.constraints.CompositionType;
import org.hibernate.validator.constraints.ConstraintComposition;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.internal.metadata.core.ConstraintOrigin;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.ReflectionHelper;
import org.hibernate.validator.internal.util.annotationfactory.AnnotationDescriptor;
import org.hibernate.validator.internal.util.annotationfactory.AnnotationFactory;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public class ConstraintDescriptorImpl<T extends Annotation>
implements ConstraintDescriptor<T>,
Serializable {
    private static final long serialVersionUID = -2563102960314069246L;
    private static final Log log = LoggerFactory.make();
    private static final int OVERRIDES_PARAMETER_DEFAULT_INDEX = -1;
    private static final String GROUPS = "groups";
    private static final String PAYLOAD = "payload";
    private static final String MESSAGE = "message";
    private static final String VALIDATION_APPLIES_TO = "validationAppliesTo";
    private static final List<String> NON_COMPOSING_CONSTRAINT_ANNOTATIONS = Arrays.asList(Documented.class.getName(), Retention.class.getName(), Target.class.getName(), Constraint.class.getName(), ReportAsSingleViolation.class.getName());
    private final T annotation;
    private final Class<T> annotationType;
    private final List<Class<? extends ConstraintValidator<T, ?>>> constraintValidatorDefinitionClasses;
    private final Class<? extends ConstraintValidator<T, ?>> crossParameterConstraintValidatorClass;
    private final List<Class<? extends ConstraintValidator<T, ?>>> matchingConstraintValidatorClasses;
    private final Set<Class<?>> groups;
    private final Map<String, Object> attributes;
    private final Set<Class<? extends Payload>> payloads;
    private final Set<ConstraintDescriptor<?>> composingConstraints;
    private final boolean isReportAsSingleInvalidConstraint;
    private final ElementType elementType;
    private final ConstraintOrigin definedOn;
    private final ConstraintType constraintType;
    private CompositionType compositionType = CompositionType.AND;

    public ConstraintDescriptorImpl(T annotation, ConstraintHelper constraintHelper, Class<?> implicitGroup, ElementType type, ConstraintOrigin definedOn, Member member) {
        this.annotation = annotation;
        this.annotationType = this.annotation.annotationType();
        this.elementType = type;
        this.definedOn = definedOn;
        this.isReportAsSingleInvalidConstraint = this.annotationType.isAnnotationPresent(ReportAsSingleViolation.class);
        this.attributes = this.buildAnnotationParameterMap((Annotation)annotation);
        this.groups = this.buildGroupSet(implicitGroup);
        this.payloads = this.buildPayloadSet(annotation);
        this.constraintValidatorDefinitionClasses = constraintHelper.getValidatorClasses(this.annotationType);
        this.crossParameterConstraintValidatorClass = this.findCrossParameterValidatorClass(this.constraintValidatorDefinitionClasses);
        List<Class<ConstraintValidator<T, ?>>> genericValidatorClasses = this.findGenericValidatorClasses(this.constraintValidatorDefinitionClasses);
        this.constraintType = this.determineConstraintType(member);
        this.composingConstraints = this.parseComposingConstraints(member, constraintHelper);
        if (this.constraintType == ConstraintType.GENERIC) {
            this.matchingConstraintValidatorClasses = Collections.unmodifiableList(genericValidatorClasses);
        } else {
            ArrayList validatorClasses = CollectionHelper.newArrayList();
            validatorClasses.add(this.crossParameterConstraintValidatorClass);
            this.matchingConstraintValidatorClasses = Collections.unmodifiableList(validatorClasses);
        }
    }

    public ConstraintDescriptorImpl(Member member, T annotation, ConstraintHelper constraintHelper, ElementType type, ConstraintOrigin definedOn) {
        this(annotation, constraintHelper, null, type, definedOn, member);
    }

    @Override
    public T getAnnotation() {
        return this.annotation;
    }

    public Class<T> getAnnotationType() {
        return this.annotationType;
    }

    @Override
    public String getMessageTemplate() {
        return (String)this.getAttributes().get(MESSAGE);
    }

    @Override
    public Set<Class<?>> getGroups() {
        return this.groups;
    }

    @Override
    public Set<Class<? extends Payload>> getPayload() {
        return this.payloads;
    }

    @Override
    public ConstraintTarget getValidationAppliesTo() {
        return (ConstraintTarget)((Object)this.attributes.get(VALIDATION_APPLIES_TO));
    }

    @Override
    public List<Class<? extends ConstraintValidator<T, ?>>> getConstraintValidatorClasses() {
        return this.constraintValidatorDefinitionClasses;
    }

    public List<Class<? extends ConstraintValidator<T, ?>>> getMatchingConstraintValidatorClasses() {
        return this.matchingConstraintValidatorClasses;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Override
    public Set<ConstraintDescriptor<?>> getComposingConstraints() {
        return this.composingConstraints;
    }

    @Override
    public boolean isReportAsSingleViolation() {
        return this.isReportAsSingleInvalidConstraint;
    }

    public ElementType getElementType() {
        return this.elementType;
    }

    public ConstraintOrigin getDefinedOn() {
        return this.definedOn;
    }

    public ConstraintType getConstraintType() {
        return this.constraintType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConstraintDescriptorImpl that = (ConstraintDescriptorImpl)o;
        return !(this.annotation != null ? !this.annotation.equals(that.annotation) : that.annotation != null);
    }

    public int hashCode() {
        return this.annotation != null ? this.annotation.hashCode() : 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ConstraintDescriptorImpl");
        sb.append("{annotation=").append(this.annotationType.getName());
        sb.append(", payloads=").append(this.payloads);
        sb.append(", hasComposingConstraints=").append(this.composingConstraints.isEmpty());
        sb.append(", isReportAsSingleInvalidConstraint=").append(this.isReportAsSingleInvalidConstraint);
        sb.append(", elementType=").append((Object)this.elementType);
        sb.append(", definedOn=").append((Object)this.definedOn);
        sb.append(", groups=").append(this.groups);
        sb.append(", attributes=").append(this.attributes);
        sb.append(", constraintType=").append((Object)this.constraintType);
        sb.append('}');
        return sb.toString();
    }

    private ConstraintType determineConstraintType(Member member) {
        if (this.crossParameterConstraintValidatorClass == null) {
            return ConstraintType.GENERIC;
        }
        int parameterCount = this.getParameterCount(member);
        boolean hasReturnValue = this.hasReturnValue(member);
        if (parameterCount == 0 && this.crossParameterValidatorOnly()) {
            if (member == null) {
                throw log.getCrossParameterConstraintOnClassException(this.annotationType.getName());
            }
            if (member instanceof Field) {
                throw log.getCrossParameterConstraintOnFieldException(this.annotationType.getName(), member.toString());
            }
            throw log.getCrossParameterConstraintOnMethodWithoutParametersException(this.annotationType.getName(), member.toString());
        }
        if (member == null || member instanceof Field) {
            return ConstraintType.GENERIC;
        }
        if (parameterCount > 0 && !hasReturnValue) {
            return ConstraintType.CROSS_PARAMETER;
        }
        if (parameterCount > 0 && hasReturnValue && this.crossParameterValidatorOnly()) {
            return ConstraintType.CROSS_PARAMETER;
        }
        if (!this.attributes.containsKey(VALIDATION_APPLIES_TO)) {
            throw log.getGenericAndCrossParameterValidatorWithoutConstraintTargetException(this.annotationType.getName());
        }
        ConstraintTarget constraintTarget = (ConstraintTarget)((Object)this.attributes.get(VALIDATION_APPLIES_TO));
        switch (constraintTarget) {
            case IMPLICIT: {
                throw log.getImplicitConstraintTargetInAmbiguousConfigurationException(this.annotationType.getName());
            }
            case RETURN_VALUE: {
                return ConstraintType.GENERIC;
            }
            case PARAMETERS: {
                return ConstraintType.CROSS_PARAMETER;
            }
        }
        throw log.getUnableToDetermineConstraintType(this.annotationType.getName());
    }

    private boolean crossParameterValidatorOnly() {
        return this.crossParameterConstraintValidatorClass != null && this.constraintValidatorDefinitionClasses.size() == 1 && !this.supportsValidationTarget(this.crossParameterConstraintValidatorClass, ValidationTarget.ANNOTATED_ELEMENT);
    }

    private int getParameterCount(Member member) {
        int parameterCount;
        if (member instanceof Constructor) {
            Constructor constructor = (Constructor)member;
            parameterCount = constructor.getParameterTypes().length;
        } else if (member instanceof Method) {
            Method method = (Method)member;
            parameterCount = method.getParameterTypes().length;
        } else {
            parameterCount = 0;
        }
        return parameterCount;
    }

    private boolean hasReturnValue(Member member) {
        Method method;
        boolean hasReturnValue = member instanceof Constructor ? true : (member instanceof Method ? (method = (Method)member).getGenericReturnType() != Void.TYPE : false);
        return hasReturnValue;
    }

    private Set<Class<? extends Payload>> buildPayloadSet(T annotation) {
        Class[] payloadFromAnnotation;
        HashSet payloadSet = CollectionHelper.newHashSet();
        try {
            payloadFromAnnotation = ReflectionHelper.getAnnotationParameter(annotation, PAYLOAD, Class[].class);
        }
        catch (ValidationException e) {
            payloadFromAnnotation = null;
        }
        if (payloadFromAnnotation != null) {
            payloadSet.addAll(Arrays.asList(payloadFromAnnotation));
        }
        return Collections.unmodifiableSet(payloadSet);
    }

    private Set<Class<?>> buildGroupSet(Class<?> implicitGroup) {
        HashSet groupSet = CollectionHelper.newHashSet();
        Class[] groupsFromAnnotation = ReflectionHelper.getAnnotationParameter(this.annotation, GROUPS, Class[].class);
        if (groupsFromAnnotation.length == 0) {
            groupSet.add(Default.class);
        } else {
            groupSet.addAll(Arrays.asList(groupsFromAnnotation));
        }
        if (implicitGroup != null && groupSet.contains(Default.class)) {
            groupSet.add(implicitGroup);
        }
        return Collections.unmodifiableSet(groupSet);
    }

    private Class<? extends ConstraintValidator<T, ?>> findCrossParameterValidatorClass(List<Class<? extends ConstraintValidator<T, ?>>> constraintValidatorDefinitionClasses) {
        Class<ConstraintValidator<T, ?>> crossParameterValidatorClass = null;
        boolean crossParameterValidatorFound = false;
        for (Class<ConstraintValidator<T, ?>> clazz : constraintValidatorDefinitionClasses) {
            if (crossParameterValidatorFound) {
                throw log.getMultipleCrossParameterValidatorClassesException(this.annotationType.getName());
            }
            crossParameterValidatorFound = this.supportsValidationTarget(clazz, ValidationTarget.PARAMETERS);
            if (!crossParameterValidatorFound) continue;
            crossParameterValidatorClass = clazz;
            crossParameterValidatorFound = true;
        }
        return crossParameterValidatorClass;
    }

    private List<Class<? extends ConstraintValidator<T, ?>>> findGenericValidatorClasses(List<Class<? extends ConstraintValidator<T, ?>>> constraintValidatorDefinitionClasses) {
        ArrayList<Class<ConstraintValidator<T, ?>>> genericValidatorClasses = CollectionHelper.newArrayList();
        for (Class<ConstraintValidator<T, ?>> clazz : constraintValidatorDefinitionClasses) {
            if (!this.supportsValidationTarget(clazz, ValidationTarget.ANNOTATED_ELEMENT)) continue;
            genericValidatorClasses.add(clazz);
        }
        return genericValidatorClasses;
    }

    private boolean supportsValidationTarget(Class<?> validatorClass, ValidationTarget target) {
        ValidationTarget[] targets;
        SupportedValidationTarget supportedTargetAnnotation = validatorClass.getAnnotation(SupportedValidationTarget.class);
        if (supportedTargetAnnotation == null) {
            return target == ValidationTarget.ANNOTATED_ELEMENT;
        }
        for (ValidationTarget configuredTarget : targets = supportedTargetAnnotation.value()) {
            if (!configuredTarget.equals((Object)target)) continue;
            return true;
        }
        return false;
    }

    private Map<String, Object> buildAnnotationParameterMap(Annotation annotation) {
        Method[] declaredMethods = ReflectionHelper.getDeclaredMethods(annotation.annotationType());
        HashMap<String, Object> parameters = CollectionHelper.newHashMap(declaredMethods.length);
        for (Method m : declaredMethods) {
            try {
                parameters.put(m.getName(), m.invoke((Object)annotation, new Object[0]));
            }
            catch (IllegalAccessException e) {
                throw log.getUnableToReadAnnotationAttributesException(annotation.getClass(), e);
            }
            catch (InvocationTargetException e) {
                throw log.getUnableToReadAnnotationAttributesException(annotation.getClass(), e);
            }
        }
        return Collections.unmodifiableMap(parameters);
    }

    private Object getMethodValue(Annotation annotation, Method m) {
        Object value;
        try {
            value = m.invoke((Object)annotation, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw log.getUnableToRetrieveAnnotationParameterValueException(e);
        }
        catch (InvocationTargetException e) {
            throw log.getUnableToRetrieveAnnotationParameterValueException(e);
        }
        return value;
    }

    private Map<ClassIndexWrapper, Map<String, Object>> parseOverrideParameters() {
        Method[] methods;
        HashMap<ClassIndexWrapper, Map<String, Object>> overrideParameters = CollectionHelper.newHashMap();
        for (Method m : methods = ReflectionHelper.getDeclaredMethods(this.annotationType)) {
            if (m.getAnnotation(OverridesAttribute.class) != null) {
                this.addOverrideAttributes(overrideParameters, m, m.getAnnotation(OverridesAttribute.class));
                continue;
            }
            if (m.getAnnotation(OverridesAttribute.List.class) == null) continue;
            this.addOverrideAttributes(overrideParameters, m, m.getAnnotation(OverridesAttribute.List.class).value());
        }
        return overrideParameters;
    }

    private void addOverrideAttributes(Map<ClassIndexWrapper, Map<String, Object>> overrideParameters, Method m, OverridesAttribute ... attributes) {
        Object value = this.getMethodValue((Annotation)this.annotation, m);
        for (OverridesAttribute overridesAttribute : attributes) {
            this.ensureAttributeIsOverridable(m, overridesAttribute);
            ClassIndexWrapper wrapper = new ClassIndexWrapper(overridesAttribute.constraint(), overridesAttribute.constraintIndex());
            Map<String, Object> map = overrideParameters.get(wrapper);
            if (map == null) {
                map = CollectionHelper.newHashMap();
                overrideParameters.put(wrapper, map);
            }
            map.put(overridesAttribute.name(), value);
        }
    }

    private void ensureAttributeIsOverridable(Method m, OverridesAttribute overridesAttribute) {
        Method method = ReflectionHelper.getMethod(overridesAttribute.constraint(), overridesAttribute.name());
        if (method == null) {
            throw log.getOverriddenConstraintAttributeNotFoundException(overridesAttribute.name());
        }
        Class<?> returnTypeOfOverriddenConstraint = method.getReturnType();
        if (!returnTypeOfOverriddenConstraint.equals(m.getReturnType())) {
            throw log.getWrongAttributeTypeForOverriddenConstraintException(returnTypeOfOverriddenConstraint.getName(), m.getReturnType());
        }
    }

    private Set<ConstraintDescriptor<?>> parseComposingConstraints(Member member, ConstraintHelper constraintHelper) {
        HashSet composingConstraintsSet = CollectionHelper.newHashSet();
        Map<ClassIndexWrapper, Map<String, Object>> overrideParameters = this.parseOverrideParameters();
        for (Annotation declaredAnnotation : this.annotationType.getDeclaredAnnotations()) {
            Class<? extends Annotation> declaredAnnotationType = declaredAnnotation.annotationType();
            if (NON_COMPOSING_CONSTRAINT_ANNOTATIONS.contains(declaredAnnotationType.getName())) continue;
            if (constraintHelper.isConstraintComposition(declaredAnnotationType)) {
                this.setCompositionType(((ConstraintComposition)declaredAnnotation).value());
                if (!log.isDebugEnabled()) continue;
                log.debugf("Adding Bool %s.", (Object)declaredAnnotationType.getName());
                continue;
            }
            if (constraintHelper.isConstraintAnnotation(declaredAnnotationType)) {
                ConstraintDescriptorImpl<Annotation> descriptor = this.createComposingConstraintDescriptor(member, declaredAnnotation, overrideParameters, -1, constraintHelper);
                composingConstraintsSet.add(descriptor);
                log.debugf("Adding composing constraint: %s.", (Object)descriptor);
                continue;
            }
            if (!constraintHelper.isMultiValueConstraint(declaredAnnotationType)) continue;
            List<Annotation> multiValueConstraints = constraintHelper.getMultiValueConstraints(declaredAnnotation);
            int index = 0;
            for (Annotation constraintAnnotation : multiValueConstraints) {
                ConstraintDescriptorImpl<Annotation> descriptor = this.createComposingConstraintDescriptor(member, constraintAnnotation, overrideParameters, index, constraintHelper);
                composingConstraintsSet.add(descriptor);
                log.debugf("Adding composing constraint: %s.", (Object)descriptor);
                ++index;
            }
        }
        return Collections.unmodifiableSet(composingConstraintsSet);
    }

    private <U extends Annotation> ConstraintDescriptorImpl<U> createComposingConstraintDescriptor(Member member, U declaredAnnotation, Map<ClassIndexWrapper, Map<String, Object>> overrideParameters, int index, ConstraintHelper constraintHelper) {
        Class<? extends Annotation> annotationType = declaredAnnotation.annotationType();
        return this.createComposingConstraintDescriptor(member, overrideParameters, index, declaredAnnotation, annotationType, constraintHelper);
    }

    private <U extends Annotation> ConstraintDescriptorImpl<U> createComposingConstraintDescriptor(Member member, Map<ClassIndexWrapper, Map<String, Object>> overrideParameters, int index, U constraintAnnotation, Class<U> annotationType, ConstraintHelper constraintHelper) {
        AnnotationDescriptor<U> annotationDescriptor = new AnnotationDescriptor<U>(annotationType, this.buildAnnotationParameterMap(constraintAnnotation));
        Map<String, Object> overrides = overrideParameters.get(new ClassIndexWrapper(annotationType, index));
        if (overrides != null) {
            for (Map.Entry<String, Object> entry : overrides.entrySet()) {
                annotationDescriptor.setValue(entry.getKey(), entry.getValue());
            }
        }
        annotationDescriptor.setValue(GROUPS, this.groups.toArray(new Class[this.groups.size()]));
        annotationDescriptor.setValue(PAYLOAD, this.payloads.toArray(new Class[this.payloads.size()]));
        if (annotationDescriptor.getElements().containsKey(VALIDATION_APPLIES_TO)) {
            annotationDescriptor.setValue(VALIDATION_APPLIES_TO, (Object)this.getValidationAppliesTo());
        }
        U annotationProxy = AnnotationFactory.create(annotationDescriptor);
        return new ConstraintDescriptorImpl<U>(member, annotationProxy, constraintHelper, this.elementType, this.definedOn);
    }

    private void setCompositionType(CompositionType compositionType) {
        this.compositionType = compositionType;
    }

    public CompositionType getCompositionType() {
        return this.compositionType;
    }

    public static enum ConstraintType {
        GENERIC,
        CROSS_PARAMETER;

    }

    private class ClassIndexWrapper {
        final Class<?> clazz;
        final int index;

        ClassIndexWrapper(Class<?> clazz, int index) {
            this.clazz = clazz;
            this.index = index;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassIndexWrapper that = (ClassIndexWrapper)o;
            if (this.index != that.index) {
                return false;
            }
            if (this.clazz != null && !this.clazz.equals(that.clazz)) {
                return false;
            }
            return this.clazz != null || that.clazz == null;
        }

        public int hashCode() {
            int result = this.clazz != null ? this.clazz.hashCode() : 0;
            result = 31 * result + this.index;
            return result;
        }
    }
}

