/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.core;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.Type;
import java.util.Set;
import org.hibernate.validator.internal.engine.ValidationContext;
import org.hibernate.validator.internal.engine.ValueContext;
import org.hibernate.validator.internal.engine.constraintvalidation.ConstraintTree;
import org.hibernate.validator.internal.metadata.descriptor.ConstraintDescriptorImpl;
import org.hibernate.validator.internal.metadata.location.ConstraintLocation;
import org.hibernate.validator.internal.util.ReflectionHelper;

public class MetaConstraint<A extends Annotation> {
    private final ConstraintTree<A> constraintTree;
    private final ConstraintDescriptorImpl<A> constraintDescriptor;
    private final ConstraintLocation location;

    public MetaConstraint(ConstraintDescriptorImpl<A> constraintDescriptor, ConstraintLocation location) {
        this.constraintTree = new ConstraintTree<A>(constraintDescriptor);
        this.constraintDescriptor = constraintDescriptor;
        this.location = location;
    }

    public final Set<Class<?>> getGroupList() {
        return this.constraintDescriptor.getGroups();
    }

    public final ConstraintDescriptorImpl<A> getDescriptor() {
        return this.constraintDescriptor;
    }

    public final ElementType getElementType() {
        return this.constraintDescriptor.getElementType();
    }

    public boolean validateConstraint(ValidationContext<?> executionContext, ValueContext<?, ?> valueContext) {
        valueContext.setElementType(this.getElementType());
        valueContext.setTypeOfAnnotatedElement(this.typeOfAnnotatedElement());
        return this.constraintTree.validateConstraints(executionContext, valueContext);
    }

    public ConstraintLocation getLocation() {
        return this.location;
    }

    protected final Type typeOfAnnotatedElement() {
        return this.location.typeOfAnnotatedElement();
    }

    public Object getValue(Object o) {
        if (this.location.getMember() == null) {
            return o;
        }
        return ReflectionHelper.getValue(this.location.getMember(), o);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetaConstraint that = (MetaConstraint)o;
        if (this.constraintDescriptor != null ? !this.constraintDescriptor.equals(that.constraintDescriptor) : that.constraintDescriptor != null) {
            return false;
        }
        return !(this.location != null ? !this.location.equals(that.location) : that.location != null);
    }

    public int hashCode() {
        int result = this.constraintDescriptor != null ? this.constraintDescriptor.hashCode() : 0;
        result = 31 * result + (this.location != null ? this.location.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MetaConstraint");
        sb.append("{constraintType=").append(this.constraintDescriptor.getAnnotation().annotationType().getName());
        sb.append(", location=").append(this.location);
        sb.append("}");
        return sb.toString();
    }
}

