/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.descriptor;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintDeclarationException;
import javax.validation.metadata.ConstructorDescriptor;
import javax.validation.metadata.CrossParameterDescriptor;
import javax.validation.metadata.MethodDescriptor;
import javax.validation.metadata.ParameterDescriptor;
import javax.validation.metadata.ReturnValueDescriptor;
import org.hibernate.validator.internal.metadata.descriptor.ConstraintDescriptorImpl;
import org.hibernate.validator.internal.metadata.descriptor.CrossParameterDescriptorImpl;
import org.hibernate.validator.internal.metadata.descriptor.ElementDescriptorImpl;

public class ExecutableDescriptorImpl
extends ElementDescriptorImpl
implements ConstructorDescriptor,
MethodDescriptor {
    private final String name;
    private final List<ParameterDescriptor> parameters;
    private final CrossParameterDescriptor crossParameterDescriptor;
    private final ReturnValueDescriptor returnValueDescriptor;
    private final ConstraintDeclarationException constraintDeclarationException;
    private final boolean isGetter;

    public ExecutableDescriptorImpl(Type returnType, String name, Set<ConstraintDescriptorImpl<?>> crossParameterConstraints, ReturnValueDescriptor returnValueDescriptor, List<ParameterDescriptor> parameters, boolean defaultGroupSequenceRedefined, boolean isGetter, List<Class<?>> defaultGroupSequence, ConstraintDeclarationException constraintDeclarationException) {
        super(returnType, Collections.<ConstraintDescriptorImpl<?>>emptySet(), defaultGroupSequenceRedefined, defaultGroupSequence);
        this.name = name;
        this.parameters = Collections.unmodifiableList(parameters);
        this.returnValueDescriptor = returnValueDescriptor;
        this.constraintDeclarationException = constraintDeclarationException;
        this.crossParameterDescriptor = new CrossParameterDescriptorImpl(crossParameterConstraints, defaultGroupSequenceRedefined, defaultGroupSequence);
        this.isGetter = isGetter;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<ParameterDescriptor> getParameterDescriptors() {
        return this.parameters;
    }

    @Override
    public ReturnValueDescriptor getReturnValueDescriptor() {
        return this.returnValueDescriptor;
    }

    @Override
    public boolean hasConstrainedParameters() {
        if (this.crossParameterDescriptor.hasConstraints()) {
            return true;
        }
        for (ParameterDescriptor oneParameter : this.parameters) {
            if (!oneParameter.hasConstraints() && !oneParameter.isCascaded()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasConstrainedReturnValue() {
        return this.returnValueDescriptor != null && (this.returnValueDescriptor.hasConstraints() || this.returnValueDescriptor.isCascaded());
    }

    @Override
    public CrossParameterDescriptor getCrossParameterDescriptor() {
        return this.crossParameterDescriptor;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ExecutableDescriptorImpl");
        sb.append("{name='").append(this.name).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public void assertCorrectnessOfConfiguration() throws ConstraintDeclarationException {
        if (this.constraintDeclarationException != null) {
            throw this.constraintDeclarationException;
        }
    }

    public boolean isGetter() {
        return this.isGetter;
    }
}

