/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.util.classfilter;

import org.hibernate.validator.internal.util.classfilter.ClassFilter;

public class ClassFilters {
    private static final ClassFilter PROXY_FILTER = new WeldProxyFilter();
    private static final ClassFilter INTERFACES_FILTER = new InterfacesFilter();

    public static ClassFilter excludingInterfaces() {
        return INTERFACES_FILTER;
    }

    public static ClassFilter excludingProxies() {
        return PROXY_FILTER;
    }

    private static class WeldProxyFilter
    implements ClassFilter {
        private static final String WELD_PROXY_INTERFACE_NAME = "org.jboss.weld.bean.proxy.ProxyObject";

        private WeldProxyFilter() {
        }

        @Override
        public boolean accepts(Class<?> clazz) {
            return !this.isWeldProxy(clazz);
        }

        private boolean isWeldProxy(Class<?> clazz) {
            for (Class<?> implementedInterface : clazz.getInterfaces()) {
                if (!implementedInterface.getName().equals(WELD_PROXY_INTERFACE_NAME)) continue;
                return true;
            }
            return false;
        }
    }

    private static class InterfacesFilter
    implements ClassFilter {
        private InterfacesFilter() {
        }

        @Override
        public boolean accepts(Class<?> clazz) {
            return !clazz.isInterface();
        }
    }
}

