/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.aggregated;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.validation.ElementKind;
import org.hibernate.validator.internal.metadata.aggregated.ConstraintMetaData;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.descriptor.ConstraintDescriptorImpl;
import org.hibernate.validator.internal.util.CollectionHelper;

public abstract class AbstractConstraintMetaData
implements ConstraintMetaData {
    private final String name;
    private final Type type;
    private final ElementKind constrainedMetaDataKind;
    private final Set<MetaConstraint<?>> constraints;
    private final boolean isCascading;
    private final boolean isConstrained;

    public AbstractConstraintMetaData(String name, Type type, Set<MetaConstraint<?>> constraints, ElementKind constrainedMetaDataKind, boolean isCascading, boolean isConstrained) {
        this.name = name;
        this.type = type;
        this.constraints = Collections.unmodifiableSet(constraints);
        this.constrainedMetaDataKind = constrainedMetaDataKind;
        this.isCascading = isCascading;
        this.isConstrained = isConstrained;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public Iterator<MetaConstraint<?>> iterator() {
        return this.constraints.iterator();
    }

    public Set<MetaConstraint<?>> getConstraints() {
        return this.constraints;
    }

    @Override
    public ElementKind getKind() {
        return this.constrainedMetaDataKind;
    }

    @Override
    public boolean isCascading() {
        return this.isCascading;
    }

    @Override
    public boolean isConstrained() {
        return this.isConstrained;
    }

    public String toString() {
        return "AbstractConstraintMetaData [name=" + this.name + ", constrainedMetaDataKind=" + (Object)((Object)this.constrainedMetaDataKind) + ", constraints=" + this.constraints + ", isCascading=" + this.isCascading + ", isConstrained=" + this.isConstrained + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractConstraintMetaData other = (AbstractConstraintMetaData)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    protected Set<ConstraintDescriptorImpl<?>> asDescriptors(Set<MetaConstraint<?>> constraints) {
        HashSet<ConstraintDescriptorImpl<?>> theValue = CollectionHelper.newHashSet();
        for (MetaConstraint<?> oneConstraint : constraints) {
            theValue.add(oneConstraint.getDescriptor());
        }
        return theValue;
    }
}

