/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.cfg.context;

import java.util.Map;
import org.hibernate.validator.cfg.context.Cascadable;
import org.hibernate.validator.cfg.context.GroupConversionTargetContext;
import org.hibernate.validator.cfg.context.Unwrapable;
import org.hibernate.validator.internal.cfg.context.ConstraintMappingContextImplBase;
import org.hibernate.validator.internal.cfg.context.DefaultConstraintMapping;
import org.hibernate.validator.internal.cfg.context.GroupConversionTargetContextImpl;
import org.hibernate.validator.internal.util.CollectionHelper;

abstract class CascadableConstraintMappingContextImplBase<C extends Cascadable<C> & Unwrapable<C>>
extends ConstraintMappingContextImplBase
implements Cascadable<C>,
Unwrapable<C> {
    protected boolean isCascading;
    protected Map<Class<?>, Class<?>> groupConversions = CollectionHelper.newHashMap();
    private boolean unwrapValidatedValue;

    CascadableConstraintMappingContextImplBase(DefaultConstraintMapping mapping) {
        super(mapping);
    }

    protected abstract C getThis();

    public void addGroupConversion(Class<?> from, Class<?> to) {
        this.groupConversions.put(from, to);
    }

    @Override
    public C valid() {
        this.isCascading = true;
        return this.getThis();
    }

    @Override
    public GroupConversionTargetContext<C> convertGroup(Class<?> from) {
        return new GroupConversionTargetContextImpl<C>(from, this.getThis(), this);
    }

    public boolean isCascading() {
        return this.isCascading;
    }

    public Map<Class<?>, Class<?>> getGroupConversions() {
        return this.groupConversions;
    }

    @Override
    public C unwrapValidatedValue() {
        this.unwrapValidatedValue = true;
        return this.getThis();
    }

    boolean isUnwrapValidatedValue() {
        return this.unwrapValidatedValue;
    }
}

