/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.visualizer.hk2;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DotGenerator {
    private static final boolean DEBUG = false;
    PrintStream wireOut = null;
    GeneratorOptions options = null;
    private Document doc = null;

    public DotGenerator(GeneratorOptions go) throws Exception {
        this.options = go;
        this.wireOut = new PrintStream(new FileOutputStream(this.options.output));
        this.initXML();
        this.generate();
    }

    private void initXML() throws Exception {
        File file = new File(this.options.input);
        this.debug("file " + file);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        this.doc = db.parse(file);
        this.doc.getDocumentElement().normalize();
    }

    private PackageInfo[] getPackageXML() throws IOException {
        NodeList pkgLst = this.doc.getElementsByTagName("Package");
        this.debug("Package count:" + pkgLst.getLength());
        ArrayList<PackageInfo> pkgInfos = new ArrayList<PackageInfo>();
        for (int i = 0; i < pkgLst.getLength(); ++i) {
            Node pkgNode = pkgLst.item(i);
            if (pkgNode.getNodeType() != 1) continue;
            Element packageElement = (Element)pkgNode;
            NodeList ExportersList = packageElement.getElementsByTagName("Exporters");
            Element exporterElt = (Element)ExportersList.item(0);
            String exporter = exporterElt.getChildNodes().item(0).getNodeValue().trim();
            this.debug("Exporter : " + exporter);
            NodeList importersList = packageElement.getElementsByTagName("Importers");
            Element importerElt = (Element)importersList.item(0);
            String importers = importerElt.getChildNodes().item(0).getNodeValue().trim();
            this.debug("Importers : " + importers);
            String pkgName = packageElement.getAttribute("name").trim();
            this.debug("Package Name : " + pkgName);
            PackageInfo pkgInfo = new PackageInfo(pkgName, exporter, this.split(importers));
            pkgInfos.add(pkgInfo);
        }
        return pkgInfos.toArray(new PackageInfo[0]);
    }

    private void generate() throws Exception {
        PackageInfo[] pkgInfos;
        this.generateDotStart();
        for (PackageInfo pkgInfo : pkgInfos = this.getPackageXML()) {
            boolean matchNeeded;
            String matchString = this.options.match.trim();
            boolean bl = matchNeeded = !matchString.isEmpty();
            if (matchNeeded) {
                if (!pkgInfo.exportedBy.contains(matchString)) continue;
                this.generateDotEdge(pkgInfo.importedBy, pkgInfo.exportedBy, pkgInfo.packageName);
                continue;
            }
            this.generateDotEdge(pkgInfo.importedBy, pkgInfo.exportedBy, pkgInfo.packageName);
        }
        this.generateDotEnd();
    }

    private void debug(String s) {
    }

    private void debug(String text, String s) {
        this.debug(text, new String[]{s});
    }

    private void debug(String text, String[] arr) {
        StringBuffer sb = new StringBuffer(text);
        for (String s : arr) {
            sb.append(s).append(" , ");
        }
        this.debug(sb.toString());
    }

    public static void main(String[] args) throws Exception {
        GeneratorOptions options = new GeneratorOptions();
        CmdLineParser parser = new CmdLineParser((Object)options);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            System.err.println("java -jar program-name.jar [options...] arguments...");
            parser.printUsage((OutputStream)System.err);
            return;
        }
        new DotGenerator(options);
    }

    private void generateDotStart() {
        this.wireOut.println("digraph  wiring {");
        this.wireOut.println("node [color=grey, style=filled];");
        this.wireOut.println("node [fontname=\"Verdana\", size=\"30,30\"];");
        String date = DateFormat.getDateTimeInstance(2, 3).format(new Date());
        StringBuffer footer = new StringBuffer();
        footer.append("graph [ fontname = \"Arial\", fontsize = 26,style = \"bold\", ");
        footer.append("label = \"\\nGlassFish v3 OSGi bundle wiring relationship diagram");
        if (!this.options.match.trim().isEmpty()) {
            footer.append("\\n Filter: " + this.options.match.trim() + " bundles");
        }
        footer.append("\\nSun Microsystems");
        footer.append("\\n\\nDate: " + date + "\\n\", " + "ssize = \"30,60\" ];");
        this.wireOut.println(footer.toString());
    }

    private void generateDotEdge(String[] importedBy, String exportedBy, String pkg) {
        if (importedBy.length == 0) {
            return;
        }
        for (String s : importedBy) {
            if (s.equals(exportedBy)) continue;
            this.wireOut.println("\"" + s + "\" -> \"" + exportedBy + "\" [label =\"" + pkg + "\"" + "]");
        }
    }

    private void generateDotEnd() {
        this.wireOut.println("}");
    }

    private String[] split(String s) {
        StringTokenizer st = new StringTokenizer(s);
        ArrayList<String> l = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            l.add(st.nextToken());
        }
        return l.toArray(new String[0]);
    }

    class PackageInfo {
        String packageName;
        String exportedBy = null;
        String[] importedBy = null;

        public PackageInfo(String packageName, String exportedBy, String[] importedBy) {
            this.packageName = packageName;
            this.exportedBy = exportedBy;
            this.importedBy = importedBy;
        }
    }

    static class GeneratorOptions {
        @Option(name="-i", usage="Input Wires XML file")
        public String input = "wires.xml";
        @Option(name="-o", usage="Output DOT file", required=true)
        public String output;
        @Option(name="-m", usage="Show only packages that contains the specified substring")
        public String match = "";
        @Argument
        public List<String> arguments = new ArrayList<String>();

        GeneratorOptions() {
        }
    }
}

