/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.extras.interception.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.aopalliance.intercept.ConstructorInterceptor;
import org.aopalliance.intercept.MethodInterceptor;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.api.IndexedFilter;
import org.glassfish.hk2.api.InterceptionService;
import org.glassfish.hk2.api.IterableProvider;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.extras.interception.Intercepted;
import org.glassfish.hk2.extras.interception.Interceptor;
import org.glassfish.hk2.extras.interception.InterceptorOrderingService;
import org.glassfish.hk2.extras.interception.internal.ReflectionUtilities;

@Singleton
public class DefaultInterceptionService
implements InterceptionService {
    private static final IndexedFilter METHOD_FILTER = new IndexedFilter(){

        public boolean matches(Descriptor d) {
            return d.getQualifiers().contains(Interceptor.class.getName());
        }

        public String getAdvertisedContract() {
            return MethodInterceptor.class.getName();
        }

        public String getName() {
            return null;
        }
    };
    private static final IndexedFilter CONSTRUCTOR_FILTER = new IndexedFilter(){

        public boolean matches(Descriptor d) {
            return d.getQualifiers().contains(Interceptor.class.getName());
        }

        public String getAdvertisedContract() {
            return ConstructorInterceptor.class.getName();
        }

        public String getName() {
            return null;
        }
    };
    @Inject
    private ServiceLocator locator;
    @Inject
    private IterableProvider<InterceptorOrderingService> orderers;

    public Filter getDescriptorFilter() {
        return new Filter(){

            public boolean matches(Descriptor d) {
                return d.getQualifiers().contains(Intercepted.class.getName());
            }
        };
    }

    private List<MethodInterceptor> orderMethods(Method method, List<MethodInterceptor> current) {
        List<MethodInterceptor> retVal = current;
        for (InterceptorOrderingService orderer : this.orderers) {
            List<MethodInterceptor> returned;
            List<MethodInterceptor> given = Collections.unmodifiableList(retVal);
            try {
                returned = orderer.modifyMethodInterceptors(method, given);
            }
            catch (Throwable th) {
                returned = null;
            }
            if (returned == null || returned == given) continue;
            retVal = new ArrayList<MethodInterceptor>(returned);
        }
        return retVal;
    }

    private List<ConstructorInterceptor> orderConstructors(Constructor<?> constructor, List<ConstructorInterceptor> current) {
        List<ConstructorInterceptor> retVal = current;
        for (InterceptorOrderingService orderer : this.orderers) {
            List<ConstructorInterceptor> returned;
            List<ConstructorInterceptor> given = Collections.unmodifiableList(retVal);
            try {
                returned = orderer.modifyConstructorInterceptors(constructor, given);
            }
            catch (Throwable th) {
                returned = null;
            }
            if (returned == null || returned == given) continue;
            retVal = new ArrayList<ConstructorInterceptor>(returned);
        }
        return retVal;
    }

    public List<MethodInterceptor> getMethodInterceptors(Method method) {
        HashSet<String> allBindings = ReflectionUtilities.getAllBindingsFromMethod(method);
        List allInterceptors = this.locator.getAllServiceHandles((Filter)METHOD_FILTER);
        List<MethodInterceptor> retVal = new ArrayList<MethodInterceptor>(allInterceptors.size());
        for (ServiceHandle handle : allInterceptors) {
            MethodInterceptor interceptor;
            ActiveDescriptor ad = handle.getActiveDescriptor();
            if (!ad.isReified()) {
                ad = this.locator.reifyDescriptor((Descriptor)ad);
            }
            Class interceptorClass = ad.getImplementationClass();
            HashSet<String> allInterceptorBindings = ReflectionUtilities.getAllBindingsFromClass(interceptorClass);
            boolean found = false;
            for (String interceptorBinding : allInterceptorBindings) {
                if (!allBindings.contains(interceptorBinding)) continue;
                found = true;
                break;
            }
            if (!found || (interceptor = (MethodInterceptor)handle.getService()) == null) continue;
            retVal.add(interceptor);
        }
        retVal = this.orderMethods(method, retVal);
        return retVal;
    }

    public List<ConstructorInterceptor> getConstructorInterceptors(Constructor<?> constructor) {
        HashSet<String> allBindings = ReflectionUtilities.getAllBindingsFromConstructor(constructor);
        List allInterceptors = this.locator.getAllServiceHandles((Filter)CONSTRUCTOR_FILTER);
        List<ConstructorInterceptor> retVal = new ArrayList<ConstructorInterceptor>(allInterceptors.size());
        for (ServiceHandle handle : allInterceptors) {
            ConstructorInterceptor interceptor;
            ActiveDescriptor ad = handle.getActiveDescriptor();
            if (!ad.isReified()) {
                ad = this.locator.reifyDescriptor((Descriptor)ad);
            }
            Class interceptorClass = ad.getImplementationClass();
            HashSet<String> allInterceptorBindings = ReflectionUtilities.getAllBindingsFromClass(interceptorClass);
            boolean found = false;
            for (String interceptorBinding : allInterceptorBindings) {
                if (!allBindings.contains(interceptorBinding)) continue;
                found = true;
                break;
            }
            if (!found || (interceptor = (ConstructorInterceptor)handle.getService()) == null) continue;
            retVal.add(interceptor);
        }
        retVal = this.orderConstructors(constructor, retVal);
        return retVal;
    }
}

