/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.extras.operation.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.extras.operation.OperationHandle;
import org.glassfish.hk2.extras.operation.OperationIdentifier;
import org.glassfish.hk2.extras.operation.OperationState;
import org.glassfish.hk2.extras.operation.internal.SingleOperationManager;

public class OperationHandleImpl
implements OperationHandle {
    private final SingleOperationManager parent;
    private final OperationIdentifier identifier;
    private final Object operationLock;
    private OperationState state;
    private final HashSet<Long> activeThreads = new HashSet();
    private Object userData;

    OperationHandleImpl(SingleOperationManager parent, OperationIdentifier identifier, Object operationLock, ServiceLocator locator) {
        this.parent = parent;
        this.identifier = identifier;
        this.operationLock = operationLock;
        this.state = OperationState.SUSPENDED;
    }

    @Override
    public OperationIdentifier getIdentifier() {
        return this.identifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationState getState() {
        Object object = this.operationLock;
        synchronized (object) {
            return this.state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkState() {
        Object object = this.operationLock;
        synchronized (object) {
            if (OperationState.CLOSED.equals((Object)this.state)) {
                throw new IllegalStateException(this + " is closed");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Long> getActiveThreads() {
        Object object = this.operationLock;
        synchronized (object) {
            this.checkState();
            return Collections.unmodifiableSet(this.activeThreads);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void suspend(long threadId) {
        Object object = this.operationLock;
        synchronized (object) {
            this.checkState();
            this.parent.disassociateThread(threadId);
            if (this.activeThreads.remove(threadId) && this.activeThreads.isEmpty()) {
                this.state = OperationState.SUSPENDED;
            }
        }
    }

    @Override
    public void suspend() {
        this.suspend(Thread.currentThread().getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume(long threadId) throws IllegalStateException {
        Object object = this.operationLock;
        synchronized (object) {
            this.checkState();
            if (this.activeThreads.contains(threadId)) {
                return;
            }
            OperationHandleImpl existing = this.parent.getCurrentOperationOnThisThread(threadId);
            if (existing != null) {
                throw new IllegalStateException("The operation " + existing + " is active on " + threadId);
            }
            if (this.activeThreads.isEmpty()) {
                this.state = OperationState.ACTIVE;
            }
            this.activeThreads.add(threadId);
            this.parent.associateWithThread(threadId, this);
        }
    }

    @Override
    public void resume() throws IllegalStateException {
        this.resume(Thread.currentThread().getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeOperation() {
        Object object = this.operationLock;
        synchronized (object) {
            for (long threadId : this.activeThreads) {
                this.parent.disassociateThread(threadId);
            }
            this.activeThreads.clear();
            this.state = OperationState.CLOSED;
            this.parent.closeOperation(this);
        }
    }

    @Override
    public synchronized Object getOperationData() {
        return this.userData;
    }

    @Override
    public synchronized void setOperationData(Object data) {
        this.userData = data;
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof OperationHandleImpl)) {
            return false;
        }
        return this.identifier.equals(((OperationHandleImpl)o).identifier);
    }

    public String toString() {
        return "OperationHandleImpl(" + this.identifier + "," + System.identityHashCode(this) + ")";
    }
}

