/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.extras.operation.internal;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.extras.operation.OperationContext;
import org.glassfish.hk2.extras.operation.OperationIdentifier;
import org.glassfish.hk2.extras.operation.internal.OperationDescriptor;
import org.glassfish.hk2.extras.operation.internal.OperationHandleImpl;
import org.glassfish.hk2.extras.operation.internal.OperationIdentifierImpl;
import org.glassfish.hk2.extras.operation.internal.OperationManagerImpl;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;

public class SingleOperationManager {
    private static final String ID_PREAMBLE = "OperationIdentifier(";
    private final Object operationLock = new Object();
    private final OperationManagerImpl parent;
    private final Annotation scope;
    private final HashMap<OperationIdentifier, OperationHandleImpl> openScopes = new HashMap();
    private final HashMap<Long, OperationHandleImpl> threadToHandleMap = new HashMap();
    private final ServiceLocator locator;
    private long scopedIdentifier;
    private final ActiveDescriptor<?> operationDescriptor;

    SingleOperationManager(OperationManagerImpl parent, Annotation scope, ServiceLocator locator) {
        this.parent = parent;
        this.scope = scope;
        this.locator = locator;
        OperationContext found = null;
        for (OperationContext context : locator.getAllServices(OperationContext.class, new Annotation[0])) {
            if (!context.getScope().equals(scope.annotationType())) continue;
            found = context;
            break;
        }
        if (found == null) {
            throw new IllegalStateException("Could not find the OperationContext for scope " + scope);
        }
        found.setOperationManager(this);
        OperationDescriptor opDesc = new OperationDescriptor(scope, this);
        this.operationDescriptor = ServiceLocatorUtilities.addOneDescriptor((ServiceLocator)locator, (Descriptor)opDesc);
    }

    private OperationIdentifierImpl allocateNewIdentifier() {
        return new OperationIdentifierImpl(ID_PREAMBLE + this.scopedIdentifier++ + "," + this.scope.annotationType().getName() + ")", this.scope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationHandleImpl createOperation() {
        Object object = this.operationLock;
        synchronized (object) {
            OperationIdentifierImpl id = this.allocateNewIdentifier();
            OperationHandleImpl created = new OperationHandleImpl(this, id, this.operationLock, this.locator);
            this.openScopes.put(id, created);
            return created;
        }
    }

    void closeOperation(OperationHandleImpl closeMe) {
        this.openScopes.remove(closeMe.getIdentifier());
    }

    void associateWithThread(long threadId, OperationHandleImpl handle) {
        this.threadToHandleMap.put(threadId, handle);
    }

    OperationHandleImpl disassociateThread(long threadId) {
        return this.threadToHandleMap.remove(threadId);
    }

    OperationHandleImpl getCurrentOperationOnThisThread(long threadId) {
        return this.threadToHandleMap.get(threadId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationHandleImpl getCurrentOperationOnThisThread() {
        long threadId = Thread.currentThread().getId();
        Object object = this.operationLock;
        synchronized (object) {
            return this.getCurrentOperationOnThisThread(threadId);
        }
    }
}

