/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.extras.provides;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicInteger;

final class TypeUtils {
    private TypeUtils() {
        throw new AssertionError((Object)"This class cannot be instantiated");
    }

    static boolean containsTypeVariable(Type type) {
        Objects.requireNonNull(type);
        return new TypeVariableDetector().matches(type);
    }

    static Type resolveType(Type contextType, Type dependentType) {
        Objects.requireNonNull(contextType);
        Objects.requireNonNull(dependentType);
        TypeVariableMappings mappings = TypeVariableMappings.of(contextType);
        TypeVariableResolver resolver = new TypeVariableResolver(mappings);
        return resolver.resolve(dependentType);
    }

    private static Type newArrayType(Type componentType) {
        Objects.requireNonNull(componentType);
        return componentType instanceof Class ? Array.newInstance((Class)componentType, 0).getClass() : new GenericArrayTypeImpl(componentType);
    }

    private static final class GenericArrayTypeImpl
    implements GenericArrayType {
        private final Type genericComponentType;

        GenericArrayTypeImpl(Type genericComponentType) {
            this.genericComponentType = Objects.requireNonNull(genericComponentType);
        }

        @Override
        public Type getGenericComponentType() {
            return this.genericComponentType;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof GenericArrayType)) {
                return false;
            }
            GenericArrayType that = (GenericArrayType)object;
            return this.genericComponentType.equals(that.getGenericComponentType());
        }

        public int hashCode() {
            return this.genericComponentType.hashCode();
        }

        public String toString() {
            return this.genericComponentType.getTypeName() + "[]";
        }
    }

    private static final class ParameterizedTypeImpl
    implements ParameterizedType {
        private final Type ownerType;
        private final Class<?> rawType;
        private final Type[] actualTypeArguments;

        ParameterizedTypeImpl(Type ownerType, Class<?> rawType, Type[] actualTypeArguments) {
            this.ownerType = ownerType;
            this.rawType = Objects.requireNonNull(rawType);
            this.actualTypeArguments = Objects.requireNonNull(actualTypeArguments);
        }

        @Override
        public Type getOwnerType() {
            return this.ownerType;
        }

        @Override
        public Type getRawType() {
            return this.rawType;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return (Type[])this.actualTypeArguments.clone();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof ParameterizedType)) {
                return false;
            }
            ParameterizedType that = (ParameterizedType)object;
            return this.rawType.equals(that.getRawType()) && Objects.equals(this.ownerType, that.getOwnerType()) && Arrays.equals(this.actualTypeArguments, that.getActualTypeArguments());
        }

        public int hashCode() {
            return Arrays.hashCode(this.actualTypeArguments) ^ Objects.hashCode(this.ownerType) ^ this.rawType.hashCode();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.ownerType == null) {
                sb.append(this.rawType.getName());
            } else {
                sb.append(this.ownerType.getTypeName());
                sb.append("$");
                sb.append(this.rawType.getSimpleName());
            }
            if (this.actualTypeArguments.length == 0) {
                return sb.toString();
            }
            StringJoiner joiner = new StringJoiner(", ", "<", ">");
            for (Type typeArgument : this.actualTypeArguments) {
                joiner.add(typeArgument.getTypeName());
            }
            sb.append(joiner.toString());
            return sb.toString();
        }
    }

    private static final class WildcardTypeImpl
    implements WildcardType {
        private final Type[] lowerBounds;
        private final Type[] upperBounds;

        WildcardTypeImpl(Type[] lowerBounds, Type[] upperBounds) {
            this.lowerBounds = Objects.requireNonNull(lowerBounds);
            this.upperBounds = Objects.requireNonNull(upperBounds);
        }

        @Override
        public Type[] getLowerBounds() {
            return (Type[])this.lowerBounds.clone();
        }

        @Override
        public Type[] getUpperBounds() {
            return (Type[])this.upperBounds.clone();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof WildcardType)) {
                return false;
            }
            WildcardType that = (WildcardType)object;
            return Arrays.equals(this.lowerBounds, that.getLowerBounds()) && Arrays.equals(this.upperBounds, that.getUpperBounds());
        }

        public int hashCode() {
            return Arrays.hashCode(this.lowerBounds) ^ Arrays.hashCode(this.upperBounds);
        }

        public String toString() {
            if (this.lowerBounds.length > 0) {
                StringJoiner joiner = new StringJoiner(" & ", "? super ", "");
                for (Type bound : this.lowerBounds) {
                    joiner.add(bound.getTypeName());
                }
                return joiner.toString();
            }
            if (this.upperBounds.length == 0 || this.upperBounds[0] == Object.class) {
                return "?";
            }
            StringJoiner joiner = new StringJoiner(" & ", "? extends ", "");
            for (Type bound : this.upperBounds) {
                joiner.add(bound.getTypeName());
            }
            return joiner.toString();
        }
    }

    private static final class CapturedType
    implements TypeVariable<GenericDeclaration> {
        private static final AtomicInteger CAPTURE_NUMBER = new AtomicInteger();
        private final int id = CAPTURE_NUMBER.incrementAndGet();
        private final Type[] bounds;

        CapturedType(Type[] bounds) {
            this.bounds = Objects.requireNonNull(bounds);
        }

        @Override
        public Type[] getBounds() {
            return (Type[])this.bounds.clone();
        }

        @Override
        public GenericDeclaration getGenericDeclaration() {
            return CapturedType.class;
        }

        @Override
        public String getName() {
            return "capture#" + this.id + " of ?";
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            Objects.requireNonNull(annotationClass);
            return null;
        }

        @Override
        public Annotation[] getAnnotations() {
            return new Annotation[0];
        }

        @Override
        public Annotation[] getDeclaredAnnotations() {
            return new Annotation[0];
        }

        @Override
        public AnnotatedType[] getAnnotatedBounds() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            if (this.bounds.length == 0 || this.bounds[0] == Object.class) {
                return this.getName();
            }
            StringJoiner joiner = new StringJoiner(" & ", this.getName() + " extends ", "");
            for (Type bound : this.bounds) {
                joiner.add(bound.getTypeName());
            }
            return joiner.toString();
        }
    }

    private static final class TypeVariableResolver {
        private final TypeVariableMappings mappings;

        TypeVariableResolver(TypeVariableMappings mappings) {
            this.mappings = Objects.requireNonNull(mappings);
        }

        Type resolve(Type type) {
            Objects.requireNonNull(type);
            if (type instanceof TypeVariable) {
                return this.mappings.get(type);
            }
            if (type instanceof Class) {
                return type;
            }
            if (type instanceof WildcardType) {
                WildcardType wildcardType = (WildcardType)type;
                Type[] lowerBounds = wildcardType.getLowerBounds();
                Type[] upperBounds = wildcardType.getUpperBounds();
                return new WildcardTypeImpl(this.resolve(lowerBounds), this.resolve(upperBounds));
            }
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                Class rawType = (Class)parameterizedType.getRawType();
                Type[] typeArguments = parameterizedType.getActualTypeArguments();
                Type ownerType = parameterizedType.getOwnerType();
                return new ParameterizedTypeImpl(ownerType == null ? null : this.resolve(ownerType), rawType, this.resolve(typeArguments));
            }
            if (type instanceof GenericArrayType) {
                GenericArrayType arrayType = (GenericArrayType)type;
                Type componentType = arrayType.getGenericComponentType();
                return TypeUtils.newArrayType(this.resolve(componentType));
            }
            return type;
        }

        Type[] resolve(Type[] types) {
            Type[] resolved = new Type[types.length];
            Arrays.setAll(resolved, i -> this.resolve(types[i]));
            return resolved;
        }
    }

    private static final class TypeVariableMappings {
        private final Set<Type> seen = new HashSet<Type>();
        private final Map<TypeVariable<?>, Type> map = new HashMap();

        private TypeVariableMappings() {
        }

        static TypeVariableMappings of(Type contextType) {
            Objects.requireNonNull(contextType);
            Type invariantContextType = WildcardTransformer.INSTANCE.transform(contextType);
            TypeVariableMappings mappings = new TypeVariableMappings();
            mappings.add(invariantContextType);
            return mappings;
        }

        Type get(Type type) {
            Objects.requireNonNull(type);
            while (type instanceof TypeVariable && this.map.containsKey(type)) {
                type = this.map.get(type);
            }
            return type;
        }

        private void add(Type type) {
            Objects.requireNonNull(type);
            if (!this.seen.add(type)) {
                return;
            }
            if (type instanceof TypeVariable) {
                TypeVariable typeVariable = (TypeVariable)type;
                this.add(typeVariable.getBounds());
            } else if (type instanceof Class) {
                Class clazz = (Class)type;
                Type superclass = clazz.getGenericSuperclass();
                if (superclass != null) {
                    this.add(superclass);
                }
                this.add(clazz.getGenericInterfaces());
            } else if (type instanceof WildcardType) {
                WildcardType wildcardType = (WildcardType)type;
                this.add(wildcardType.getUpperBounds());
            } else if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                Class rawType = (Class)parameterizedType.getRawType();
                TypeVariable<Class<T>>[] typeParameters = rawType.getTypeParameters();
                Type[] typeArguments = parameterizedType.getActualTypeArguments();
                Type ownerType = parameterizedType.getOwnerType();
                for (int i = 0; i < typeParameters.length; ++i) {
                    this.map.putIfAbsent(typeParameters[i], typeArguments[i]);
                }
                this.add(rawType);
                if (ownerType != null) {
                    this.add(ownerType);
                }
            } else if (type instanceof GenericArrayType) {
                GenericArrayType arrayType = (GenericArrayType)type;
                Type componentType = arrayType.getGenericComponentType();
                this.add(componentType);
            }
        }

        private void add(Type[] types) {
            Objects.requireNonNull(types);
            for (Type type : types) {
                this.add(type);
            }
        }
    }

    private static class WildcardTransformer {
        static final WildcardTransformer INSTANCE = new WildcardTransformer();

        private WildcardTransformer() {
        }

        Type transform(Type type) {
            Objects.requireNonNull(type);
            if (type instanceof TypeVariable) {
                return type;
            }
            if (type instanceof Class) {
                return type;
            }
            if (type instanceof WildcardType) {
                WildcardType wildcardType = (WildcardType)((Object)type);
                return wildcardType.getLowerBounds().length > 0 ? type : this.newCapturedType(wildcardType.getUpperBounds());
            }
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)((Object)type);
                Class rawType = (Class)parameterizedType.getRawType();
                Type ownerType = parameterizedType.getOwnerType();
                TypeVariable[] typeParameters = rawType.getTypeParameters();
                Type[] typeArguments = parameterizedType.getActualTypeArguments();
                Type[] transformedTypeArguments = new Type[typeArguments.length];
                Arrays.setAll(transformedTypeArguments, i -> this.addBounds(typeParameters[i]).transform(typeArguments[i]));
                return new ParameterizedTypeImpl(ownerType == null ? null : INSTANCE.transform(ownerType), rawType, transformedTypeArguments);
            }
            if (type instanceof GenericArrayType) {
                GenericArrayType arrayType = (GenericArrayType)((Object)type);
                Type componentType = arrayType.getGenericComponentType();
                return TypeUtils.newArrayType(WildcardTransformer.INSTANCE.transform(componentType));
            }
            return type;
        }

        protected TypeVariable<?> newCapturedType(Type[] bounds) {
            Objects.requireNonNull(bounds);
            return new CapturedType(bounds);
        }

        private WildcardTransformer addBounds(final TypeVariable<?> typeVariable) {
            Objects.requireNonNull(typeVariable);
            return new WildcardTransformer(){

                @Override
                protected TypeVariable<?> newCapturedType(Type[] bounds) {
                    LinkedHashSet combinedBounds = new LinkedHashSet();
                    Collections.addAll(combinedBounds, bounds);
                    Collections.addAll(combinedBounds, typeVariable.getBounds());
                    if (combinedBounds.size() > 1) {
                        combinedBounds.remove(Object.class);
                    }
                    return super.newCapturedType(combinedBounds.toArray(new Type[0]));
                }
            };
        }
    }

    private static final class TypeVariableDetector {
        private final Set<Type> seen = new HashSet<Type>();

        private TypeVariableDetector() {
        }

        boolean matches(Type type) {
            Objects.requireNonNull(type);
            if (!this.seen.add(type)) {
                return false;
            }
            if (type instanceof TypeVariable) {
                return true;
            }
            if (type instanceof Class) {
                return false;
            }
            if (type instanceof WildcardType) {
                WildcardType wildcardType = (WildcardType)type;
                for (Type lowerBound : wildcardType.getLowerBounds()) {
                    if (!this.matches(lowerBound)) continue;
                    return true;
                }
                for (Type upperBound : wildcardType.getUpperBounds()) {
                    if (!this.matches(upperBound)) continue;
                    return true;
                }
                return false;
            }
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                Type ownerType = parameterizedType.getOwnerType();
                if (ownerType != null && this.matches(parameterizedType.getOwnerType())) {
                    return true;
                }
                for (Type argument : parameterizedType.getActualTypeArguments()) {
                    if (!this.matches(argument)) continue;
                    return true;
                }
                return false;
            }
            if (type instanceof GenericArrayType) {
                GenericArrayType genericArrayType = (GenericArrayType)type;
                return this.matches(genericArrayType.getGenericComponentType());
            }
            return false;
        }
    }
}

