/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.json.test.basic;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.configuration.hub.api.BeanDatabase;
import org.glassfish.hk2.configuration.hub.api.Hub;
import org.glassfish.hk2.configuration.hub.api.Instance;
import org.glassfish.hk2.configuration.hub.api.Type;
import org.glassfish.hk2.json.test.skillzbeans.JsonRootBean;
import org.glassfish.hk2.json.test.skillzbeans.SkillBean;
import org.glassfish.hk2.json.test.skillzbeans.SpecificSkillBean;
import org.glassfish.hk2.json.test.utilities.Utilities;
import org.glassfish.hk2.xml.api.XmlHk2ConfigurationBean;
import org.glassfish.hk2.xml.api.XmlRootHandle;
import org.glassfish.hk2.xml.api.XmlService;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class JsonParserTest {
    private static final String SKILLZ_FILE = "skillz.json";
    public static final String SKILLZ = "skillz";
    public static final String WEB = "web";
    public static final String DB = "database";
    private static final String HTML = "html";
    private static final String CSS = "css";
    private static final String SQL = "sql";
    private static final String NAME_TAG = "name";
    private static final String YEARS_TAG = "years";
    private static final String JSON_ROOT_TYPE = "/json-root-bean";
    private static final String JSON_ROOT_INSTANCE = "json-root-bean";
    private static final String SKILLZ_TYPE = "/json-root-bean/skillz";
    private static final String SKILLZ_INSTANCE = "json-root-bean.skillz";
    private static final String WEB_TYPE = "/json-root-bean/skillz/web";
    private static final String HTML_INSTANCE = "json-root-bean.skillz.html";
    private static final String CSS_INSTANCE = "json-root-bean.skillz.css";
    private static final String DB_TYPE = "/json-root-bean/skillz/database";
    private static final String SQL_INSTANCE = "json-root-bean.skillz.sql";

    @Test
    public void testBasicMarshal() throws Exception {
        ServiceLocator locator = Utilities.enableLocator(new Class[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        XmlService jsonService = (XmlService)locator.getService(XmlService.class, "JsonService", new Annotation[0]);
        Assert.assertNotNull((Object)jsonService);
        URL url = this.getClass().getClassLoader().getResource(SKILLZ_FILE);
        URI uri = url.toURI();
        XmlRootHandle skillBeanHandle = jsonService.unmarshal(uri, JsonRootBean.class);
        JsonParserTest.checkStandardDocument((XmlRootHandle<JsonRootBean>)skillBeanHandle, hub, locator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore
    public void testBasicUnmarshal() throws Exception {
        ServiceLocator locator = Utilities.enableLocator(new Class[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        XmlService jsonService = (XmlService)locator.getService(XmlService.class, "JsonService", new Annotation[0]);
        XmlRootHandle<JsonRootBean> rootHandle = JsonParserTest.createStandardDocument(jsonService, hub, locator);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            rootHandle.marshal((OutputStream)baos);
        }
        finally {
            baos.close();
        }
    }

    private static XmlRootHandle<JsonRootBean> createStandardDocument(XmlService jsonService, Hub hub, ServiceLocator locator) {
        XmlRootHandle retVal = jsonService.createEmptyHandle(JsonRootBean.class);
        retVal.addRoot();
        JsonRootBean root = (JsonRootBean)retVal.getRoot();
        SkillBean skillBean = (SkillBean)jsonService.createBean(SkillBean.class);
        root.setSkillz(skillBean);
        skillBean = root.getSkillz();
        skillBean.addWebBean(JsonParserTest.createSpecificSkillBean(jsonService, HTML, 5));
        skillBean.addWebBean(JsonParserTest.createSpecificSkillBean(jsonService, CSS, 3));
        skillBean.addDatabaseBean(JsonParserTest.createSpecificSkillBean(jsonService, SQL, 7));
        JsonParserTest.checkStandardDocument((XmlRootHandle<JsonRootBean>)retVal, hub, locator);
        return retVal;
    }

    private static SpecificSkillBean createSpecificSkillBean(XmlService jsonService, String name, int years) {
        SpecificSkillBean retVal = (SpecificSkillBean)jsonService.createBean(SpecificSkillBean.class);
        retVal.setName(name);
        retVal.setYears(years);
        return retVal;
    }

    private static void checkStandardDocument(XmlRootHandle<JsonRootBean> skillBeanHandle, Hub hub, ServiceLocator locator) {
        JsonRootBean root = (JsonRootBean)skillBeanHandle.getRoot();
        JsonParserTest.checkParent(root, null);
        Assert.assertNotNull((Object)locator.getService(JsonRootBean.class, new Annotation[0]));
        JsonParserTest.checkInHub(hub, JSON_ROOT_TYPE, JSON_ROOT_INSTANCE);
        SkillBean skillzBean = ((JsonRootBean)skillBeanHandle.getRoot()).getSkillz();
        JsonParserTest.checkParent(skillzBean, root);
        Assert.assertNotNull((Object)locator.getService(SkillBean.class, new Annotation[0]));
        JsonParserTest.checkInHub(hub, SKILLZ_TYPE, SKILLZ_INSTANCE);
        List<SpecificSkillBean> specificsList = skillzBean.getWebBean();
        Assert.assertEquals((long)2L, (long)specificsList.size());
        for (int lcv = 0; lcv < specificsList.size(); ++lcv) {
            HashMap<String, Object> fields;
            SpecificSkillBean specific = specificsList.get(lcv);
            JsonParserTest.checkParent(specific, skillzBean);
            if (lcv == 0) {
                Assert.assertEquals((Object)HTML, (Object)specific.getName());
                Assert.assertEquals((long)5L, (long)specific.getYears());
                Assert.assertNotNull((Object)locator.getService(SpecificSkillBean.class, HTML, new Annotation[0]));
                fields = new HashMap<String, Object>();
                fields.put(NAME_TAG, HTML);
                fields.put(YEARS_TAG, new Integer(5));
                JsonParserTest.checkInHub(hub, WEB_TYPE, HTML_INSTANCE, fields);
                continue;
            }
            if (lcv == 1) {
                Assert.assertEquals((Object)CSS, (Object)specific.getName());
                Assert.assertEquals((long)3L, (long)specific.getYears());
                Assert.assertNotNull((Object)locator.getService(SpecificSkillBean.class, CSS, new Annotation[0]));
                fields = new HashMap();
                fields.put(NAME_TAG, CSS);
                fields.put(YEARS_TAG, new Integer(3));
                JsonParserTest.checkInHub(hub, WEB_TYPE, CSS_INSTANCE, fields);
                continue;
            }
            Assert.fail((String)("Unknown index " + lcv));
        }
        SpecificSkillBean[] specifics = skillzBean.getDatabaseBean();
        Assert.assertEquals((long)1L, (long)specifics.length);
        for (int lcv = 0; lcv < specifics.length; ++lcv) {
            SpecificSkillBean specific = specifics[lcv];
            JsonParserTest.checkParent(specific, skillzBean);
            Assert.assertEquals((Object)SQL, (Object)specific.getName());
            Assert.assertEquals((long)7L, (long)specific.getYears());
            Assert.assertNotNull((Object)locator.getService(SpecificSkillBean.class, SQL, new Annotation[0]));
            HashMap<String, Object> fields = new HashMap<String, Object>();
            fields.put(NAME_TAG, SQL);
            fields.put(YEARS_TAG, new Integer(7));
            JsonParserTest.checkInHub(hub, DB_TYPE, SQL_INSTANCE, fields);
        }
    }

    private static void checkInHub(Hub hub, String type, String instance, Map<String, Object> fields) {
        BeanDatabase bd = hub.getCurrentDatabase();
        Type bdType = bd.getType(type);
        Assert.assertNotNull((String)("Did not find type of name " + type), (Object)bdType);
        Instance i = bdType.getInstance(instance);
        Assert.assertNotNull((String)("Did not find instance of name " + instance + " in type " + type), (Object)i);
        if (fields == null || fields.isEmpty()) {
            return;
        }
        Map bean = (Map)i.getBean();
        Assert.assertNotNull((Object)bean);
        for (Map.Entry<String, Object> entry : fields.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            Object fromBeanValue = bean.get(key);
            Assert.assertEquals((Object)value, fromBeanValue);
        }
    }

    private static void checkInHub(Hub hub, String type, String instance) {
        JsonParserTest.checkInHub(hub, type, instance, null);
    }

    private static void checkParent(Object bean, Object parent) {
        Assert.assertNotNull((Object)bean);
        Assert.assertTrue((boolean)(bean instanceof XmlHk2ConfigurationBean));
        XmlHk2ConfigurationBean configBean = (XmlHk2ConfigurationBean)bean;
        XmlHk2ConfigurationBean parentBean = null;
        if (parent != null) {
            Assert.assertTrue((boolean)(parent instanceof XmlHk2ConfigurationBean));
            parentBean = (XmlHk2ConfigurationBean)parent;
        }
        Assert.assertEquals(parentBean, (Object)configBean._getParent());
    }
}

