/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.json.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.net.URI;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;
import javax.json.stream.JsonParser;
import javax.xml.bind.Unmarshaller;
import org.glassfish.hk2.api.Rank;
import org.glassfish.hk2.xml.api.XmlRootHandle;
import org.glassfish.hk2.xml.api.XmlService;
import org.glassfish.hk2.xml.internal.ChildDataModel;
import org.glassfish.hk2.xml.internal.ChildDescriptor;
import org.glassfish.hk2.xml.internal.ChildType;
import org.glassfish.hk2.xml.internal.ModelImpl;
import org.glassfish.hk2.xml.internal.ParentedModel;
import org.glassfish.hk2.xml.internal.Utilities;
import org.glassfish.hk2.xml.jaxb.internal.BaseHK2JAXBBean;
import org.glassfish.hk2.xml.spi.Model;
import org.glassfish.hk2.xml.spi.PreGenerationRequirement;
import org.glassfish.hk2.xml.spi.XmlServiceParser;

@Singleton
@Named(value="JsonService")
@Rank(value=-1)
public class JsonParser
implements XmlServiceParser {
    @Inject
    @Named(value="JsonService")
    private Provider<XmlService> xmlService;

    private void skipper(javax.json.stream.JsonParser parser) {
        if (!parser.hasNext()) {
            return;
        }
        while (true) {
            JsonParser.Event event = parser.next();
            switch (event) {
                case KEY_NAME: 
                case VALUE_FALSE: 
                case VALUE_TRUE: 
                case VALUE_NULL: 
                case VALUE_STRING: 
                case VALUE_NUMBER: {
                    break;
                }
                case START_OBJECT: 
                case START_ARRAY: {
                    this.skipper(parser);
                    break;
                }
                case END_OBJECT: 
                case END_ARRAY: {
                    return;
                }
            }
        }
    }

    private void parseObject(ModelImpl currentModel, BaseHK2JAXBBean target, BaseHK2JAXBBean parent, Unmarshaller.Listener listener, javax.json.stream.JsonParser parser) {
        try {
            listener.beforeUnmarshal((Object)target, (Object)parent);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Throwable th) {
            throw new RuntimeException(th);
        }
        if (!parser.hasNext()) {
            throw new IllegalStateException("Expectin an end token from Json parser");
        }
        boolean getNextEvent = true;
        do {
            JsonParser.Event event = parser.next();
            block2 : switch (event) {
                case END_OBJECT: {
                    try {
                        listener.afterUnmarshal((Object)target, (Object)parent);
                    }
                    catch (RuntimeException re) {
                        throw re;
                    }
                    catch (Throwable th) {
                        throw new RuntimeException(th);
                    }
                    getNextEvent = false;
                    break;
                }
                case KEY_NAME: {
                    String keyName = parser.getString();
                    ChildDescriptor descriptor = currentModel.getChildDescriptor(keyName);
                    if (descriptor == null) {
                        this.skipper(parser);
                        break;
                    }
                    ParentedModel parentedModel = descriptor.getParentedModel();
                    if (parentedModel == null) {
                        ChildDataModel childDataModel = descriptor.getChildDataModel();
                        JsonParser.Event attributeEvent = parser.next();
                        switch (attributeEvent) {
                            case VALUE_STRING: {
                                target._setProperty(keyName, (Object)parser.getString());
                                break block2;
                            }
                            case VALUE_NUMBER: {
                                if (parser.isIntegralNumber()) {
                                    target._setProperty(keyName, (Object)new Integer(parser.getInt()));
                                    break block2;
                                }
                                target._setProperty(keyName, (Object)new Long(parser.getLong()));
                                break block2;
                            }
                            case VALUE_NULL: {
                                target._setProperty(keyName, null);
                                break block2;
                            }
                            case VALUE_TRUE: {
                                target._setProperty(keyName, (Object)Boolean.TRUE);
                                break block2;
                            }
                            case VALUE_FALSE: {
                                target._setProperty(keyName, (Object)Boolean.FALSE);
                                break block2;
                            }
                        }
                        throw new IllegalStateException("Uknown value type: " + attributeEvent + " for " + childDataModel + " for " + currentModel);
                    }
                    ModelImpl childModel = parentedModel.getChildModel();
                    JsonParser.Event childTypeEvent = parser.next();
                    if (JsonParser.Event.START_ARRAY.equals((Object)childTypeEvent)) {
                        JsonParser.Event arrayEvent;
                        LinkedList<BaseHK2JAXBBean> myList = new LinkedList<BaseHK2JAXBBean>();
                        while (!JsonParser.Event.END_ARRAY.equals((Object)(arrayEvent = parser.next()))) {
                            if (!JsonParser.Event.START_OBJECT.equals((Object)arrayEvent)) {
                                throw new AssertionError((Object)("Do not know how to handle this case inside an array expecting an object" + arrayEvent));
                            }
                            BaseHK2JAXBBean oneChild = Utilities.createBean((Class)childModel.getProxyAsClass());
                            this.parseObject(childModel, oneChild, target, listener, parser);
                            myList.add(oneChild);
                        }
                        if (ChildType.LIST.equals((Object)parentedModel.getChildType())) {
                            target._setProperty(keyName, myList);
                            break;
                        }
                        if (ChildType.ARRAY.equals((Object)parentedModel.getChildType())) {
                            Object array = Array.newInstance(childModel.getOriginalInterfaceAsClass(), myList.size());
                            int lcv = 0;
                            for (BaseHK2JAXBBean bean : myList) {
                                Array.set(array, lcv, bean);
                                ++lcv;
                            }
                            target._setProperty(keyName, array);
                            break;
                        }
                        throw new AssertionError((Object)"The model says DIRECT but I got an ARRAY start so bombing quite badly");
                    }
                    if (JsonParser.Event.START_OBJECT.equals((Object)childTypeEvent)) {
                        if (!ChildType.DIRECT.equals((Object)parentedModel.getChildType())) {
                            throw new AssertionError((Object)("The model says " + parentedModel.getChildType() + " but I got an START_OBJECT start so bombing quite badly"));
                        }
                        BaseHK2JAXBBean oneChild = Utilities.createBean((Class)childModel.getProxyAsClass());
                        this.parseObject(childModel, oneChild, target, listener, parser);
                        target._setProperty(keyName, (Object)oneChild);
                        break;
                    }
                    throw new IllegalStateException("Unknown start of child event: " + event);
                }
                default: {
                    throw new IllegalArgumentException("Unkown event: " + event);
                }
            }
        } while (getNextEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T parseRoot(Model rootModel, URI location, Unmarshaller.Listener listener) throws Exception {
        InputStream input = location.toURL().openStream();
        try {
            T t = this.parseRoot(rootModel, input, listener);
            return t;
        }
        finally {
            input.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T parseRoot(Model rootModel, InputStream input, Unmarshaller.Listener listener) throws Exception {
        javax.json.stream.JsonParser parser = Json.createParser((InputStream)input);
        try {
            if (!parser.hasNext()) {
                BaseHK2JAXBBean root = Utilities.createBean((Class)rootModel.getProxyAsClass());
                listener.beforeUnmarshal((Object)root, null);
                listener.afterUnmarshal((Object)root, null);
                BaseHK2JAXBBean baseHK2JAXBBean = root;
                return (T)baseHK2JAXBBean;
            }
            JsonParser.Event event = parser.next();
            if (!JsonParser.Event.START_OBJECT.equals((Object)event)) {
                throw new AssertionError((Object)("Unknown start of JSON object: " + event));
            }
            BaseHK2JAXBBean root = Utilities.createBean((Class)rootModel.getProxyAsClass());
            this.parseObject((ModelImpl)rootModel, root, null, listener, parser);
            BaseHK2JAXBBean baseHK2JAXBBean = root;
            return (T)baseHK2JAXBBean;
        }
        finally {
            parser.close();
        }
    }

    public PreGenerationRequirement getPreGenerationRequirement() {
        return PreGenerationRequirement.LAZY_PREGENERATION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void marshal(OutputStream outputStream, XmlRootHandle<T> rootHandle) throws IOException {
        JsonObjectBuilder objectBuilder = Json.createObjectBuilder();
        Object root = rootHandle.getRoot();
        JsonObject rootObject = this.createJsonObject((BaseHK2JAXBBean)root, objectBuilder);
        HashMap<String, Boolean> config = new HashMap<String, Boolean>();
        config.put("javax.json.stream.JsonGenerator.prettyPrinting", Boolean.TRUE);
        JsonWriterFactory writerFactory = Json.createWriterFactory(config);
        JsonWriter writer = writerFactory.createWriter(outputStream);
        try {
            writer.writeObject(rootObject);
        }
        finally {
            writer.close();
        }
    }

    private JsonObject createJsonObject(BaseHK2JAXBBean bean, JsonObjectBuilder builder) {
        if (bean == null) {
            return builder.build();
        }
        ModelImpl model = bean._getModel();
        Map allChildren = model.getAllChildrenDescriptors();
        for (Map.Entry entry : allChildren.entrySet()) {
            String keyName = (String)entry.getKey();
            if (!bean._isSet(keyName)) continue;
            Object value = bean._getProperty(keyName);
            ParentedModel parented = ((ChildDescriptor)entry.getValue()).getParentedModel();
            if (parented != null) {
                JsonObject obj;
                JsonObjectBuilder childBuilder;
                JsonArrayBuilder jsonArray;
                if (ChildType.DIRECT.equals((Object)parented.getChildType())) {
                    if (value == null) continue;
                    builder = builder.add(keyName, (JsonValue)this.createJsonObject((BaseHK2JAXBBean)value, Json.createObjectBuilder()));
                    continue;
                }
                if (ChildType.LIST.equals((Object)parented.getChildType())) {
                    List list = (List)value;
                    if (list == null || list.isEmpty()) continue;
                    jsonArray = Json.createArrayBuilder();
                    for (BaseHK2JAXBBean item : list) {
                        childBuilder = Json.createObjectBuilder();
                        obj = this.createJsonObject(item, childBuilder);
                        jsonArray.add((JsonValue)obj);
                    }
                    builder.add(keyName, jsonArray);
                    continue;
                }
                if (ChildType.ARRAY.equals((Object)parented.getChildType())) {
                    int length = Array.getLength(value);
                    if (length <= 0) continue;
                    jsonArray = Json.createArrayBuilder();
                    for (int lcv = 0; lcv < length; ++lcv) {
                        BaseHK2JAXBBean item;
                        item = (BaseHK2JAXBBean)Array.get(value, lcv);
                        childBuilder = Json.createObjectBuilder();
                        obj = this.createJsonObject(item, childBuilder);
                        jsonArray.add((JsonValue)obj);
                    }
                    builder.add(keyName, jsonArray);
                    continue;
                }
                throw new AssertionError((Object)("Unknown childType " + parented.getChildType()));
            }
            if (value == null) {
                builder.addNull(keyName);
                continue;
            }
            if (value instanceof Integer) {
                builder.add(keyName, ((Integer)value).intValue());
                continue;
            }
            if (value instanceof Long) {
                builder.add(keyName, ((Long)value).longValue());
                continue;
            }
            if (value instanceof Boolean) {
                builder.add(keyName, ((Boolean)value).booleanValue());
                continue;
            }
            builder.add(keyName, value.toString());
        }
        return builder.build();
    }
}

