/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.testing.junit.internal;

import java.util.LinkedList;
import javax.inject.Named;
import javax.inject.Qualifier;
import javax.inject.Scope;
import javax.inject.Singleton;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.utilities.DescriptorImpl;
import org.jvnet.hk2.annotations.Contract;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class ClassVisitorImpl
implements ClassVisitor {
    private static final String SERVICE_CLASS_FORM = "Lorg/jvnet/hk2/annotations/Service;";
    private static final String NAME = "name";
    private static final String VALUE = "value";
    private final DynamicConfiguration config;
    private final boolean verbose;
    private String implName;
    private final LinkedList<String> iFaces = new LinkedList();
    private Class<?> scopeClass;
    private final LinkedList<String> qualifiers = new LinkedList();
    private boolean isAService = false;
    private String name;

    public ClassVisitorImpl(DynamicConfiguration config, boolean verbose) {
        this.config = config;
        this.verbose = verbose;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.implName = name.replace("/", ".");
        for (String i : interfaces) {
            String iFace = i.replace("/", ".");
            try {
                Class<?> iClass = this.getClass().getClassLoader().loadClass(iFace);
                if (!iClass.isAnnotationPresent(Contract.class)) continue;
                this.iFaces.add(iClass.getName());
            }
            catch (Throwable th) {
                // empty catch block
            }
        }
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        Class<?> annoClass;
        if (!visible) {
            return null;
        }
        if (SERVICE_CLASS_FORM.equals(desc)) {
            this.isAService = true;
            return new ServiceAnnotationVisitor();
        }
        if (!desc.startsWith("L")) {
            return null;
        }
        String loadQualifierName = desc.substring(1, desc.length() - 1).replace("/", ".");
        try {
            annoClass = Class.forName(loadQualifierName);
        }
        catch (Throwable th) {
            return null;
        }
        if (annoClass.isAnnotationPresent(Scope.class)) {
            this.scopeClass = annoClass;
        } else if (annoClass.isAnnotationPresent(Qualifier.class)) {
            this.qualifiers.add(annoClass.getName());
            if (Named.class.equals(annoClass)) {
                return new NamedAnnotationVisitor(this.getDefaultName());
            }
        }
        return null;
    }

    private String getDefaultName() {
        int index = this.implName.lastIndexOf(46);
        if (index <= 0) {
            return this.implName;
        }
        return this.implName.substring(index + 1);
    }

    public void visitAttribute(Attribute arg0) {
    }

    public void visitEnd() {
        if (!this.isAService) {
            return;
        }
        DescriptorImpl di = new DescriptorImpl();
        di.setImplementation(this.implName);
        if (this.scopeClass == null) {
            di.setScope(Singleton.class.getName());
        } else {
            di.setScope(this.scopeClass.getName());
        }
        di.addAdvertisedContract(this.implName);
        for (String iFace : this.iFaces) {
            di.addAdvertisedContract(iFace);
        }
        for (String qualifier : this.qualifiers) {
            di.addQualifier(qualifier);
        }
        if (this.name != null) {
            di.setName(this.name);
        }
        if (this.verbose) {
            System.out.println("Binding service " + di);
        }
        this.config.bind((Descriptor)di);
    }

    public FieldVisitor visitField(int arg0, String arg1, String arg2, String arg3, Object arg4) {
        return null;
    }

    public void visitInnerClass(String arg0, String arg1, String arg2, int arg3) {
    }

    public MethodVisitor visitMethod(int arg0, String arg1, String arg2, String arg3, String[] arg4) {
        return null;
    }

    public void visitOuterClass(String arg0, String arg1, String arg2) {
    }

    public void visitSource(String arg0, String arg1) {
    }

    private class NamedAnnotationVisitor
    implements AnnotationVisitor {
        private final String defaultName;
        private boolean nameSet = false;

        public NamedAnnotationVisitor(String defaultName) {
            this.defaultName = defaultName;
        }

        public void visit(String annotationName, Object value) {
            if (annotationName.equals(ClassVisitorImpl.VALUE)) {
                ClassVisitorImpl.this.name = (String)value;
                this.nameSet = true;
            }
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            return null;
        }

        public AnnotationVisitor visitArray(String arg0) {
            return null;
        }

        public void visitEnd() {
            if (this.nameSet) {
                return;
            }
            ClassVisitorImpl.this.name = this.defaultName;
        }

        public void visitEnum(String arg0, String arg1, String arg2) {
        }
    }

    private class ServiceAnnotationVisitor
    implements AnnotationVisitor {
        private ServiceAnnotationVisitor() {
        }

        public void visit(String annotationName, Object value) {
            if (annotationName.equals(ClassVisitorImpl.NAME)) {
                ClassVisitorImpl.this.name = (String)value;
            }
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            return null;
        }

        public AnnotationVisitor visitArray(String arg0) {
            return null;
        }

        public void visitEnd() {
        }

        public void visitEnum(String arg0, String arg1, String arg2) {
        }
    }
}

