/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.testing.junit;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.DynamicConfigurationService;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.ServiceLocatorFactory;
import org.glassfish.hk2.external.org.objectweb.asm.ClassReader;
import org.glassfish.hk2.external.org.objectweb.asm.ClassVisitor;
import org.glassfish.hk2.utilities.DescriptorImpl;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;
import org.glassfish.hk2.utilities.general.GeneralUtilities;
import org.junit.Before;
import org.jvnet.hk2.testing.junit.internal.ClassVisitorImpl;
import org.jvnet.hk2.testing.junit.internal.ErrorServiceImpl;
import org.jvnet.hk2.testing.junit.internal.JustInTimeInjectionResolverImpl;

public class HK2Runner {
    private static final String CLASS_PATH_PROP = "java.class.path";
    private static final String DOT_CLASS = ".class";
    protected ServiceLocator testLocator;
    private boolean verbose = false;

    @Before
    public void before() {
        this.initialize(this.getClass().getName(), Collections.singletonList(this.getClass().getPackage().getName()), null);
    }

    protected void initialize(String name, List<String> packages, List<Class<?>> clazzes) {
        ServiceLocator found;
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (packages == null) {
            packages = new LinkedList<String>();
        }
        if (clazzes == null) {
            clazzes = new LinkedList();
        }
        if ((found = ServiceLocatorFactory.getInstance().find(name)) != null) {
            this.testLocator = found;
            this.testLocator.inject((Object)this);
            return;
        }
        this.testLocator = ServiceLocatorFactory.getInstance().create(name);
        ServiceLocatorUtilities.addClasses((ServiceLocator)this.testLocator, (Class[])new Class[]{ErrorServiceImpl.class, JustInTimeInjectionResolverImpl.class});
        DynamicConfigurationService dcs = (DynamicConfigurationService)this.testLocator.getService(DynamicConfigurationService.class, new Annotation[0]);
        DynamicConfiguration config = dcs.createDynamicConfiguration();
        this.addServicesFromDefault(config);
        this.addServicesFromPackage(config, packages);
        for (Class<?> clazz : clazzes) {
            config.addActiveDescriptor(clazz);
        }
        config.commit();
        this.testLocator.inject((Object)this);
    }

    protected void setVerbosity(boolean verbose) {
        this.verbose = verbose;
    }

    private void addServicesFromDefault(final DynamicConfiguration config) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                HK2Runner.this.internalAddServicesFromDefault(config);
                return null;
            }
        });
    }

    private void internalAddServicesFromDefault(DynamicConfiguration config) {
        Enumeration<URL> resources;
        ClassLoader loader = this.getClass().getClassLoader();
        try {
            resources = loader.getResources("META-INF/hk2-locator/default");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return;
        }
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            try {
                InputStream urlStream = url.openStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(urlStream));
                boolean goOn = true;
                while (goOn) {
                    DescriptorImpl bindMe = new DescriptorImpl();
                    goOn = bindMe.readObject(reader);
                    if (!goOn) continue;
                    config.bind((Descriptor)bindMe);
                }
                reader.close();
            }
            catch (IOException ioe) {}
        }
    }

    private void addServicesFromPackage(final DynamicConfiguration config, final List<String> packages) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                HK2Runner.this.internalAddServicesFromPackage(config, packages);
                return null;
            }
        });
    }

    private void internalAddServicesFromPackage(DynamicConfiguration config, List<String> packages) {
        if (packages.isEmpty()) {
            return;
        }
        String classPath = GeneralUtilities.getSystemProperty((String)CLASS_PATH_PROP, null);
        StringTokenizer st = new StringTokenizer(classPath, File.pathSeparator);
        while (st.hasMoreTokens()) {
            String pathElement = st.nextToken();
            this.addServicesFromPathElement(config, packages, pathElement);
        }
    }

    private void addServicesFromPathElement(DynamicConfiguration config, List<String> packages, String element) {
        File fileElement = new File(element);
        if (!fileElement.exists()) {
            return;
        }
        if (fileElement.isDirectory()) {
            this.addServicesFromPathDirectory(config, packages, fileElement);
        } else {
            this.addServicesFromPathJar(config, packages, fileElement);
        }
    }

    private void addServicesFromPathDirectory(DynamicConfiguration config, List<String> packages, File directory) {
        for (String pack : packages) {
            File[] candidates;
            File searchDir = new File(directory, HK2Runner.convertToFileFormat(pack));
            if (!searchDir.exists() || !searchDir.isDirectory() || (candidates = searchDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    if (name == null) {
                        return false;
                    }
                    return name.endsWith(HK2Runner.DOT_CLASS);
                }
            })) == null) continue;
            for (File candidate : candidates) {
                try {
                    FileInputStream fis = new FileInputStream(candidate);
                    this.addClassIfService(fis);
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addServicesFromPathJar(DynamicConfiguration config, List<String> packages, File jar) {
        JarFile jarFile;
        try {
            jarFile = new JarFile(jar);
        }
        catch (IOException ioe) {
            return;
        }
        try {
            for (String pack : packages) {
                String packAsFile = HK2Runner.convertToFileFormat(pack);
                int packAsFileLen = packAsFile.length() + 1;
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String entryName = entry.getName();
                    if (!entryName.startsWith(packAsFile) || entryName.substring(packAsFileLen).contains("/") || !entryName.endsWith(DOT_CLASS)) continue;
                    try {
                        this.addClassIfService(jarFile.getInputStream(entry));
                    }
                    catch (IOException ioe) {}
                }
            }
        }
        finally {
            try {
                jarFile.close();
            }
            catch (IOException e) {}
        }
    }

    private void addClassIfService(InputStream is) throws IOException {
        ClassReader reader = new ClassReader(is);
        ClassVisitorImpl cvi = new ClassVisitorImpl(this.testLocator, this.verbose);
        reader.accept((ClassVisitor)cvi, 7);
    }

    private static String convertToFileFormat(String clazzFormat) {
        return clazzFormat.replaceAll("\\.", "/");
    }
}

