/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.testing.junit.internal;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.DynamicConfigurationService;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.JustInTimeInjectionResolver;

@Singleton
public class JustInTimeInjectionResolverImpl
implements JustInTimeInjectionResolver {
    @Inject
    private DynamicConfigurationService dcs;

    public boolean justInTimeResolution(Injectee failedInjectionPoint) {
        Type rawType;
        Type needType = failedInjectionPoint.getRequiredType();
        Class needClass = null;
        if (needType instanceof Class) {
            needClass = (Class)needType;
        } else if (needType instanceof ParameterizedType && (rawType = ((ParameterizedType)needType).getRawType()) instanceof Class) {
            needClass = (Class)rawType;
        }
        if (needClass == null || needClass.isInterface()) {
            return false;
        }
        DynamicConfiguration config = this.dcs.createDynamicConfiguration();
        try {
            config.addActiveDescriptor(needClass);
            config.commit();
            return true;
        }
        catch (Throwable th) {
            return false;
        }
    }
}

