/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.testing.junit;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.inject.Singleton;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.DynamicConfigurationService;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.api.IndexedFilter;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.ServiceLocatorFactory;
import org.glassfish.hk2.api.ServiceLocatorState;
import org.glassfish.hk2.external.org.objectweb.asm.AnnotationVisitor;
import org.glassfish.hk2.external.org.objectweb.asm.ClassReader;
import org.glassfish.hk2.external.org.objectweb.asm.ClassVisitor;
import org.glassfish.hk2.utilities.AbstractActiveDescriptor;
import org.glassfish.hk2.utilities.Binder;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.hk2.utilities.DescriptorImpl;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;
import org.junit.Assert;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.jvnet.hk2.testing.junit.annotations.Classes;
import org.jvnet.hk2.testing.junit.annotations.InhabitantFiles;
import org.jvnet.hk2.testing.junit.annotations.Packages;
import org.jvnet.hk2.testing.junit.internal.ClassVisitorImpl;
import org.jvnet.hk2.testing.junit.internal.ErrorServiceImpl;

public class ServiceLocatorTestRule<T>
extends ExternalResource
implements Binder {
    private final T test;
    private final ServiceLocatorIsolation isolation;
    private final boolean verbose;
    private Description description;
    private ServiceLocator serviceLocator;

    public ServiceLocatorTestRule(T test) {
        this(test, ServiceLocatorIsolation.PER_TEST, false);
    }

    public ServiceLocatorTestRule(T test, boolean verbose) {
        this(test, ServiceLocatorIsolation.PER_TEST, verbose);
    }

    public ServiceLocatorTestRule(T test, ServiceLocatorIsolation isolation) {
        this(test, isolation, false);
    }

    public ServiceLocatorTestRule(T test, ServiceLocatorIsolation isolation, boolean verbose) {
        Assert.assertNotNull(test);
        this.test = test;
        this.isolation = isolation == null ? ServiceLocatorIsolation.PER_TEST : isolation;
        this.verbose = verbose;
    }

    public final ServiceLocatorIsolation getServiceLocatorIsolation() {
        return this.isolation;
    }

    private final Description getDescription() {
        return this.description;
    }

    public final boolean isVerbose() {
        return this.verbose;
    }

    public void before() throws IOException {
        Description description = this.getDescription();
        Assert.assertNotNull((Object)description);
        if (this.serviceLocator == null) {
            this.serviceLocator = this.createServiceLocator(description);
            Assert.assertNotNull((Object)this.serviceLocator);
            this.configureServiceLocator(this.serviceLocator, description);
            this.performDependencyInjection(this.serviceLocator, this.test);
            if (this.isVerbose()) {
                ServiceLocatorUtilities.dumpAllDescriptors((ServiceLocator)this.serviceLocator, (PrintStream)System.out);
            }
        }
    }

    protected void configureServiceLocator(ServiceLocator serviceLocator, Description testDescription) throws IOException {
        Assert.assertNotNull((Object)serviceLocator);
        Assert.assertNotNull((Object)testDescription);
        Class testClass = testDescription.getTestClass();
        if (testClass != null) {
            DynamicConfigurationService dynamicConfigurationService = (DynamicConfigurationService)serviceLocator.getService(DynamicConfigurationService.class, new Annotation[0]);
            Assert.assertNotNull((Object)dynamicConfigurationService);
            DynamicConfiguration dynamicConfiguration = dynamicConfigurationService.createDynamicConfiguration();
            Assert.assertNotNull((Object)dynamicConfiguration);
            dynamicConfiguration.addActiveDescriptor(ErrorServiceImpl.class);
            IndexedFilter unbindFilter = BuilderHelper.createContractFilter((String)Description.class.getName());
            Assert.assertNotNull((Object)unbindFilter);
            dynamicConfiguration.addUnbindFilter((Filter)unbindFilter);
            AbstractActiveDescriptor descriptionDescriptor = BuilderHelper.createConstantDescriptor((Object)testDescription);
            Assert.assertNotNull((Object)descriptionDescriptor);
            descriptionDescriptor.setName(testDescription.getDisplayName());
            descriptionDescriptor.setScope(Singleton.class.getName());
            dynamicConfiguration.addActiveDescriptor((ActiveDescriptor)descriptionDescriptor);
            this.bind(dynamicConfiguration, ((Object)((Object)this)).getClass());
            this.bind(dynamicConfiguration, testClass);
            this.bind(dynamicConfiguration);
            if (this.test instanceof Binder) {
                ((Binder)this.test).bind(dynamicConfiguration);
            }
            dynamicConfiguration.commit();
        }
    }

    public void bind(DynamicConfiguration dynamicConfiguration) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Set<Class<?>> getClassesFromPackages(Set<String> packageNames) throws IOException {
        String classpath;
        LinkedHashSet returnValue = new LinkedHashSet();
        if (packageNames != null && !packageNames.isEmpty() && (classpath = this.getClasspath()) != null) {
            StringTokenizer st = new StringTokenizer(classpath, File.pathSeparator);
            while (st.hasMoreTokens()) {
                String classpathEntry = st.nextToken();
                if (classpathEntry == null) continue;
                File classpathEntryFile = new File(classpathEntry);
                if (classpathEntryFile.isDirectory()) {
                    returnValue.addAll(ServiceLocatorTestRule.getClassesFromDirectory(packageNames, classpathEntryFile, this.isVerbose()));
                    continue;
                }
                if (!classpathEntryFile.exists()) continue;
                ZipFile zipFile = new ZipFile(classpathEntryFile);
                try {
                    returnValue.addAll(this.getClassesFromZipFile(packageNames, zipFile));
                }
                finally {
                    try {
                        if (zipFile == null) continue;
                        zipFile.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Set<Class<?>> getClassesFromZipFile(Set<String> packageNames, ZipFile zipFile) throws IOException {
        LinkedHashSet returnValue = new LinkedHashSet();
        if (packageNames != null && !packageNames.isEmpty() && zipFile != null) {
            for (String packageName : packageNames) {
                Enumeration<? extends ZipEntry> entries;
                if (packageName == null || (entries = zipFile.entries()) == null || !entries.hasMoreElements()) continue;
                String packagePath = packageName.replace('.', '/');
                assert (packagePath != null);
                while (entries.hasMoreElements()) {
                    String entryName;
                    ZipEntry entry = entries.nextElement();
                    if (entry == null || entry.isDirectory() || (entryName = entry.getName()) == null || !entryName.startsWith(packagePath) || !entryName.endsWith(".class")) continue;
                    InputStream entryStream = zipFile.getInputStream(entry);
                    try {
                        Visitor classVisitor = new Visitor(returnValue, this.isVerbose());
                        new ClassReader(entryStream).accept((ClassVisitor)classVisitor, 7);
                    }
                    finally {
                        if (entryStream == null) continue;
                        try {
                            entryStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
        return returnValue;
    }

    protected String getClasspath() {
        return System.getProperty("java.class.path", "");
    }

    private final void bind(DynamicConfiguration configuration, AnnotatedElement element) throws IOException {
        Annotation[] annotations;
        Assert.assertNotNull((Object)configuration);
        if (element != null && (annotations = element.getAnnotations()) != null && annotations.length > 0) {
            this.bind(configuration, Arrays.asList(annotations));
        }
    }

    private final void bind(DynamicConfiguration configuration, Collection<? extends Annotation> annotations) throws IOException {
        Assert.assertNotNull((Object)configuration);
        if (annotations != null && !annotations.isEmpty()) {
            ArrayDeque<Annotation> annotationsToProcess = new ArrayDeque<Annotation>();
            for (Annotation annotation : annotations) {
                assert (annotation != null);
                if (ServiceLocatorTestRule.isBlacklisted(annotation)) continue;
                annotationsToProcess.addLast(annotation);
            }
            HashSet<Annotation> processedAnnotations = new HashSet<Annotation>();
            while (!annotationsToProcess.isEmpty()) {
                Annotation annotation = (Annotation)annotationsToProcess.removeFirst();
                assert (annotation != null);
                if (ServiceLocatorTestRule.isBlacklisted(annotation)) continue;
                processedAnnotations.add(annotation);
                if (annotation instanceof Classes) {
                    this.bind(configuration, (Classes)annotation);
                    continue;
                }
                if (annotation instanceof InhabitantFiles) {
                    ServiceLocatorTestRule.bind(configuration, (InhabitantFiles)annotation);
                    continue;
                }
                if (annotation instanceof Packages) {
                    this.bind(configuration, (Packages)annotation);
                    continue;
                }
                Class<? extends Annotation> annotationType = annotation.annotationType();
                assert (annotationType != null);
                Annotation[] metaAnnotations = annotationType.getAnnotations();
                if (metaAnnotations == null || metaAnnotations.length <= 0) continue;
                for (Annotation metaAnnotation : metaAnnotations) {
                    assert (metaAnnotation != null);
                    if (ServiceLocatorTestRule.isBlacklisted(metaAnnotation) || processedAnnotations.contains(metaAnnotation)) continue;
                    annotationsToProcess.addLast(metaAnnotation);
                }
            }
            processedAnnotations.clear();
        }
    }

    private final void bind(DynamicConfiguration configuration, Classes classes) throws IOException {
        Class<?>[] classArray;
        Assert.assertNotNull((Object)configuration);
        if (classes != null && (classArray = classes.value()) != null && classArray.length > 0) {
            for (Class<?> c : classArray) {
                if (c == null) continue;
                if (Factory.class.isAssignableFrom(c)) {
                    Class<?> factoryClass = c;
                    configuration.addActiveFactoryDescriptor(factoryClass);
                } else {
                    configuration.addActiveDescriptor(c);
                }
                this.bind(configuration, c);
            }
        }
    }

    private final void bind(DynamicConfiguration configuration, Packages packages) throws IOException {
        String[] packagesArray;
        if (packages != null && (packagesArray = packages.value()) != null && packagesArray.length > 0) {
            LinkedHashSet<String> packageNames = new LinkedHashSet<String>();
            for (String packageName : packagesArray) {
                if (packageName == null) continue;
                packageNames.add(packageName);
            }
            this.bind(configuration, (Set<String>)packageNames);
        }
    }

    private final void bind(DynamicConfiguration configuration, Set<String> packageNames) throws IOException {
        Set<Class<?>> classesFromPackages;
        Assert.assertNotNull((Object)configuration);
        if (packageNames != null && !packageNames.isEmpty() && (classesFromPackages = this.getClassesFromPackages(packageNames)) != null && !classesFromPackages.isEmpty()) {
            for (Class<?> c : classesFromPackages) {
                if (c == null) continue;
                if (Factory.class.isAssignableFrom(c)) {
                    Class<?> factoryClass = c;
                    configuration.addActiveFactoryDescriptor(factoryClass);
                    continue;
                }
                configuration.addActiveDescriptor(c);
            }
        }
    }

    protected void performDependencyInjection(ServiceLocator serviceLocator, T test) {
        if (serviceLocator != null) {
            this.serviceLocator.inject((Object)this);
            this.serviceLocator.postConstruct((Object)this);
            if (test != null) {
                serviceLocator.inject(test);
                serviceLocator.postConstruct(test);
            }
        }
    }

    protected ServiceLocator createServiceLocator(Description testDescription) {
        Assert.assertNotNull((Object)testDescription);
        ServiceLocator returnValue = ServiceLocatorFactory.getInstance().create(this.getServiceLocatorName(testDescription));
        Assert.assertNotNull((Object)returnValue);
        return returnValue;
    }

    protected String getServiceLocatorName(Description testDescription) {
        Assert.assertNotNull((Object)testDescription);
        String testClassName = testDescription.getClassName();
        Assert.assertNotNull((Object)testClassName);
        StringBuilder name = new StringBuilder(testClassName);
        ServiceLocatorIsolation isolation = this.getServiceLocatorIsolation();
        if (isolation == null || isolation == ServiceLocatorIsolation.PER_TEST) {
            String testMethodName = testDescription.getMethodName();
            Assert.assertNotNull((Object)testMethodName);
            name.append(".").append(testMethodName);
        }
        return name.toString();
    }

    public Statement apply(Statement statement, Description description) {
        this.description = description;
        return super.apply(statement, description);
    }

    public void after() {
        if (this.serviceLocator != null) {
            if (this.test != null) {
                this.serviceLocator.preDestroy(this.test);
            }
            this.serviceLocator.preDestroy((Object)this);
            ServiceLocatorIsolation isolation = this.getServiceLocatorIsolation();
            if (isolation == null || this.isolation == ServiceLocatorIsolation.PER_TEST) {
                this.shutdownAndDestroyServiceLocator(this.getDescription());
            }
        }
        this.description = null;
    }

    public void shutdownAndDestroyServiceLocator(Description testDescription) {
        if (this.serviceLocator != null) {
            this.serviceLocator.shutdown();
            Assert.assertEquals((Object)ServiceLocatorState.SHUTDOWN, (Object)this.serviceLocator.getState());
            ServiceLocatorFactory.getInstance().destroy(this.serviceLocator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Set<Class<?>> getClassesFromDirectory(Set<String> packageNames, File directory, boolean verbose) throws IOException {
        LinkedHashSet returnValue = new LinkedHashSet();
        if (packageNames != null && directory != null && !packageNames.isEmpty() && directory.isDirectory() && directory.canRead()) {
            for (String packageName : packageNames) {
                File[] candidates;
                File packagePath;
                if (packageName == null || !(packagePath = new File(directory, packageName.replace('.', '/'))).isDirectory() || !packagePath.canRead() || (candidates = packagePath.listFiles(new FilenameFilter(){

                    @Override
                    public final boolean accept(File directory, String name) {
                        return name != null && name.endsWith(".class");
                    }
                })) == null || candidates.length <= 0) continue;
                for (File candidate : candidates) {
                    if (candidate == null || !candidate.isFile() || !candidate.canRead()) continue;
                    FileInputStream fileInputStream = new FileInputStream(candidate);
                    try {
                        Visitor classVisitor = new Visitor(returnValue, verbose);
                        new ClassReader((InputStream)fileInputStream).accept((ClassVisitor)classVisitor, 7);
                    }
                    finally {
                        if (fileInputStream != null) {
                            try {
                                ((InputStream)fileInputStream).close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
            }
        }
        return returnValue;
    }

    private static final boolean isBlacklisted(Annotation annotation) {
        return annotation == null || ServiceLocatorTestRule.isBlacklisted(annotation.annotationType());
    }

    private static final boolean isBlacklisted(Class<? extends Annotation> c) {
        String className;
        boolean returnValue = c == null ? true : (className = c.getName()).startsWith("java.") || className.startsWith("javax.");
        return returnValue;
    }

    private static final void bind(DynamicConfiguration configuration, InhabitantFiles inhabitantFiles) throws IOException {
        String[] inhabitantFilesArray;
        Assert.assertNotNull((Object)configuration);
        if (inhabitantFiles != null && (inhabitantFilesArray = inhabitantFiles.value()) != null && inhabitantFilesArray.length > 0) {
            for (String inhabitantFile : inhabitantFilesArray) {
                if (inhabitantFile == null) continue;
                ServiceLocatorTestRule.bind(configuration, inhabitantFile);
            }
        }
    }

    private static final void bind(DynamicConfiguration configuration, String locatorResourceName) throws IOException {
        Enumeration<URL> locatorResources;
        Assert.assertNotNull((Object)configuration);
        if (locatorResourceName != null && (locatorResources = Thread.currentThread().getContextClassLoader().getResources(locatorResourceName)) != null) {
            while (locatorResources.hasMoreElements()) {
                URL locatorResource = locatorResources.nextElement();
                if (locatorResource == null) continue;
                ServiceLocatorTestRule.bind(configuration, locatorResource);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void bind(DynamicConfiguration configuration, URL locatorResource) throws IOException {
        Assert.assertNotNull((Object)configuration);
        if (locatorResource != null) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(locatorResource.openStream()));
            try {
                ServiceLocatorTestRule.bind(configuration, reader);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private static final void bind(DynamicConfiguration configuration, BufferedReader reader) throws IOException {
        Assert.assertNotNull((Object)configuration);
        if (reader != null) {
            DescriptorImpl descriptor = new DescriptorImpl();
            while (descriptor.readObject(reader)) {
                configuration.bind((Descriptor)descriptor);
                descriptor = new DescriptorImpl();
            }
        }
    }

    private static final class Visitor
    extends ClassVisitorImpl {
        private String className;
        private final Set<Class<?>> classes;

        private Visitor(Set<Class<?>> classes, boolean verbose) {
            super(null, verbose, Collections.<String>emptySet());
            Assert.assertNotNull(classes);
            this.classes = classes;
        }

        @Override
        public final void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.className = name == null ? null : name.replace('/', '.');
        }

        @Override
        public final AnnotationVisitor visitAnnotation(String annotationClassDescriptor, boolean visible) {
            if (visible && "Lorg/jvnet/hk2/annotations/Service;".equals(annotationClassDescriptor)) {
                try {
                    this.classes.add(Class.forName(this.className, true, Thread.currentThread().getContextClassLoader()));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                }
            }
            return null;
        }

        @Override
        public final void visitEnd() {
        }
    }

    public static enum ServiceLocatorIsolation {
        PER_TEST,
        PER_TEST_CLASS;

    }
}

