/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.testing.junit;

import java.lang.annotation.Annotation;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.DynamicConfigurationService;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.ServiceLocatorFactory;
import org.junit.Assert;
import org.jvnet.hk2.testing.junit.HK2TestModule;

public class HK2TestUtilities {
    private static final ServiceLocatorFactory factory = ServiceLocatorFactory.getInstance();

    public static ServiceLocator create(String name, HK2TestModule ... modules) {
        return HK2TestUtilities.create(name, null, modules);
    }

    public static ServiceLocator create(String name, ServiceLocator parent, HK2TestModule ... modules) {
        ServiceLocator retVal = factory.find(name);
        Assert.assertNull((String)("There is already a service locator of this name, change names to ensure a clean test: " + name), (Object)retVal);
        retVal = factory.create(name, parent);
        if (modules == null || modules.length <= 0) {
            return retVal;
        }
        DynamicConfigurationService dcs = (DynamicConfigurationService)retVal.getService(DynamicConfigurationService.class, new Annotation[0]);
        Assert.assertNotNull((String)"Their is no DynamicConfigurationService.  Epic fail", (Object)dcs);
        DynamicConfiguration dc = dcs.createDynamicConfiguration();
        Assert.assertNotNull((String)"DynamicConfiguration creation failure", (Object)dc);
        for (HK2TestModule module : modules) {
            module.configure(dc);
        }
        dc.commit();
        return retVal;
    }
}

