/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.module.maven;

import java.util.Collection;

class MaskingClassLoader
extends ClassLoader {
    private final String[] masks;

    public MaskingClassLoader(String ... masks) {
        this.masks = masks;
    }

    public MaskingClassLoader(Collection<String> masks) {
        this(masks.toArray(new String[masks.size()]));
    }

    public MaskingClassLoader(ClassLoader parent, String ... masks) {
        super(parent);
        this.masks = masks;
    }

    public MaskingClassLoader(ClassLoader parent, Collection<String> masks) {
        this(parent, masks.toArray(new String[masks.size()]));
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        try {
            return this.findSystemClass(name);
        }
        catch (ClassNotFoundException e) {
            for (String mask : this.masks) {
                if (!name.startsWith(mask)) continue;
                return super.loadClass(name, resolve);
            }
            throw new ClassNotFoundException();
        }
    }
}

