/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.module.maven;

import com.sun.enterprise.module.maven.sc.ScriptCreator;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public final class ScriptCreatorMojo
extends AbstractMojo {
    private MavenProject project;
    private String[] configFiles;
    private String[] destDirs;
    private String destDir;
    private boolean buildPlatformSpecific;
    private final Log log = this.getLog();

    public void execute() throws MojoExecutionException {
        String basedir = this.project.getBasedir().getAbsolutePath();
        if (this.configFiles == null || this.configFiles.length == 0) {
            throw new MojoExecutionException("Required parameter <configFiles> not specified or no <configFile> specified, exiting ...");
        }
        if (this.destDir == null && this.destDirs == null) {
            throw new MojoExecutionException("Either <destDir> or <destDirs> should be specified");
        }
        LinkedHashMap<String, String> sd = new LinkedHashMap<String, String>();
        if (this.destDir != null) {
            for (String file : this.configFiles) {
                sd.put(file, this.destDir);
            }
        } else {
            if (this.destDirs.length != this.configFiles.length) {
                throw new MojoExecutionException("Number of <configFile>s and <destDir>s should be same");
            }
            for (int i = 0; i < this.configFiles.length; ++i) {
                sd.put(this.configFiles[i], this.destDirs[i]);
            }
        }
        for (String file : this.configFiles) {
            File cf = new File(basedir, file);
            File dd = new File(basedir, (String)sd.get(file));
            try {
                Properties env;
                if (this.buildPlatformSpecific) {
                    env = this.createBuildPlatformSpecificEnvironment();
                    new ScriptCreator(env).create();
                    continue;
                }
                env = this.createEnvironment(cf, dd, "windows");
                new ScriptCreator(env).create();
                env = this.createEnvironment(cf, dd, "unix");
                new ScriptCreator(env).create();
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getMessage());
            }
        }
    }

    private static void dumpProperties(MavenProject pro, Log log) {
        Properties p = pro.getProperties();
        log.debug((CharSequence)("project: " + pro.getName()));
        log.debug((CharSequence)p.toString());
    }

    private Properties createBuildPlatformSpecificEnvironment() {
        return this.project.getProperties();
    }

    private Properties createEnvironment(File src, File destDir, String id) {
        Properties env = this.project.getProperties();
        env.put("SourceFile", src.getAbsolutePath());
        if ("windows".equals(id)) {
            env.put("os", "windows");
            env.put("script.home", "%cd%");
            String destFileName = src.getName() + ".bat";
            File destFilePath = new File(destDir, destFileName);
            env.put("DestinationFile", destFilePath.getAbsolutePath());
        } else if ("unix".equals(id)) {
            env.put("os", "unix");
            env.put("script.home", "`dirname $0`");
            String destFileName = src.getName();
            File destFilePath = new File(destDir, destFileName);
            env.put("DestinationFile", destFilePath.getAbsolutePath());
        }
        return env;
    }
}

