/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.module.maven.sc;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class Section {
    private final String name;
    private final Map<String, String> props;
    private final Properties env;

    Section(String name, Properties env) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("null arg");
        }
        this.name = name;
        this.props = new LinkedHashMap<String, String>();
        this.env = env;
    }

    void put(String name, String value) {
        value = this.process(value);
        this.props.put(name, value);
    }

    void put(String line) {
        StringTokenizer st = new StringTokenizer(line, "=");
        if (st.countTokens() != 2) {
            throw new IllegalArgumentException("invalid line format: " + line + ", should have been of the form: a=b");
        }
        String key = st.nextToken();
        String val = this.process(st.nextToken());
        this.props.put(key, val);
    }

    Map<String, String> getProps() {
        return Collections.unmodifiableMap(this.props);
    }

    String getProperty(String name) {
        return this.props.get(name);
    }

    String getName() {
        return this.name;
    }

    private String process(String value) {
        String processed = this.processLocalRefs(value);
        processed = this.processExtRefs(processed);
        return processed;
    }

    private String processLocalRefs(String s) {
        Pattern pattern = Pattern.compile("#\\{[a-zA-Z\\d\\._]+\\}");
        Matcher matcher = pattern.matcher(s);
        String replaced = s;
        while (matcher.find()) {
            String token = matcher.group();
            token = this.makeLocalRef(token);
            int start = matcher.start();
            int end = matcher.end();
            replaced = s.substring(0, start) + token + s.substring(end);
        }
        return replaced;
    }

    private String makeLocalRef(String s) {
        if ("windows".equals(this.env.get("os"))) {
            return "%" + s.substring(2, s.length() - 1) + "%";
        }
        return "$" + s.substring(2, s.length() - 1);
    }

    private String processExtRefs(String s) {
        Pattern pattern = Pattern.compile("\\$\\{[a-zA-Z\\d\\._]+\\}");
        Matcher matcher = pattern.matcher(s);
        String replaced = s;
        while (matcher.find()) {
            String token = matcher.group();
            token = token.substring(2, token.length() - 1);
            token = this.env.getProperty(token);
            int start = matcher.start();
            int end = matcher.end();
            replaced = s.substring(0, start) + token + s.substring(end);
        }
        return replaced;
    }
}

