/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.testing.hk2mockito.internal;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.InjectionResolver;
import org.glassfish.hk2.api.ServiceHandle;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.testing.hk2mockito.SC;
import org.jvnet.testing.hk2mockito.internal.HK2Mockito;
import org.jvnet.testing.hk2mockito.internal.MemberCache;
import org.jvnet.testing.hk2mockito.internal.ObjectFactory;
import org.jvnet.testing.hk2mockito.internal.ParentCache;
import org.jvnet.testing.hk2mockito.internal.SpyCacheKey;

@HK2Mockito
@Service
public class SpyService {
    private final MemberCache memberCache;
    private final ParentCache parentCache;
    private final ObjectFactory objectFactory;
    private final InjectionResolver<Inject> systemResolver;

    @Inject
    SpyService(MemberCache memberCache, ParentCache parentCache, ObjectFactory objectFactory, @Named(value="SystemInjectResolver") InjectionResolver systemResolver) {
        this.memberCache = memberCache;
        this.parentCache = parentCache;
        this.objectFactory = objectFactory;
        this.systemResolver = systemResolver;
    }

    public Object findOrCreateSUT(Injectee injectee, ServiceHandle<?> root) {
        Member member = (Member)((Object)injectee.getParent());
        Class<?> parentType = member.getDeclaringClass();
        Map<SpyCacheKey, Object> cache = this.memberCache.get(parentType);
        if (cache == null) {
            this.memberCache.add(parentType);
        }
        return this.objectFactory.newSpy(this.systemResolver.resolve(injectee, root));
    }

    public Object findOrCreateSC(SC sc, Injectee injectee, ServiceHandle<?> root) {
        Member member = (Member)((Object)injectee.getParent());
        Class<?> parentType = member.getDeclaringClass();
        Type requiredType = injectee.getRequiredType();
        Map<SpyCacheKey, Object> cache = this.memberCache.get(parentType);
        if (cache == null) {
            cache = this.memberCache.add(parentType);
        }
        SpyCacheKey executableKey = this.objectFactory.newKey(requiredType, sc.value());
        String field = sc.field();
        if ("".equals(field)) {
            field = member.getName();
        }
        SpyCacheKey fieldKey = this.objectFactory.newKey(requiredType, field);
        Object service = cache.get(executableKey);
        if (service == null) {
            service = cache.get(fieldKey);
        }
        if (service == null) {
            service = this.objectFactory.newSpy(this.systemResolver.resolve(injectee, root));
            cache.put(executableKey, service);
            cache.put(fieldKey, service);
        }
        return service;
    }

    public Object createOrFindService(Injectee injectee, ServiceHandle<?> root) {
        Member member = (Member)((Object)injectee.getParent());
        Class<?> parentType = member.getDeclaringClass();
        Type requiredType = injectee.getRequiredType();
        Object service = this.systemResolver.resolve(injectee, root);
        Type serviceParent = this.parentCache.get(parentType);
        if (serviceParent == null) {
            return service;
        }
        Map<SpyCacheKey, Object> cache = this.memberCache.get(serviceParent);
        if (cache == null) {
            return service;
        }
        SpyCacheKey key = member instanceof Field ? this.objectFactory.newKey(requiredType, member.getName()) : this.objectFactory.newKey(requiredType, injectee.getPosition());
        Object cachedService = cache.get(key);
        if (cachedService == null) {
            service = this.objectFactory.newSpy(service);
            cache.put(key, service);
        } else {
            service = cachedService;
        }
        return service;
    }
}

