/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.testing.hk2mockito;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import javax.inject.Inject;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.InjectionResolver;
import org.glassfish.hk2.api.Rank;
import org.glassfish.hk2.api.ServiceHandle;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.testing.hk2mockito.MC;
import org.jvnet.testing.hk2mockito.SC;
import org.jvnet.testing.hk2mockito.SUT;
import org.jvnet.testing.hk2mockito.internal.MockitoService;
import org.jvnet.testing.hk2mockito.internal.cache.ParentCache;

@Rank(value=0x7FFFFFFF)
@Service
public class HK2MockitoInjectionResolver
implements InjectionResolver<Inject> {
    private final MockitoService mockitoService;
    private final ParentCache parentCache;

    @Inject
    HK2MockitoInjectionResolver(MockitoService mockitoService, ParentCache parentCache) {
        this.mockitoService = mockitoService;
        this.parentCache = parentCache;
    }

    public Object resolve(Injectee injectee, ServiceHandle<?> root) {
        AnnotatedElement parent = injectee.getParent();
        Member member = (Member)((Object)parent);
        Type requiredType = injectee.getRequiredType();
        Class<?> parentType = member.getDeclaringClass();
        SUT sut = parent.getAnnotation(SUT.class);
        SC sc = parent.getAnnotation(SC.class);
        MC mc = parent.getAnnotation(MC.class);
        this.parentCache.put(requiredType, parentType);
        Object service = sut != null ? this.mockitoService.findOrCreateSUT(sut, injectee, root) : (sc != null ? this.mockitoService.findOrCreateCollaborator(sc.value(), sc.field(), injectee, root) : (mc != null ? this.mockitoService.findOrCreateCollaborator(mc.value(), mc.field(), injectee, root) : this.mockitoService.createOrFindService(injectee, root)));
        return service;
    }

    public boolean isConstructorParameterIndicator() {
        return false;
    }

    public boolean isMethodParameterIndicator() {
        return false;
    }
}

