/*
 * Copyright (c) 2014, 2018 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

package org.jvnet.testing.hk2mockito;

import java.lang.annotation.Documented;
import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.ElementType.PARAMETER;
import java.lang.annotation.Retention;
import static java.lang.annotation.RetentionPolicy.RUNTIME;
import java.lang.annotation.Target;

/**
 * {@literal @}SC (Service Collaborator) annotation is used on fields and
 * methods of a Test class to inject spies of the {@literal @}SUT's
 * collaborating services.
 *
 * @author Sharmarke Aden
 */
@Documented
@Retention(RUNTIME)
@Target({METHOD, FIELD, PARAMETER})
public @interface SC {

    /**
     * If the collaborator service being injected is a constructor or method
     * parameter of the SUT, this value should indicate the index of the
     * parameter. By default the collaborator will be detected but in instances
     * (i.e. injecting two or more services with the same type) you may want to
     * explicitly specify the index of the service.
     *
     * @return the index of the parameter
     */
    int value() default 0;

    /**
     * If the collaborator service being injected is a field of the SUT, this
     * value should indicate the name of the field. By default the
     * {@literal @}SC field name is used as the collaborator field name but in
     * instances (i.e. field injection of two or more services with the same
     * type) you may want to explicitly specify the name of the field.
     *
     * @return the name of the field
     */
    String field() default "";
}
