/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.configuration.persistence.properties.internal;

import java.beans.PropertyChangeEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.glassfish.hk2.configuration.hub.api.Hub;
import org.glassfish.hk2.configuration.hub.api.WriteableBeanDatabase;
import org.glassfish.hk2.configuration.hub.api.WriteableType;
import org.glassfish.hk2.configuration.persistence.properties.PropertyFileBean;
import org.glassfish.hk2.configuration.persistence.properties.PropertyFileHandle;
import org.glassfish.hk2.utilities.reflection.ClassReflectionHelper;
import org.glassfish.hk2.utilities.reflection.MethodWrapper;
import org.glassfish.hk2.utilities.reflection.Pretty;
import org.glassfish.hk2.utilities.reflection.internal.ClassReflectionHelperImpl;
import org.jvnet.hk2.annotations.Service;

@Service
public class PropertyFileHandleImpl
implements PropertyFileHandle {
    private static final int MAX_TRIES = 10000;
    private static final char SEPARATOR = '.';
    private final Object lock = new Object();
    private HashMap<TypeData, Map<String, String>> lastRead = new HashMap();
    private boolean open = true;
    private final String specificType;
    private final String defaultType;
    private final String defaultInstanceName;
    private final Hub hub;
    private final ClassReflectionHelper reflectionHelper = new ClassReflectionHelperImpl();
    private static String SET = "set";

    PropertyFileHandleImpl(String specificType, String defaultType, String defaultInstanceName, Hub hub) {
        this.specificType = PropertyFileHandleImpl.emptyNull(specificType);
        this.defaultType = PropertyFileHandleImpl.emptyNull(defaultType);
        this.defaultInstanceName = PropertyFileHandleImpl.emptyNull(defaultInstanceName);
        this.hub = hub;
    }

    private static String emptyNull(String input) {
        if (input == null) {
            return null;
        }
        if ((input = input.trim()).length() <= 0) {
            return null;
        }
        return input;
    }

    private static String getDefaultType(String typeString, String defaultDefault, String defaultValue) {
        String defaultReturn;
        String string = defaultReturn = defaultDefault == null ? defaultValue : defaultDefault;
        if (typeString == null || typeString.isEmpty()) {
            return defaultReturn;
        }
        return typeString;
    }

    private String getDefaultType(String typeString) {
        return PropertyFileHandleImpl.getDefaultType(typeString == null ? this.specificType : typeString, this.defaultType, "DEFAULT_TYPE");
    }

    private String getDefaultInstance(String instanceString) {
        return PropertyFileHandleImpl.getDefaultType(instanceString, this.defaultInstanceName, "DEFAULT");
    }

    private static void addMultiValue(Map<TypeData, Map<String, String>> buildMe, TypeData key, String param, String value) {
        Map<String, String> addToMe = buildMe.get(key);
        if (addToMe == null) {
            addToMe = new HashMap<String, String>();
            buildMe.put(key, addToMe);
        }
        addToMe.put(param, value);
    }

    private void extractData(String keyString, String value, Map<TypeData, Map<String, String>> buildMe) {
        int firstDotIndex = keyString.indexOf(46);
        int secondDotIndex = -1;
        if (firstDotIndex >= 0) {
            secondDotIndex = keyString.indexOf(46, firstDotIndex + 1);
        }
        if (firstDotIndex <= 0) {
            TypeData td = new TypeData(this.getDefaultType(null), this.getDefaultInstance(null));
            PropertyFileHandleImpl.addMultiValue(buildMe, td, keyString, value);
            return;
        }
        if (secondDotIndex >= 0) {
            String typeName = keyString.substring(0, firstDotIndex);
            String instanceName = keyString.substring(firstDotIndex + 1, secondDotIndex);
            String propName = keyString.substring(secondDotIndex + 1);
            TypeData td = new TypeData(typeName, instanceName);
            PropertyFileHandleImpl.addMultiValue(buildMe, td, propName, value);
            return;
        }
        String instanceName = keyString.substring(0, firstDotIndex);
        String propName = keyString.substring(firstDotIndex + 1);
        TypeData td = new TypeData(this.getDefaultType(null), instanceName);
        PropertyFileHandleImpl.addMultiValue(buildMe, td, propName, value);
    }

    private void removeInstances(WriteableBeanDatabase wbd, HashMap<TypeData, Map<String, String>> allBeans) {
        WriteableType wt;
        HashSet<String> newReadTypes = PropertyFileHandleImpl.getTypes(allBeans);
        HashSet<String> oldReadTypes = PropertyFileHandleImpl.getTypes(this.lastRead);
        HashSet<String> removeTypes = new HashSet<String>(oldReadTypes);
        removeTypes.removeAll(newReadTypes);
        for (String removeType : removeTypes) {
            wt = wbd.getWriteableType(removeType);
            if (wt == null) continue;
            HashSet<String> instances = PropertyFileHandleImpl.getInstances(removeType, this.lastRead);
            for (String instance : instances) {
                wt.removeInstance(instance);
            }
        }
        for (String oldType : oldReadTypes) {
            wt = wbd.getWriteableType(oldType);
            if (wt == null || !newReadTypes.contains(oldType)) continue;
            HashSet<String> newReadInstances = PropertyFileHandleImpl.getInstances(oldType, allBeans);
            HashSet<String> removeOldInstances = PropertyFileHandleImpl.getInstances(oldType, this.lastRead);
            removeOldInstances.removeAll(newReadInstances);
            for (String instance : removeOldInstances) {
                wt.removeInstance(instance);
            }
        }
    }

    private static Set<String> getPossibleSetterNames(String key) {
        LinkedHashSet<String> retVal = new LinkedHashSet<String>(2);
        char c = key.charAt(0);
        retVal.add(SET + Character.toUpperCase(c) + key.substring(1));
        StringBuffer sb = new StringBuffer(SET);
        sb.append(Character.toUpperCase(c));
        boolean foundFirstUpper = false;
        for (int lcv = 1; lcv < key.length(); ++lcv) {
            c = key.charAt(lcv);
            boolean isUpper = Character.isUpperCase(c);
            if (isUpper || foundFirstUpper) {
                foundFirstUpper = true;
                sb.append(c);
                continue;
            }
            sb.append(Character.toUpperCase(c));
        }
        retVal.add(sb.toString());
        return retVal;
    }

    private Method findMethod(Class<?> clazz, Set<String> possibleSetterNames) {
        Set wrappers = this.reflectionHelper.getAllMethods(clazz);
        for (MethodWrapper wrapper : wrappers) {
            Class<?>[] parameters;
            Method method = wrapper.getMethod();
            if ((method.getModifiers() & 1) == 0 || (parameters = method.getParameterTypes()).length != 1) continue;
            String methodName = method.getName();
            for (String searchName : possibleSetterNames) {
                if (!methodName.equals(searchName)) continue;
                return method;
            }
        }
        return null;
    }

    private Object convertValue(String value, Class<?> intoMe) {
        Constructor<?> constructor;
        if (value == null) {
            return value;
        }
        if (String.class.equals(intoMe)) {
            return value;
        }
        if (Boolean.TYPE.equals(intoMe) || Boolean.class.equals(intoMe)) {
            return Boolean.parseBoolean(value);
        }
        if (Short.TYPE.equals(intoMe) || Short.class.equals(intoMe)) {
            return Short.parseShort(value);
        }
        if (Integer.TYPE.equals(intoMe) || Integer.class.equals(intoMe)) {
            return Integer.parseInt(value);
        }
        if (Long.TYPE.equals(intoMe) || Long.class.equals(intoMe)) {
            return Long.parseLong(value);
        }
        if (Float.TYPE.equals(intoMe) || Float.class.equals(intoMe)) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (Byte.TYPE.equals(intoMe) || Byte.class.equals(intoMe)) {
            return Byte.parseByte(value);
        }
        if (Double.TYPE.equals(intoMe) || Double.class.equals(intoMe)) {
            return Double.parseDouble(value);
        }
        if (Character.TYPE.equals(intoMe) || Character.class.equals(intoMe)) {
            if (value.length() < 0) {
                return Character.valueOf('\u0000');
            }
            return Character.valueOf(value.charAt(0));
        }
        try {
            constructor = intoMe.getConstructor(String.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Could not convert value " + value + " into class " + intoMe.getName());
        }
        try {
            return constructor.newInstance(value);
        }
        catch (InstantiationException ie) {
            throw new IllegalArgumentException("Could not create value " + value + " from class " + intoMe.getName(), ie);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Could not create value " + value + " from class " + intoMe.getName(), e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Could not create value " + value + " from class " + intoMe.getName(), e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Could not create value " + value + " from class " + intoMe.getName(), e.getTargetException());
        }
    }

    private Object convertBean(String typeName, Map<String, String> rawBean) {
        PropertyFileBean propertyFileBean = (PropertyFileBean)this.hub.getCurrentDatabase().getInstance("PropertyFileServiceBean", "DEFAULT");
        if (propertyFileBean == null) {
            return rawBean;
        }
        Class<?> beanClass = propertyFileBean.getTypeMapping(typeName);
        if (beanClass == null) {
            return rawBean;
        }
        try {
            Object target = beanClass.newInstance();
            for (Map.Entry<String, String> entry : rawBean.entrySet()) {
                String key = entry.getKey();
                Set<String> possibleSetterNames = PropertyFileHandleImpl.getPossibleSetterNames(key);
                Method method = this.findMethod(beanClass, possibleSetterNames);
                if (method == null) {
                    throw new IllegalArgumentException("Could not find a setter for property names " + Pretty.collection(possibleSetterNames));
                }
                Class<?> methodParamType = method.getParameterTypes()[0];
                Object[] params = new Object[]{this.convertValue(entry.getValue(), methodParamType)};
                method.invoke(target, params);
            }
            return target;
        }
        catch (Throwable th) {
            throw new IllegalArgumentException("Error converting to bean type " + beanClass.getName(), th);
        }
    }

    private void modifyValues(WriteableBeanDatabase wbd, HashMap<TypeData, Map<String, String>> allBeans) {
        for (Map.Entry<TypeData, Map<String, String>> entry : this.lastRead.entrySet()) {
            TypeData oldKey = entry.getKey();
            if (!allBeans.containsKey(oldKey)) {
                return;
            }
            Map<String, String> newBean = allBeans.get(oldKey);
            String type = oldKey.typeName;
            String instance = oldKey.instanceName;
            Object convertedNewBean = this.convertBean(type, newBean);
            WriteableType wt = wbd.findOrAddWriteableType(type);
            if (wt.getInstance(instance) == null) {
                wt.addInstance(instance, convertedNewBean);
                continue;
            }
            wt.modifyInstance(instance, convertedNewBean, new PropertyChangeEvent[0]);
        }
    }

    private void addValues(WriteableBeanDatabase wbd, HashMap<TypeData, Map<String, String>> allBeans) {
        for (Map.Entry<TypeData, Map<String, String>> entry : allBeans.entrySet()) {
            TypeData newKey = entry.getKey();
            if (this.lastRead.containsKey(newKey)) continue;
            String typeName = newKey.typeName;
            String instanceName = newKey.instanceName;
            Object convertedNewBean = this.convertBean(typeName, entry.getValue());
            WriteableType wt = wbd.findOrAddWriteableType(typeName);
            if (wt.getInstance(instanceName) != null) {
                wt.modifyInstance(instanceName, convertedNewBean, new PropertyChangeEvent[0]);
                continue;
            }
            wt.addInstance(instanceName, convertedNewBean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readProperties(Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException();
        }
        HashMap<TypeData, Map<String, String>> allBeans = new HashMap<TypeData, Map<String, String>>();
        for (Object fullKey : properties.keySet()) {
            if (!(fullKey instanceof String)) continue;
            String sFullKey = (String)fullKey;
            String value = properties.getProperty(sFullKey);
            this.extractData(sFullKey, value, allBeans);
        }
        Object object = this.lock;
        synchronized (object) {
            if (!this.open) {
                throw new IllegalStateException("This handle has been closed");
            }
            boolean success = false;
            for (int lcv = 0; lcv < 10000; ++lcv) {
                WriteableBeanDatabase wbd = this.hub.getWriteableDatabaseCopy();
                this.removeInstances(wbd, allBeans);
                this.modifyValues(wbd, allBeans);
                this.addValues(wbd, allBeans);
                try {
                    wbd.commit();
                    success = true;
                    break;
                }
                catch (IllegalStateException ise) {
                    continue;
                }
            }
            if (!success) {
                throw new IllegalStateException("Could not update database after 10000 iterations");
            }
            this.lastRead = allBeans;
        }
    }

    private static HashSet<String> getTypes(HashMap<TypeData, Map<String, String>> lastRead) {
        HashSet<String> retVal = new HashSet<String>();
        for (TypeData td : lastRead.keySet()) {
            retVal.add(td.typeName);
        }
        return retVal;
    }

    private static HashSet<String> getInstances(String typeName, HashMap<TypeData, Map<String, String>> lastRead) {
        HashSet<String> retVal = new HashSet<String>();
        for (TypeData td : lastRead.keySet()) {
            if (!td.typeName.equals(typeName)) continue;
            retVal.add(td.instanceName);
        }
        return retVal;
    }

    @Override
    public String getSpecificType() {
        return this.specificType;
    }

    @Override
    public String getDefaultType() {
        return this.defaultType;
    }

    @Override
    public String getDefaultInstanceName() {
        return this.defaultInstanceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.open) {
                return;
            }
            this.open = false;
            this.reflectionHelper.dispose();
            HashMap<TypeData, Map<String, String>> allBeans = new HashMap<TypeData, Map<String, String>>();
            for (int lcv = 0; lcv < 10000; ++lcv) {
                WriteableBeanDatabase wbd = this.hub.getWriteableDatabaseCopy();
                this.removeInstances(wbd, allBeans);
                try {
                    wbd.commit();
                    break;
                }
                catch (IllegalStateException ise) {
                    continue;
                }
            }
            this.lastRead = allBeans;
        }
    }

    private static class TypeData {
        private final String typeName;
        private final String instanceName;
        private final int hashCode;

        private TypeData(String typeName, String instanceName) {
            this.typeName = typeName;
            this.instanceName = instanceName;
            this.hashCode = typeName.hashCode() ^ instanceName.hashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof TypeData)) {
                return false;
            }
            TypeData other = (TypeData)o;
            return this.typeName.equals(other.typeName) && this.instanceName.equals(other.instanceName);
        }
    }
}

