/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.configuration.properties.test;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.configuration.hub.api.Hub;
import org.glassfish.hk2.configuration.hub.api.Instance;
import org.glassfish.hk2.configuration.hub.api.WriteableBeanDatabase;
import org.glassfish.hk2.configuration.hub.api.WriteableType;
import org.glassfish.hk2.configuration.persistence.properties.PropertyFileBean;
import org.glassfish.hk2.configuration.persistence.properties.PropertyFileHandle;
import org.glassfish.hk2.configuration.persistence.properties.PropertyFileService;
import org.glassfish.hk2.configuration.persistence.properties.PropertyFileUtilities;
import org.glassfish.hk2.configuration.properties.test.FooBean;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.jvnet.hk2.testing.junit.HK2Runner;

public class PropertiesTest
extends HK2Runner {
    private static final String TYPE1 = "T1";
    private static final String TYPE2 = "T2";
    private static final String TYPE3 = "T3";
    private static final String TYPE4 = "T4";
    private static final String INSTANCE1 = "I1";
    private static final String INSTANCE2 = "I2";
    private static final String DEFAULT_INSTANCE_NAME = "DEFAULT_INSTANCE_NAME";
    private static final String NAME = "name";
    private static final String OTHER = "other";
    private static final String ALICE = "alice";
    private static final String BOB = "bob";
    private static final String CAROL = "carol";
    private static final String OTHER_VALUE1 = "V1";
    private static final String OTHER_VALUE2 = "V2";
    private Hub hub;

    @Before
    public void before() {
        super.before();
        PropertyFileUtilities.enablePropertyFileService((ServiceLocator)this.testLocator);
        this.hub = (Hub)this.testLocator.getService(Hub.class, new Annotation[0]);
    }

    private void removeType(String typeName) {
        WriteableBeanDatabase wbd = this.hub.getWriteableDatabaseCopy();
        wbd.removeType(typeName);
        wbd.commit();
    }

    private void removeInstance(String typeName, String instanceName) {
        WriteableBeanDatabase wbd = this.hub.getWriteableDatabaseCopy();
        WriteableType wt = wbd.getWriteableType(typeName);
        wt.removeInstance(instanceName);
        wbd.commit();
    }

    private InputStream getInputResource(String resource) throws IOException {
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        URL url = classLoader.getResource(resource);
        return url.openStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasicPropertyFile() throws IOException {
        this.removeType(TYPE1);
        this.removeType(TYPE2);
        PropertyFileService pfs = (PropertyFileService)this.testLocator.getService(PropertyFileService.class, new Annotation[0]);
        PropertyFileHandle pfh = pfs.createPropertyHandleOfAnyType();
        InputStream is = this.getInputResource("multiPropV1.txt");
        try {
            Properties p = new Properties();
            p.load(is);
            pfh.readProperties(p);
            Map instance1 = (Map)this.hub.getCurrentDatabase().getInstance(TYPE1, INSTANCE1).getBean();
            Assert.assertEquals((Object)INSTANCE1, instance1.get(NAME));
            Assert.assertEquals((Object)"300 Packer Blvd", instance1.get("address"));
            Assert.assertEquals((Object)"Philadelphia", instance1.get("city"));
            Assert.assertEquals((Object)"PA", instance1.get("state"));
            Assert.assertEquals((Object)"07936", instance1.get("zip"));
            Map instance2 = (Map)this.hub.getCurrentDatabase().getInstance(TYPE1, INSTANCE2).getBean();
            Assert.assertEquals((Object)INSTANCE2, instance2.get(NAME));
            Assert.assertEquals((Object)"310 Packer Blvd", instance2.get("address"));
            Assert.assertEquals((Object)"Philadelphia", instance2.get("city"));
            Assert.assertEquals((Object)"PA", instance2.get("state"));
            Assert.assertEquals((Object)"08008", instance2.get("zip"));
            instance1 = (Map)this.hub.getCurrentDatabase().getInstance(TYPE2, INSTANCE1).getBean();
            Assert.assertEquals((Object)INSTANCE1, instance1.get(NAME));
            Assert.assertEquals((Object)"Taylor Avenue", instance1.get("address"));
            Assert.assertEquals((Object)"Beach Haven", instance1.get("city"));
            Assert.assertEquals((Object)"NJ", instance1.get("state"));
            Assert.assertEquals((Object)"08007", instance1.get("zip"));
        }
        finally {
            is.close();
            pfh.dispose();
            this.removeType(TYPE1);
            this.removeType(TYPE2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void addJavaBeanBackedPropertyMap() {
        this.removeType("FooBeanType");
        PropertyFileBean propertyFileBean = new PropertyFileBean();
        propertyFileBean.addTypeMapping("FooBeanType", FooBean.class);
        PropertyFileService pfs = (PropertyFileService)this.testLocator.getService(PropertyFileService.class, new Annotation[0]);
        pfs.addPropertyFileBean(propertyFileBean);
        pfs.addPropertyFileBean(propertyFileBean);
        PropertyFileHandle pfh = pfs.createPropertyHandleOfSpecificType("FooBeanType", DEFAULT_INSTANCE_NAME);
        try {
            Properties p = new Properties();
            p.put("fooBool", "true");
            p.put("fooShort", "13");
            p.put("fooInt", "14");
            p.put("fooLong", "-15");
            p.put("fooFloat", "16.0");
            p.put("fooDouble", "17.00");
            p.put("fooChar", "e");
            p.put("fooString", "Eagles");
            p.put("fooByte", "18");
            p.put("fooFile", ".");
            p.put("snmpValue", "19");
            pfh.readProperties(p);
            Object o = this.hub.getCurrentDatabase().getInstance("FooBeanType", DEFAULT_INSTANCE_NAME).getBean();
            Assert.assertNotNull((Object)o);
            Assert.assertTrue((boolean)(o instanceof FooBean));
            FooBean fooBean = (FooBean)o;
            Assert.assertEquals((Object)true, (Object)fooBean.isFooBool());
            Assert.assertEquals((long)13L, (long)fooBean.getFooShort());
            Assert.assertEquals((long)14L, (long)fooBean.getFooInt());
            Assert.assertEquals((long)-15L, (long)fooBean.getFooLong());
            Assert.assertEquals((float)16.0f, (float)fooBean.getFooFloat(), (float)1.0f);
            Assert.assertEquals((double)17.0, (double)fooBean.getFooDouble(), (double)1.0);
            Assert.assertEquals((long)101L, (long)fooBean.getFooChar());
            Assert.assertEquals((Object)"Eagles", (Object)fooBean.getFooString());
            Assert.assertEquals((long)18L, (long)fooBean.getFooByte());
            Assert.assertEquals((Object)new File("."), (Object)fooBean.getFooFile());
            Assert.assertEquals((Object)"19", (Object)fooBean.getSNMPValue());
        }
        finally {
            pfs.removePropertyFileBean();
            this.removeType("FooBeanType");
        }
    }

    private static String instanceAndParamKey(String instance, String param) {
        return instance + "." + param;
    }

    private String getHubValue(String type, String instance, String param) {
        Instance i = this.hub.getCurrentDatabase().getInstance(type, instance);
        if (i == null) {
            return null;
        }
        Map blm = (Map)i.getBean();
        if (blm == null) {
            return null;
        }
        return (String)blm.get(param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInstanceRemoval() throws IOException {
        this.removeType(TYPE3);
        PropertyFileService pfs = (PropertyFileService)this.testLocator.getService(PropertyFileService.class, new Annotation[0]);
        PropertyFileHandle pfh = pfs.createPropertyHandleOfSpecificType(TYPE3);
        try {
            Properties p = new Properties();
            p.put(PropertiesTest.instanceAndParamKey(ALICE, NAME), ALICE);
            p.put(PropertiesTest.instanceAndParamKey(BOB, NAME), BOB);
            p.put(PropertiesTest.instanceAndParamKey(CAROL, NAME), CAROL);
            pfh.readProperties(p);
            Assert.assertEquals((Object)ALICE, (Object)this.getHubValue(TYPE3, ALICE, NAME));
            Assert.assertEquals((Object)BOB, (Object)this.getHubValue(TYPE3, BOB, NAME));
            Assert.assertEquals((Object)CAROL, (Object)this.getHubValue(TYPE3, CAROL, NAME));
            p.remove(PropertiesTest.instanceAndParamKey(BOB, NAME));
            pfh.readProperties(p);
            Assert.assertEquals((Object)ALICE, (Object)this.getHubValue(TYPE3, ALICE, NAME));
            Assert.assertNull((Object)this.getHubValue(TYPE3, BOB, NAME));
            Assert.assertEquals((Object)CAROL, (Object)this.getHubValue(TYPE3, CAROL, NAME));
            p.remove(PropertiesTest.instanceAndParamKey(ALICE, NAME));
            pfh.readProperties(p);
            Assert.assertNull((Object)this.getHubValue(TYPE3, ALICE, NAME));
            Assert.assertNull((Object)this.getHubValue(TYPE3, BOB, NAME));
            Assert.assertEquals((Object)CAROL, (Object)this.getHubValue(TYPE3, CAROL, NAME));
            p.remove(PropertiesTest.instanceAndParamKey(CAROL, NAME));
            pfh.readProperties(p);
            Assert.assertNull((Object)this.getHubValue(TYPE3, ALICE, NAME));
            Assert.assertNull((Object)this.getHubValue(TYPE3, BOB, NAME));
            Assert.assertNull((Object)this.getHubValue(TYPE3, CAROL, NAME));
        }
        finally {
            pfh.dispose();
            this.removeType(TYPE3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInstanceModification() throws IOException {
        this.removeType(TYPE4);
        PropertyFileService pfs = (PropertyFileService)this.testLocator.getService(PropertyFileService.class, new Annotation[0]);
        PropertyFileHandle pfh = pfs.createPropertyHandleOfAnyType(TYPE4, CAROL);
        try {
            Properties p = new Properties();
            p.put(PropertiesTest.instanceAndParamKey(ALICE, NAME), ALICE);
            p.put(PropertiesTest.instanceAndParamKey(ALICE, OTHER), OTHER_VALUE1);
            pfh.readProperties(p);
            Assert.assertEquals((Object)ALICE, (Object)this.getHubValue(TYPE4, ALICE, NAME));
            Assert.assertEquals((Object)OTHER_VALUE1, (Object)this.getHubValue(TYPE4, ALICE, OTHER));
            p.put(PropertiesTest.instanceAndParamKey(ALICE, OTHER), OTHER_VALUE2);
            pfh.readProperties(p);
            Assert.assertEquals((Object)ALICE, (Object)this.getHubValue(TYPE4, ALICE, NAME));
            Assert.assertEquals((Object)OTHER_VALUE2, (Object)this.getHubValue(TYPE4, ALICE, OTHER));
        }
        finally {
            pfh.dispose();
            this.removeType(TYPE4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testModifyDeletedInstance() throws IOException {
        this.removeType(TYPE4);
        PropertyFileService pfs = (PropertyFileService)this.testLocator.getService(PropertyFileService.class, new Annotation[0]);
        PropertyFileHandle pfh = pfs.createPropertyHandleOfAnyType(TYPE4, CAROL);
        try {
            Properties p = new Properties();
            p.put(PropertiesTest.instanceAndParamKey(ALICE, NAME), ALICE);
            p.put(PropertiesTest.instanceAndParamKey(ALICE, OTHER), OTHER_VALUE1);
            pfh.readProperties(p);
            Assert.assertEquals((Object)ALICE, (Object)this.getHubValue(TYPE4, ALICE, NAME));
            Assert.assertEquals((Object)OTHER_VALUE1, (Object)this.getHubValue(TYPE4, ALICE, OTHER));
            this.removeInstance(TYPE4, ALICE);
            Assert.assertNull((Object)this.getHubValue(TYPE4, ALICE, NAME));
            Assert.assertNull((Object)this.getHubValue(TYPE4, ALICE, OTHER));
            p.put(PropertiesTest.instanceAndParamKey(ALICE, OTHER), OTHER_VALUE2);
            pfh.readProperties(p);
            Assert.assertEquals((Object)ALICE, (Object)this.getHubValue(TYPE4, ALICE, NAME));
            Assert.assertEquals((Object)OTHER_VALUE2, (Object)this.getHubValue(TYPE4, ALICE, OTHER));
        }
        finally {
            pfh.dispose();
            this.removeType(TYPE4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddAlreadyExistingInstance() throws IOException {
        this.removeType(TYPE4);
        PropertyFileService pfs = (PropertyFileService)this.testLocator.getService(PropertyFileService.class, new Annotation[0]);
        PropertyFileHandle pfh1 = pfs.createPropertyHandleOfAnyType(TYPE4, CAROL);
        PropertyFileHandle pfh2 = pfs.createPropertyHandleOfAnyType(TYPE4, CAROL);
        try {
            Properties p = new Properties();
            p.put(PropertiesTest.instanceAndParamKey(ALICE, NAME), ALICE);
            p.put(PropertiesTest.instanceAndParamKey(ALICE, OTHER), OTHER_VALUE1);
            pfh1.readProperties(p);
            Assert.assertEquals((Object)ALICE, (Object)this.getHubValue(TYPE4, ALICE, NAME));
            Assert.assertEquals((Object)OTHER_VALUE1, (Object)this.getHubValue(TYPE4, ALICE, OTHER));
            p.put(PropertiesTest.instanceAndParamKey(ALICE, OTHER), OTHER_VALUE2);
            pfh2.readProperties(p);
            Assert.assertEquals((Object)ALICE, (Object)this.getHubValue(TYPE4, ALICE, NAME));
            Assert.assertEquals((Object)OTHER_VALUE2, (Object)this.getHubValue(TYPE4, ALICE, OTHER));
        }
        finally {
            pfh1.dispose();
            pfh2.dispose();
            this.removeType(TYPE4);
        }
    }
}

