/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.configuration.persistence.properties;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public class PropertyFileBean {
    public static final String TYPE_NAME = "PropertyFileServiceBean";
    public static final String INSTANCE_NAME = "DEFAULT";
    private final ReentrantLock lock = new ReentrantLock();
    private final HashMap<String, Class<?>> mapping = new HashMap();

    public PropertyFileBean() {
    }

    public PropertyFileBean(PropertyFileBean copyMe) {
        this.mapping.putAll(copyMe.getTypeMapping());
    }

    public Map<String, Class<?>> getTypeMapping() {
        this.lock.lock();
        try {
            HashMap hashMap = new HashMap(this.mapping);
            return hashMap;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addTypeMapping(String typeName, Class<?> beanClass) {
        this.lock.lock();
        try {
            this.mapping.put(typeName, beanClass);
        }
        finally {
            this.lock.unlock();
        }
    }

    public Class<?> removeTypeMapping(String typeName) {
        this.lock.lock();
        try {
            Class<?> clazz = this.mapping.remove(typeName);
            return clazz;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Class<?> getTypeMapping(String typeName) {
        this.lock.lock();
        try {
            Class<?> clazz = this.mapping.get(typeName);
            return clazz;
        }
        finally {
            this.lock.unlock();
        }
    }
}

