/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.utilities.reflection.internal;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.glassfish.hk2.utilities.reflection.ClassReflectionHelper;
import org.glassfish.hk2.utilities.reflection.MethodWrapper;
import org.glassfish.hk2.utilities.reflection.Pretty;
import org.glassfish.hk2.utilities.reflection.internal.MethodWrapperImpl;

public class ClassReflectionHelperImpl
implements ClassReflectionHelper {
    private static final String CONVENTION_POST_CONSTRUCT = "postConstruct";
    private static final String CONVENTION_PRE_DESTROY = "preDestroy";
    private static final Set<MethodWrapper> OBJECT_METHODS = ClassReflectionHelperImpl.getObjectMethods();
    private static final Set<Field> OBJECT_FIELDS = ClassReflectionHelperImpl.getObjectFields();
    private final ConcurrentHashMap<Class<?>, MethodPresentValue> postConstructCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<Class<?>, MethodPresentValue> preDestroyCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<Class<?>, Set<MethodWrapper>> methodCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<Class<?>, Set<Field>> fieldCache = new ConcurrentHashMap();

    private static Set<MethodWrapper> getObjectMethods() {
        return AccessController.doPrivileged(new PrivilegedAction<Set<MethodWrapper>>(){

            @Override
            public Set<MethodWrapper> run() {
                HashSet<MethodWrapper> retVal = new HashSet<MethodWrapper>();
                for (Method method : Object.class.getDeclaredMethods()) {
                    retVal.add(new MethodWrapperImpl(method));
                }
                return retVal;
            }
        });
    }

    private static Set<Field> getObjectFields() {
        return AccessController.doPrivileged(new PrivilegedAction<Set<Field>>(){

            @Override
            public Set<Field> run() {
                HashSet<Field> retVal = new HashSet<Field>();
                for (Field field : Object.class.getDeclaredFields()) {
                    retVal.add(field);
                }
                return retVal;
            }
        });
    }

    private static Method[] secureGetDeclaredMethods(final Class<?> clazz) {
        return AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

            @Override
            public Method[] run() {
                return clazz.getDeclaredMethods();
            }
        });
    }

    private static Field[] secureGetDeclaredFields(final Class<?> clazz) {
        return AccessController.doPrivileged(new PrivilegedAction<Field[]>(){

            @Override
            public Field[] run() {
                return clazz.getDeclaredFields();
            }
        });
    }

    private Set<MethodWrapper> getDeclaredMethodWrappers(Class<?> clazz) {
        Method[] declaredMethods = ClassReflectionHelperImpl.secureGetDeclaredMethods(clazz);
        HashSet<MethodWrapper> retVal = new HashSet<MethodWrapper>();
        for (Method method : declaredMethods) {
            retVal.add(new MethodWrapperImpl(method));
            if (!ClassReflectionHelperImpl.isPostConstruct(method) && !ClassReflectionHelperImpl.isPreDestroy(method) || method.getParameterTypes().length != 0) continue;
            if (ClassReflectionHelperImpl.isPostConstruct(method) && !this.postConstructCache.containsKey(clazz)) {
                this.postConstructCache.putIfAbsent(clazz, new MethodPresentValue(method));
            }
            if (!ClassReflectionHelperImpl.isPreDestroy(method) || this.preDestroyCache.containsKey(clazz)) continue;
            this.preDestroyCache.putIfAbsent(clazz, new MethodPresentValue(method));
        }
        return retVal;
    }

    private static Set<Field> getDeclaredFieldWrappers(Class<?> clazz) {
        Field[] declaredFields = ClassReflectionHelperImpl.secureGetDeclaredFields(clazz);
        HashSet<Field> retVal = new HashSet<Field>();
        for (Field field : declaredFields) {
            retVal.add(field);
        }
        return retVal;
    }

    public Set<Field> getAllFieldWrappers(Class<?> clazz) {
        if (clazz == null) {
            return Collections.emptySet();
        }
        if (Object.class.equals(clazz)) {
            return OBJECT_FIELDS;
        }
        Set<Field> retVal = this.fieldCache.get(clazz);
        if (retVal != null) {
            return retVal;
        }
        retVal = new HashSet<Field>();
        retVal.addAll(ClassReflectionHelperImpl.getDeclaredFieldWrappers(clazz));
        retVal.addAll(this.getAllFieldWrappers(clazz.getSuperclass()));
        this.fieldCache.putIfAbsent(clazz, retVal);
        return retVal;
    }

    public Set<MethodWrapper> getAllMethodWrappers(Class<?> clazz) {
        if (clazz == null) {
            return Collections.emptySet();
        }
        if (Object.class.equals(clazz)) {
            return OBJECT_METHODS;
        }
        Set<MethodWrapper> retVal = this.methodCache.get(clazz);
        if (retVal != null) {
            return retVal;
        }
        retVal = new HashSet<MethodWrapper>();
        retVal.addAll(this.getDeclaredMethodWrappers(clazz));
        retVal.addAll(this.getAllMethodWrappers(clazz.getSuperclass()));
        this.methodCache.putIfAbsent(clazz, retVal);
        return retVal;
    }

    private static boolean isPostConstruct(Method m) {
        if (m.isAnnotationPresent(PostConstruct.class)) {
            return true;
        }
        if (m.getParameterTypes().length != 0) {
            return false;
        }
        return CONVENTION_POST_CONSTRUCT.equals(m.getName());
    }

    private static boolean isPreDestroy(Method m) {
        if (m.isAnnotationPresent(PreDestroy.class)) {
            return true;
        }
        if (m.getParameterTypes().length != 0) {
            return false;
        }
        return CONVENTION_PRE_DESTROY.equals(m.getName());
    }

    @Override
    public Set<MethodWrapper> getAllMethods(Class<?> clazz) {
        return this.getAllMethodWrappers(clazz);
    }

    @Override
    public Set<Field> getAllFields(Class<?> clazz) {
        return this.getAllFieldWrappers(clazz);
    }

    private Method getPostConstructMethod(Class<?> clazz) {
        Method retVal;
        if (clazz == null || Object.class.equals(clazz)) {
            return null;
        }
        MethodPresentValue cachedValue = this.postConstructCache.get(clazz);
        if (cachedValue != null) {
            if (!cachedValue.isPresent()) {
                return null;
            }
            retVal = cachedValue.getMethod();
            if (retVal != null) {
                return retVal;
            }
        }
        retVal = null;
        for (Method m : ClassReflectionHelperImpl.secureGetDeclaredMethods(clazz)) {
            if (!ClassReflectionHelperImpl.isPostConstruct(m)) continue;
            retVal = m;
            break;
        }
        if (retVal == null) {
            retVal = this.getPostConstructMethod(clazz.getSuperclass());
        }
        if (retVal != null && retVal.getParameterTypes().length != 0) {
            throw new IllegalArgumentException("The method " + Pretty.method(retVal) + " annotated with @PostConstruct must not have any arguments");
        }
        this.postConstructCache.putIfAbsent(clazz, new MethodPresentValue(retVal));
        return retVal;
    }

    private Method getPreDestroyMethod(Class<?> clazz) {
        Method retVal;
        if (clazz == null || Object.class.equals(clazz)) {
            return null;
        }
        MethodPresentValue cachedValue = this.preDestroyCache.get(clazz);
        if (cachedValue != null) {
            if (!cachedValue.isPresent()) {
                return null;
            }
            retVal = cachedValue.getMethod();
            if (retVal != null) {
                return retVal;
            }
        }
        retVal = null;
        for (Method m : ClassReflectionHelperImpl.secureGetDeclaredMethods(clazz)) {
            if (!ClassReflectionHelperImpl.isPreDestroy(m)) continue;
            retVal = m;
            break;
        }
        if (retVal == null) {
            retVal = this.getPreDestroyMethod(clazz.getSuperclass());
        }
        if (retVal != null && retVal.getParameterTypes().length != 0) {
            throw new IllegalArgumentException("The method " + Pretty.method(retVal) + " annotated with @PreDestroy must not have any arguments");
        }
        this.preDestroyCache.put(clazz, new MethodPresentValue(retVal));
        return retVal;
    }

    @Override
    public Method findPostConstruct(Class<?> clazz, Class<?> matchingClass) throws IllegalArgumentException {
        Method retVal;
        MethodPresentValue cachedValue = this.postConstructCache.get(clazz);
        if (cachedValue != null) {
            if (!cachedValue.isPresent()) {
                return null;
            }
            retVal = cachedValue.getMethod();
            if (retVal != null) {
                return retVal;
            }
        }
        if (matchingClass.isAssignableFrom(clazz)) {
            try {
                retVal = clazz.getMethod(CONVENTION_POST_CONSTRUCT, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                retVal = null;
            }
            this.postConstructCache.put(clazz, new MethodPresentValue(retVal));
        }
        return this.getPostConstructMethod(clazz);
    }

    @Override
    public Method findPreDestroy(Class<?> clazz, Class<?> matchingClass) throws IllegalArgumentException {
        Method retVal;
        MethodPresentValue cachedValue = this.preDestroyCache.get(clazz);
        if (cachedValue != null) {
            if (!cachedValue.isPresent()) {
                return null;
            }
            retVal = cachedValue.getMethod();
            if (retVal != null) {
                return retVal;
            }
        }
        if (matchingClass.isAssignableFrom(clazz)) {
            try {
                retVal = clazz.getMethod(CONVENTION_PRE_DESTROY, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                retVal = null;
            }
            this.preDestroyCache.put(clazz, new MethodPresentValue(retVal));
        }
        return this.getPreDestroyMethod(clazz);
    }

    @Override
    public void clean(Class<?> clazz) {
        while (clazz != null && !Object.class.equals(clazz)) {
            this.postConstructCache.remove(clazz);
            this.preDestroyCache.remove(clazz);
            this.methodCache.remove(clazz);
            this.fieldCache.remove(clazz);
            clazz = clazz.getSuperclass();
        }
    }

    @Override
    public void dispose() {
        this.postConstructCache.clear();
        this.preDestroyCache.clear();
        this.methodCache.clear();
        this.fieldCache.clear();
    }

    public String toString() {
        return "ClassReflectionHelperImpl(" + System.identityHashCode(this) + ")";
    }

    private static class MethodPresentValue {
        private final Method method;

        private MethodPresentValue(Method method) {
            this.method = method;
        }

        private boolean isPresent() {
            return this.method != null;
        }

        private Method getMethod() {
            return this.method;
        }
    }
}

