/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.hk2Config.xml.test.listeners;

import java.beans.VetoableChangeListener;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.Map;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.configuration.hub.api.Hub;
import org.glassfish.hk2.configuration.hub.api.Instance;
import org.glassfish.hk2.hk2Config.xml.test.listeners.DaveHatingListener;
import org.glassfish.hk2.hk2Config.xml.test.listeners.HaterGonnaHate;
import org.glassfish.hk2.hk2Config.xml.test.utilities.LocatorUtilities;
import org.glassfish.hk2.hk2Config.xml.test0.OldConfigTest;
import org.glassfish.hk2.xml.api.XmlRootHandle;
import org.glassfish.hk2.xml.api.XmlService;
import org.glassfish.hk2.xml.hk2Config.test.beans.KingdomConfig;
import org.glassfish.hk2.xml.hk2Config.test.beans.Phyla;
import org.glassfish.hk2.xml.hk2Config.test.beans.Phylum;
import org.glassfish.hk2.xml.hk2Config.test.beans.ScientistBean;
import org.glassfish.hk2.xml.hk2Config.test.customizers.AuditableListener;
import org.glassfish.hk2.xml.hk2Config.test.customizers.KingdomCustomizer;
import org.glassfish.hk2.xml.hk2Config.test.customizers.PhylaCustomizer;
import org.junit.Assert;
import org.junit.Test;
import org.jvnet.hk2.config.types.PropertyBagCustomizerImpl;

public class ListenersTest {
    public static final String CAROL_NAME = "Carol";
    public static final String DAVE_NAME = "Dave";
    public static final String LINN_NAME = "Linnaeus";
    public static final String BIOLOGY_FIELD = "Biology";
    public static final String EXPECTED_MESSAGE = "I hate Dave";
    public static final String EXPECTED_MESSAGE2 = "Carol fails with IllegalStateException";
    public static final String EXPECTED_MESSAGE3 = "The proverbial hater shall always hate";

    @Test
    public void testBasicUpdate() throws Exception {
        ServiceLocator locator = LocatorUtilities.createLocator(PropertyBagCustomizerImpl.class, KingdomCustomizer.class, PhylaCustomizer.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("kingdom1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshall(url.toURI(), KingdomConfig.class, true, true);
        rootHandle.addChangeListener(new VetoableChangeListener[]{new AuditableListener()});
        KingdomConfig kingdom = (KingdomConfig)rootHandle.getRoot();
        OldConfigTest.assertOriginalStateKingdom1(kingdom, hub);
        Phylum ph = (Phylum)locator.getService(Phylum.class, "Alice", new Annotation[0]);
        long originalUpdated = ph.getUpdatedOn();
        ph.setNumGermLayers(15);
        long newUpdated = ph.getUpdatedOn();
        Assert.assertTrue((newUpdated > originalUpdated ? 1 : 0) != 0);
    }

    @Test
    public void testBasicCreate() throws Exception {
        ServiceLocator locator = LocatorUtilities.createLocator(PropertyBagCustomizerImpl.class, KingdomCustomizer.class, PhylaCustomizer.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("kingdom1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshall(url.toURI(), KingdomConfig.class, true, true);
        rootHandle.addChangeListener(new VetoableChangeListener[]{new AuditableListener(), new DaveHatingListener()});
        KingdomConfig kingdom = (KingdomConfig)rootHandle.getRoot();
        OldConfigTest.assertOriginalStateKingdom1(kingdom, hub);
        Phylum bob = (Phylum)xmlService.createBean(Phylum.class);
        bob.setName("Bob");
        Phyla phyla = kingdom.getPhyla();
        phyla.addPhylum(bob);
        bob = phyla.getPhylumByName("Bob");
        Assert.assertTrue((bob.getCreatedOn() > 0L ? 1 : 0) != 0);
        Instance bobInstance = hub.getCurrentDatabase().getInstance(OldConfigTest.PHYLUM_TYPE, OldConfigTest.BOB_INSTANCE);
        Assert.assertNotNull((Object)bobInstance);
        Map aliceMap = (Map)bobInstance.getBean();
        Assert.assertEquals((Object)"Bob", aliceMap.get(OldConfigTest.NAME_TAG));
    }

    @Test
    public void testBasicCreateAnArray() throws Exception {
        ServiceLocator locator = LocatorUtilities.createLocator(PropertyBagCustomizerImpl.class, KingdomCustomizer.class, PhylaCustomizer.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("kingdom1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshall(url.toURI(), KingdomConfig.class, true, true);
        rootHandle.addChangeListener(new VetoableChangeListener[]{new AuditableListener(), new DaveHatingListener()});
        KingdomConfig kingdom = (KingdomConfig)rootHandle.getRoot();
        OldConfigTest.assertOriginalStateKingdom1(kingdom, hub);
        ScientistBean linnaeus = (ScientistBean)xmlService.createBean(ScientistBean.class);
        linnaeus.setName(LINN_NAME);
        linnaeus = kingdom.addScientist(linnaeus);
        Assert.assertTrue((linnaeus.getCreatedOn() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)linnaeus.getUpdatedOn());
        long kingdomUpdated = kingdom.getUpdatedOn();
        Assert.assertTrue((kingdomUpdated > 0L ? 1 : 0) != 0);
        linnaeus.setField(BIOLOGY_FIELD);
        Assert.assertTrue((linnaeus.getUpdatedOn() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)kingdomUpdated, (long)kingdom.getUpdatedOn());
    }

    @Test
    public void testBasicRemove() throws Exception {
        ServiceLocator locator = LocatorUtilities.createLocator(PropertyBagCustomizerImpl.class, KingdomCustomizer.class, PhylaCustomizer.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("kingdom1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshall(url.toURI(), KingdomConfig.class, true, true);
        rootHandle.addChangeListener(new VetoableChangeListener[]{new AuditableListener()});
        KingdomConfig kingdom = (KingdomConfig)rootHandle.getRoot();
        OldConfigTest.assertOriginalStateKingdom1(kingdom, hub);
        Phylum alice = kingdom.getPhyla().getPhylumByName("Alice");
        Phyla phyla = kingdom.getPhyla();
        alice = phyla.deletePhylum(alice);
        Assert.assertNotNull((Object)alice);
        Assert.assertTrue((alice.getDeletedOn() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((phyla.getUpdatedOn() > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testBasicRemoveAndAddOfDirectChild() throws Exception {
        ServiceLocator locator = LocatorUtilities.createLocator(PropertyBagCustomizerImpl.class, KingdomCustomizer.class, PhylaCustomizer.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("kingdom1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshall(url.toURI(), KingdomConfig.class, true, true);
        rootHandle.addChangeListener(new VetoableChangeListener[]{new AuditableListener()});
        KingdomConfig kingdom = (KingdomConfig)rootHandle.getRoot();
        OldConfigTest.assertOriginalStateKingdom1(kingdom, hub);
        Phyla phyla = kingdom.getPhyla();
        kingdom.setPhyla(null);
        Assert.assertTrue((phyla.getDeletedOn() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((kingdom.getUpdatedOn() > 0L ? 1 : 0) != 0);
        phyla = (Phyla)xmlService.createBean(Phyla.class);
        kingdom.setPhyla(phyla);
        phyla = kingdom.getPhyla();
        Assert.assertTrue((phyla.getCreatedOn() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((kingdom.getUpdatedOn() > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testBasicRemoveArray() throws Exception {
        ServiceLocator locator = LocatorUtilities.createLocator(PropertyBagCustomizerImpl.class, KingdomCustomizer.class, PhylaCustomizer.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("kingdom1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshall(url.toURI(), KingdomConfig.class, true, true);
        rootHandle.addChangeListener(new VetoableChangeListener[]{new AuditableListener()});
        KingdomConfig kingdom = (KingdomConfig)rootHandle.getRoot();
        OldConfigTest.assertOriginalStateKingdom1(kingdom, hub);
        ScientistBean darwin = kingdom.lookupScientist("Darwin");
        ScientistBean removed = kingdom.removeScientist(kingdom.getScientists()[0]);
        Assert.assertNotNull((Object)removed);
        Assert.assertEquals((Object)darwin, (Object)removed);
        Assert.assertEquals((long)0L, (long)kingdom.getScientists().length);
        Assert.assertTrue((darwin.getDeletedOn() > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testMultiTierRemoveAndAdd() throws Exception {
        ServiceLocator locator = LocatorUtilities.createLocator(PropertyBagCustomizerImpl.class, KingdomCustomizer.class, PhylaCustomizer.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("kingdom1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshall(url.toURI(), KingdomConfig.class, true, true);
        rootHandle.addChangeListener(new VetoableChangeListener[]{new AuditableListener()});
        KingdomConfig kingdom = (KingdomConfig)rootHandle.getRoot();
        OldConfigTest.assertOriginalStateKingdom1(kingdom, hub);
        Phylum alice = kingdom.getPhyla().getPhylumByName("Alice");
        Phyla phyla = kingdom.getPhyla();
        kingdom.setPhyla(null);
        Assert.assertEquals((long)0L, (long)alice.getDeletedOn());
        Assert.assertTrue((phyla.getDeletedOn() > 0L ? 1 : 0) != 0);
        Instance phylaInstance = hub.getCurrentDatabase().getInstance(OldConfigTest.PHYLA_TYPE, OldConfigTest.PHYLA_INSTANCE);
        Assert.assertNull((Object)phylaInstance);
        Instance aliceInstance = hub.getCurrentDatabase().getInstance(OldConfigTest.PHYLUM_TYPE, OldConfigTest.ALICE_INSTANCE);
        Assert.assertNull((Object)aliceInstance);
        Phylum bob = (Phylum)xmlService.createBean(Phylum.class);
        bob.setName("Bob");
        phyla = (Phyla)xmlService.createBean(Phyla.class);
        phyla.addPhylum(bob);
        kingdom.setPhyla(phyla);
        phyla = kingdom.getPhyla();
        bob = phyla.getPhylumByName("Bob");
        Assert.assertTrue((bob.getCreatedOn() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((phyla.getCreatedOn() > 0L ? 1 : 0) != 0);
        phylaInstance = hub.getCurrentDatabase().getInstance(OldConfigTest.PHYLA_TYPE, OldConfigTest.PHYLA_INSTANCE);
        Assert.assertNotNull((Object)phylaInstance);
        Instance bobInstance = hub.getCurrentDatabase().getInstance(OldConfigTest.PHYLUM_TYPE, OldConfigTest.BOB_INSTANCE);
        Assert.assertNotNull((Object)bobInstance);
        Map bobMap = (Map)bobInstance.getBean();
        Assert.assertEquals((Object)"Bob", bobMap.get(OldConfigTest.NAME_TAG));
        Assert.assertNull(bobMap.get(OldConfigTest.SHELL_TAG));
    }

    @Test
    public void testFailedCreate() throws Exception {
        ServiceLocator locator = LocatorUtilities.createLocator(PropertyBagCustomizerImpl.class, KingdomCustomizer.class, PhylaCustomizer.class, DaveHatingListener.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("kingdom1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshall(url.toURI(), KingdomConfig.class, true, true);
        rootHandle.addChangeListener(new VetoableChangeListener[]{new AuditableListener(), new DaveHatingListener()});
        KingdomConfig kingdom = (KingdomConfig)rootHandle.getRoot();
        OldConfigTest.assertOriginalStateKingdom1(kingdom, hub);
        Phylum dave = (Phylum)xmlService.createBean(Phylum.class);
        dave.setName(DAVE_NAME);
        Phyla phyla = kingdom.getPhyla();
        try {
            phyla.addPhylum(dave);
            Assert.fail((String)"Should not have succeeded");
        }
        catch (MultiException me) {
            Assert.assertTrue((String)me.getMessage(), (boolean)me.getMessage().contains(EXPECTED_MESSAGE));
        }
        OldConfigTest.assertOriginalStateKingdom1(kingdom, hub);
    }

    @Test
    public void testFailedUpdate() throws Exception {
        ServiceLocator locator = LocatorUtilities.createLocator(PropertyBagCustomizerImpl.class, KingdomCustomizer.class, PhylaCustomizer.class, DaveHatingListener.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("kingdom1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshall(url.toURI(), KingdomConfig.class, true, true);
        rootHandle.addChangeListener(new VetoableChangeListener[]{new DaveHatingListener(), new AuditableListener()});
        KingdomConfig kingdom = (KingdomConfig)rootHandle.getRoot();
        OldConfigTest.assertOriginalStateKingdom1(kingdom, hub);
        Phyla phyla = kingdom.getPhyla();
        Phylum alice = phyla.getPhylumByName("Alice");
        try {
            alice.setShellType(DAVE_NAME);
            Assert.fail((String)"Should not have succeeded");
        }
        catch (MultiException me) {
            Assert.assertTrue((String)me.getMessage(), (boolean)me.getMessage().contains(EXPECTED_MESSAGE));
        }
        OldConfigTest.assertOriginalStateKingdom1(kingdom, hub);
    }

    @Test
    public void testFailedUpdateOtherListenersCalled() throws Exception {
        ServiceLocator locator = LocatorUtilities.createDomLocator(PropertyBagCustomizerImpl.class, KingdomCustomizer.class, PhylaCustomizer.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("kingdom1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshall(url.toURI(), KingdomConfig.class, true, true);
        AuditableListener auditableListener = new AuditableListener();
        rootHandle.addChangeListener(new VetoableChangeListener[]{new DaveHatingListener(), auditableListener});
        KingdomConfig kingdom = (KingdomConfig)rootHandle.getRoot();
        OldConfigTest.assertOriginalStateKingdom1(kingdom, hub);
        Phyla phyla = kingdom.getPhyla();
        Phylum alice = phyla.getPhylumByName("Alice");
        try {
            alice.setShellType(CAROL_NAME);
            Assert.fail((String)"Should not have succeeded");
        }
        catch (MultiException me) {
            Assert.assertTrue((String)me.getMessage(), (boolean)me.getMessage().contains(EXPECTED_MESSAGE2));
        }
        Assert.assertEquals((long)0L, (long)alice.getUpdatedOn());
        Assert.assertEquals((long)2L, (long)auditableListener.getNumTimesCalled());
    }

    @Test
    public void testPropertyNotChangedOnVeto() throws Exception {
        ServiceLocator locator = LocatorUtilities.createDomLocator(PropertyBagCustomizerImpl.class, KingdomCustomizer.class, PhylaCustomizer.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("kingdom1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshall(url.toURI(), KingdomConfig.class, true, true);
        rootHandle.addChangeListener(new VetoableChangeListener[]{new AuditableListener(), new HaterGonnaHate()});
        KingdomConfig kingdom = (KingdomConfig)rootHandle.getRoot();
        OldConfigTest.assertOriginalStateKingdom1(kingdom, hub);
        ScientistBean darwin = kingdom.getScientists()[0];
        try {
            darwin.setField(BIOLOGY_FIELD);
            Assert.fail((String)"Should have failed because hater gonna hate");
        }
        catch (MultiException expected) {
            // empty catch block
        }
        Instance scienceInstance = hub.getCurrentDatabase().getInstance(OldConfigTest.SCIENTIST_TYPE, OldConfigTest.DARWIN_INSTANCE);
        Assert.assertNotNull((Object)scienceInstance);
        Map propMap = (Map)scienceInstance.getBean();
        Assert.assertEquals((Object)"Darwin", propMap.get(OldConfigTest.NAME_TAG));
        Assert.assertEquals((Object)"naturalist", propMap.get(OldConfigTest.FIELD_TAG));
        Assert.assertNull(propMap.get("updated-on"));
        Assert.assertEquals((Object)"naturalist", (Object)darwin.getField());
        Assert.assertEquals((long)0L, (long)darwin.getUpdatedOn());
    }
}

