/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.hk2Config.xml.test0;

import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.configuration.hub.api.BeanDatabase;
import org.glassfish.hk2.configuration.hub.api.Hub;
import org.glassfish.hk2.configuration.hub.api.Instance;
import org.glassfish.hk2.hk2Config.xml.test.utilities.LocatorUtilities;
import org.glassfish.hk2.xml.api.XmlRootHandle;
import org.glassfish.hk2.xml.api.XmlService;
import org.glassfish.hk2.xml.hk2Config.test.beans.KingdomConfig;
import org.glassfish.hk2.xml.hk2Config.test.beans.Phyla;
import org.glassfish.hk2.xml.hk2Config.test.beans.Phylum;
import org.glassfish.hk2.xml.hk2Config.test.beans.ScientistBean;
import org.glassfish.hk2.xml.hk2Config.test.beans.pv.NamedPropertyValue;
import org.glassfish.hk2.xml.hk2Config.test.customizers.KingdomCustomizer;
import org.glassfish.hk2.xml.hk2Config.test.customizers.PhylaCustomizer;
import org.glassfish.hk2.xml.spi.ConfigBeanProxyCustomizerImpl;
import org.junit.Assert;
import org.junit.Test;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.types.Property;
import org.jvnet.hk2.config.types.PropertyBagCustomizerImpl;

public class OldConfigTest {
    public static final String KINGDOM_FILE = "kingdom1.xml";
    public static final String ALICE_NAME = "Alice";
    public static final String BOB_NAME = "Bob";
    public static final String DARWIN_NAME = "Darwin";
    public static final String NATURALIST_FIELD = "naturalist";
    private static final String USERNAME_PROP_KEY = "username";
    private static final String USERNAME_PROP_VALUE = "sa";
    private static final String PASSWORD_PROP_KEY = "password";
    private static final String PASSWORD_PROP_VALUE = "sp";
    private static final String SHELL_TYPE_CHITIN = "chitin";
    private static final String P1 = "P1";
    private static final String P2 = "P2";
    private static final String P3 = "P3";
    private static final String P4 = "P4";
    private static final String V1 = "V1";
    private static final String V2 = "V2";
    private static final String V3 = "V3";
    private static final String V4 = "V4";
    private static final String ADDED_NAME = "added";
    private static final String ADDED_VALUE = "added value";
    public static String KINGDOM_TYPE = "/kingdom";
    public static String PHYLA_TYPE = "/kingdom/phyla";
    public static String PHYLUM_TYPE = "/kingdom/phyla/phylum";
    public static String PHYLUM_PROP_TYPE = "/kingdom/phyla/phylum/property";
    public static String KINGDOM_PROP_TYPE = "/kingdom/property";
    public static String SCIENTIST_TYPE = "/kingdom/scientist";
    public static String KINGDOM_INSTANCE = "kingdom";
    public static String PHYLA_INSTANCE = "kingdom.phyla";
    public static String ALICE_INSTANCE = "kingdom.phyla.Alice";
    public static String BOB_INSTANCE = "kingdom.phyla.Bob";
    public static String PHYLUM_ALICE_PASSWORD_INSTANCE = "kingdom.phyla.Alice.password";
    public static String PHYLUM_ALICE_USERNAME_INSTANCE = "kingdom.phyla.Alice.username";
    public static String P1_INSTANCE = "kingdom.P1";
    public static String P2_INSTANCE = "kingdom.P2";
    public static String P3_INSTANCE = "kingdom.P3";
    public static String DARWIN_INSTANCE = "kingdom.Darwin";
    public static String NAME_TAG = "name";
    public static String SHELL_TAG = "shell-type";
    public static String VALUE_TAG = "value";
    public static String FIELD_TAG = "field";
    public static String PASSWORD_KEY = "password";
    public static String PASSWORD_VALUE = "sp";
    public static String USERNAME_KEY = "username";
    public static String USERNAME_VALUE = "sa";

    @Test
    public void testSimplePropertiesAndNamesAreCallable() throws Exception {
        ServiceLocator locator = LocatorUtilities.createLocator(PropertyBagCustomizerImpl.class, KingdomCustomizer.class, PhylaCustomizer.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource(KINGDOM_FILE);
        XmlRootHandle rootHandle = xmlService.unmarshall(url.toURI(), KingdomConfig.class, true, false);
        KingdomConfig kingdom1 = (KingdomConfig)rootHandle.getRoot();
        OldConfigTest.assertOriginalStateKingdom1(kingdom1, null);
    }

    @Test
    public void testCustomizedMethodsAreCallable() throws Exception {
        ServiceLocator locator = LocatorUtilities.createLocator(PropertyBagCustomizerImpl.class, KingdomCustomizer.class, PhylaCustomizer.class, ConfigBeanProxyCustomizerImpl.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource(KINGDOM_FILE);
        XmlRootHandle rootHandle = xmlService.unmarshall(url.toURI(), KingdomConfig.class, true, false);
        KingdomConfig kingdom1 = (KingdomConfig)rootHandle.getRoot();
        OldConfigTest.assertOriginalStateKingdom1(kingdom1, null);
        Assert.assertNull((Object)kingdom1.getParent());
        Assert.assertNull((Object)kingdom1.getParent(KingdomConfig.class));
        Assert.assertNotNull((Object)kingdom1.createChild(Phyla.class));
        try {
            kingdom1.deepCopy((ConfigBeanProxy)kingdom1);
            Assert.fail((String)"Not implemented");
        }
        catch (IllegalStateException ae) {
            // empty catch block
        }
        Phyla phyla = kingdom1.getPhyla();
        Assert.assertEquals((Object)kingdom1, (Object)phyla.getParent());
        Assert.assertEquals((Object)kingdom1, (Object)phyla.getParent(KingdomConfig.class));
        Assert.assertNotNull((Object)phyla.createChild(Phylum.class));
        try {
            phyla.deepCopy((ConfigBeanProxy)kingdom1);
            Assert.fail((String)"Not implemented");
        }
        catch (IllegalStateException ae) {
            // empty catch block
        }
        Phylum alice = phyla.getPhylumByName(ALICE_NAME);
        Assert.assertNotNull((Object)alice);
        Assert.assertEquals((Object)phyla, (Object)alice.getParent());
        Assert.assertEquals((Object)phyla, (Object)alice.getParent(Phyla.class));
        try {
            alice.deepCopy((ConfigBeanProxy)kingdom1);
            Assert.fail((String)"Not implemented");
        }
        catch (IllegalStateException ae) {
            // empty catch block
        }
        Assert.assertEquals((Object)USERNAME_PROP_VALUE, (Object)alice.getPropertyValue(USERNAME_PROP_KEY));
        Assert.assertEquals((Object)PASSWORD_PROP_VALUE, (Object)alice.getPropertyValue(PASSWORD_PROP_KEY));
        List all = phyla.getPhylumByType(Phylum.class);
        Assert.assertEquals((long)1L, (long)all.size());
        for (Phylum phylum : all) {
            Assert.assertEquals((Object)ALICE_NAME, (Object)phylum.getName());
            Assert.assertEquals((Object)USERNAME_PROP_VALUE, (Object)phylum.getPropertyValue(USERNAME_PROP_KEY));
            Assert.assertEquals((Object)PASSWORD_PROP_VALUE, (Object)phylum.getPropertyValue(PASSWORD_PROP_KEY));
        }
        HashMap<String, NamedPropertyValue> props = new HashMap<String, NamedPropertyValue>();
        props.put("name", new NamedPropertyValue(BOB_NAME));
        Phylum bob = phyla.createPhylum(props);
        Assert.assertNotNull((Object)bob);
        Assert.assertEquals((Object)BOB_NAME, (Object)bob.getName());
        all = phyla.getPhylum();
        Assert.assertEquals((long)2L, (long)all.size());
        int lcv = 0;
        for (Phylum phylum : all) {
            if (lcv == 0) {
                Assert.assertEquals((Object)ALICE_NAME, (Object)phylum.getName());
                Assert.assertEquals((Object)USERNAME_PROP_VALUE, (Object)phylum.getPropertyValue(USERNAME_PROP_KEY));
                Assert.assertEquals((Object)PASSWORD_PROP_VALUE, (Object)phylum.getPropertyValue(PASSWORD_PROP_KEY));
            } else if (lcv == 1) {
                Assert.assertEquals((Object)BOB_NAME, (Object)phylum.getName());
                Assert.assertNull((Object)phylum.getPropertyValue(USERNAME_PROP_KEY));
                Assert.assertNull((Object)phylum.getPropertyValue(PASSWORD_PROP_KEY));
            }
            ++lcv;
        }
    }

    @Test
    public void testAddRemoveAndLookupOfProperty() throws Exception {
        ServiceLocator locator = LocatorUtilities.createLocator(PropertyBagCustomizerImpl.class, KingdomCustomizer.class, PhylaCustomizer.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource(KINGDOM_FILE);
        XmlRootHandle rootHandle = xmlService.unmarshall(url.toURI(), KingdomConfig.class, true, false);
        KingdomConfig kingdom1 = (KingdomConfig)rootHandle.getRoot();
        OldConfigTest.assertOriginalStateKingdom1(kingdom1, null);
        Assert.assertNull((Object)kingdom1.lookupProperty(ADDED_NAME));
        List allProps = kingdom1.getProperty();
        Assert.assertEquals((long)3L, (long)allProps.size());
        Property property = (Property)xmlService.createBean(Property.class);
        property.setName(ADDED_NAME);
        property.setValue(ADDED_VALUE);
        kingdom1.addProperty(property);
        Property found = kingdom1.lookupProperty(ADDED_NAME);
        Assert.assertNotNull((Object)found);
        Assert.assertEquals((Object)ADDED_NAME, (Object)found.getName());
        Assert.assertEquals((Object)ADDED_VALUE, (Object)found.getValue());
        Assert.assertNull((Object)found.getDescription());
        allProps = kingdom1.getProperty();
        Assert.assertEquals((long)4L, (long)allProps.size());
        Assert.assertEquals((Object)found, allProps.get(3));
        Property removed = kingdom1.removeProperty(ADDED_NAME);
        Assert.assertNotNull((Object)removed);
        Assert.assertEquals((Object)found, (Object)removed);
        Assert.assertNull((Object)kingdom1.lookupProperty(ADDED_NAME));
        allProps = kingdom1.getProperty();
        Assert.assertEquals((long)3L, (long)allProps.size());
    }

    public static void assertOriginalStateKingdom1(KingdomConfig kingdom1, Hub hub) {
        Assert.assertNotNull((Object)kingdom1);
        Assert.assertEquals((long)0L, (long)kingdom1.getCreatedOn());
        Assert.assertEquals((long)0L, (long)kingdom1.getUpdatedOn());
        Assert.assertEquals((long)0L, (long)kingdom1.getDeletedOn());
        Phyla phyla = kingdom1.getPhyla();
        Assert.assertNotNull((Object)phyla);
        List phylums = phyla.getPhylum();
        Assert.assertEquals((long)1L, (long)phylums.size());
        for (Phylum phylum : phylums) {
            Assert.assertEquals((Object)ALICE_NAME, (Object)phylum.getName());
            Assert.assertEquals((Object)USERNAME_PROP_VALUE, (Object)phylum.getPropertyValue(USERNAME_PROP_KEY));
            Assert.assertEquals((Object)PASSWORD_PROP_VALUE, (Object)phylum.getPropertyValue(PASSWORD_PROP_KEY));
            Assert.assertEquals((long)2L, (long)phylum.getNumGermLayers());
            Assert.assertEquals((Object)true, (Object)phylum.isSoftBodied());
            Assert.assertEquals((long)0L, (long)phylum.getCreatedOn());
            Assert.assertEquals((long)0L, (long)phylum.getUpdatedOn());
            Assert.assertEquals((long)0L, (long)phylum.getDeletedOn());
            Assert.assertEquals((Object)SHELL_TYPE_CHITIN, (Object)phylum.getShellType());
        }
        Assert.assertEquals((Object)P1, (Object)((Property)kingdom1.getProperty().get(0)).getName());
        Assert.assertEquals((Object)V1, (Object)((Property)kingdom1.getProperty().get(0)).getValue());
        Assert.assertEquals((Object)P2, (Object)((Property)kingdom1.getProperty().get(1)).getName());
        Assert.assertEquals((Object)V2, (Object)((Property)kingdom1.getProperty().get(1)).getValue());
        Assert.assertEquals((Object)P3, (Object)((Property)kingdom1.getProperty().get(2)).getName());
        Assert.assertEquals((Object)V3, (Object)((Property)kingdom1.getProperty().get(2)).getValue());
        Assert.assertEquals((Object)V1, (Object)kingdom1.getPropertyValue(P1));
        Assert.assertEquals((Object)V2, (Object)kingdom1.getPropertyValue(P2));
        Assert.assertEquals((Object)V3, (Object)kingdom1.getPropertyValue(P3));
        Assert.assertEquals((Object)V4, (Object)kingdom1.getPropertyValue(P4, V4));
        ScientistBean[] scientists = kingdom1.getScientists();
        Assert.assertEquals((long)1L, (long)scientists.length);
        for (ScientistBean scientist : scientists) {
            Assert.assertEquals((Object)DARWIN_NAME, (Object)scientist.getName());
            Assert.assertEquals((Object)NATURALIST_FIELD, (Object)scientist.getField());
        }
        if (hub == null) {
            return;
        }
        BeanDatabase db = hub.getCurrentDatabase();
        Instance domainInstance = db.getInstance(KINGDOM_TYPE, KINGDOM_INSTANCE);
        Assert.assertNotNull((Object)domainInstance);
        Instance phylaInstance = db.getInstance(PHYLA_TYPE, PHYLA_INSTANCE);
        Assert.assertNotNull((Object)phylaInstance);
        Instance aliceInstance = hub.getCurrentDatabase().getInstance(PHYLUM_TYPE, ALICE_INSTANCE);
        Assert.assertNotNull((Object)aliceInstance);
        Map aliceMap = (Map)aliceInstance.getBean();
        Assert.assertEquals((Object)ALICE_NAME, aliceMap.get(NAME_TAG));
        Assert.assertEquals((Object)SHELL_TYPE_CHITIN, aliceMap.get(SHELL_TAG));
        Instance alicePWInstance = hub.getCurrentDatabase().getInstance(PHYLUM_PROP_TYPE, PHYLUM_ALICE_PASSWORD_INSTANCE);
        Assert.assertNotNull((Object)alicePWInstance);
        aliceMap = (Map)alicePWInstance.getBean();
        Assert.assertEquals((Object)PASSWORD_KEY, aliceMap.get(NAME_TAG));
        Assert.assertEquals((Object)PASSWORD_VALUE, aliceMap.get(VALUE_TAG));
        Instance aliceUNInstance = hub.getCurrentDatabase().getInstance(PHYLUM_PROP_TYPE, PHYLUM_ALICE_USERNAME_INSTANCE);
        Assert.assertNotNull((Object)aliceUNInstance);
        aliceMap = (Map)aliceUNInstance.getBean();
        Assert.assertEquals((Object)USERNAME_KEY, aliceMap.get(NAME_TAG));
        Assert.assertEquals((Object)USERNAME_VALUE, aliceMap.get(VALUE_TAG));
        Instance p1Instance = hub.getCurrentDatabase().getInstance(KINGDOM_PROP_TYPE, P1_INSTANCE);
        Assert.assertNotNull((Object)p1Instance);
        Map propMap = (Map)p1Instance.getBean();
        Assert.assertEquals((Object)P1, propMap.get(NAME_TAG));
        Assert.assertEquals((Object)V1, propMap.get(VALUE_TAG));
        Instance p2Instance = hub.getCurrentDatabase().getInstance(KINGDOM_PROP_TYPE, P2_INSTANCE);
        Assert.assertNotNull((Object)p2Instance);
        propMap = (Map)p2Instance.getBean();
        Assert.assertEquals((Object)P2, propMap.get(NAME_TAG));
        Assert.assertEquals((Object)V2, propMap.get(VALUE_TAG));
        p2Instance = hub.getCurrentDatabase().getInstance(KINGDOM_PROP_TYPE, P3_INSTANCE);
        Assert.assertNotNull((Object)p2Instance);
        propMap = (Map)p2Instance.getBean();
        Assert.assertEquals((Object)P3, propMap.get(NAME_TAG));
        Assert.assertEquals((Object)V3, propMap.get(VALUE_TAG));
        Instance scienceInstance = hub.getCurrentDatabase().getInstance(SCIENTIST_TYPE, DARWIN_INSTANCE);
        Assert.assertNotNull((Object)scienceInstance);
        propMap = (Map)scienceInstance.getBean();
        Assert.assertEquals((Object)DARWIN_NAME, propMap.get(NAME_TAG));
        Assert.assertEquals((Object)NATURALIST_FIELD, propMap.get(FIELD_TAG));
    }
}

