/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.hk2Config.xml.test.listeners;

import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.configuration.hub.api.Hub;
import org.glassfish.hk2.configuration.hub.api.Instance;
import org.glassfish.hk2.hk2Config.xml.test.listeners.DaveHatingListener;
import org.glassfish.hk2.hk2Config.xml.test.listeners.HaterGonnaHate;
import org.glassfish.hk2.hk2Config.xml.test.listeners.RecordingVetoListener;
import org.glassfish.hk2.hk2Config.xml.test.utilities.LocatorUtilities;
import org.glassfish.hk2.hk2Config.xml.test0.OldConfigTest;
import org.glassfish.hk2.utilities.general.GeneralUtilities;
import org.glassfish.hk2.xml.api.XmlRootHandle;
import org.glassfish.hk2.xml.api.XmlService;
import org.glassfish.hk2.xml.hk2Config.test.beans.Clazz;
import org.glassfish.hk2.xml.hk2Config.test.beans.KingdomConfig;
import org.glassfish.hk2.xml.hk2Config.test.beans.Order;
import org.glassfish.hk2.xml.hk2Config.test.beans.Phyla;
import org.glassfish.hk2.xml.hk2Config.test.beans.Phylum;
import org.glassfish.hk2.xml.hk2Config.test.beans.ScientistBean;
import org.glassfish.hk2.xml.hk2Config.test.customizers.AuditableListener;
import org.glassfish.hk2.xml.hk2Config.test.customizers.KingdomCustomizer;
import org.glassfish.hk2.xml.hk2Config.test.customizers.PhylaCustomizer;
import org.junit.Assert;
import org.junit.Test;
import org.jvnet.hk2.config.types.PropertyBagCustomizerImpl;

public class ListenersTest {
    public static final String CAROL_NAME = "Carol";
    public static final String DAVE_NAME = "Dave";
    public static final String LINN_NAME = "Linnaeus";
    public static final String BIOLOGY_FIELD = "Biology";
    public static final String EXPECTED_MESSAGE = "I hate Dave";
    public static final String EXPECTED_MESSAGE2 = "Carol fails with IllegalStateException";
    public static final String EXPECTED_MESSAGE3 = "The proverbial hater shall always hate";
    private static final String UPDATED_ON = "updated-on";
    private static final String CREATED_ON = "created-on";
    private static final String DELETED_ON = "deleted-on";
    private static final String EMPTY = "";

    private static void checkPropertyChangeEvent(PropertyChangeEvent pce, String prop, Object oldV, Object newV, Object source) {
        Assert.assertNotNull((Object)pce);
        Assert.assertNotNull((Object)prop);
        Assert.assertEquals((Object)prop, (Object)pce.getPropertyName());
        Assert.assertTrue((String)("OldValue mismatch expecting " + oldV + " got " + pce.getOldValue()), (boolean)GeneralUtilities.safeEquals((Object)oldV, (Object)pce.getOldValue()));
        Assert.assertTrue((String)("NewValue mismatch expecting " + newV + " got " + pce.getNewValue()), (boolean)GeneralUtilities.safeEquals((Object)newV, (Object)pce.getNewValue()));
        Assert.assertNotNull((Object)source);
        Assert.assertEquals((String)("Source mismatch expecting " + source + " got " + pce.getSource()), (Object)source, (Object)pce.getSource());
    }

    private static void checkPropertyChangeEvent(PropertyChangeEvent pce, String prop, Object source) {
        Assert.assertNotNull((Object)pce);
        Assert.assertNotNull((Object)prop);
        Assert.assertEquals((Object)prop, (Object)pce.getPropertyName());
        Assert.assertNotNull((Object)source);
        Assert.assertEquals((String)("Source mismatch expecting " + source + " got " + pce.getSource()), (Object)source, (Object)pce.getSource());
    }

    @Test
    public void testBasicUpdate() throws Exception {
        ServiceLocator locator = LocatorUtilities.createLocator(PropertyBagCustomizerImpl.class, KingdomCustomizer.class, PhylaCustomizer.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("kingdom1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), KingdomConfig.class, true, true);
        RecordingVetoListener recorder = new RecordingVetoListener();
        rootHandle.addChangeListener(new VetoableChangeListener[]{recorder, new AuditableListener()});
        KingdomConfig kingdom = (KingdomConfig)rootHandle.getRoot();
        OldConfigTest.assertOriginalStateKingdom1(kingdom, hub, locator);
        Phylum ph = (Phylum)locator.getService(Phylum.class, "Alice", new Annotation[0]);
        long originalUpdated = ph.getUpdatedOn();
        ph.setNumGermLayers(15);
        long newUpdated = ph.getUpdatedOn();
        Assert.assertTrue((newUpdated > originalUpdated ? 1 : 0) != 0);
        List<PropertyChangeEvent> events = recorder.getEvents();
        Assert.assertEquals((long)2L, (long)events.size());
        int lcv = 0;
        for (PropertyChangeEvent event : events) {
            if (lcv == 0) {
                ListenersTest.checkPropertyChangeEvent(event, "num-germ-layers", null, 15, ph);
            } else if (lcv == 1) {
                ListenersTest.checkPropertyChangeEvent(event, UPDATED_ON, null, newUpdated, ph);
            }
            ++lcv;
        }
    }

    @Test
    public void testDeepAdds() throws Exception {
        ServiceLocator locator = LocatorUtilities.createLocator(PropertyBagCustomizerImpl.class, KingdomCustomizer.class, PhylaCustomizer.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("kingdom1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), KingdomConfig.class, true, true);
        RecordingVetoListener recorder = new RecordingVetoListener();
        rootHandle.addChangeListener(new VetoableChangeListener[]{recorder, new AuditableListener()});
        KingdomConfig kingdom = (KingdomConfig)rootHandle.getRoot();
        OldConfigTest.assertOriginalStateKingdom1(kingdom, hub, locator);
        Phylum ph = (Phylum)locator.getService(Phylum.class, "Alice", new Annotation[0]);
        Order order1 = (Order)xmlService.createBean(Order.class);
        order1.setName("Darwin");
        Order order2 = (Order)xmlService.createBean(Order.class);
        order2.setName("Bob");
        Clazz clazz = (Clazz)xmlService.createBean(Clazz.class);
        clazz.setName(LINN_NAME);
        clazz.addOrder(order1);
        clazz.addOrder(order2);
        clazz = ph.addClass(clazz);
        order1 = clazz.lookupOrder("Darwin");
        order2 = clazz.lookupOrder("Bob");
        List<PropertyChangeEvent> events = recorder.getEvents();
        Assert.assertEquals((long)8L, (long)events.size());
        block10: for (int lcv = 0; lcv < events.size(); ++lcv) {
            PropertyChangeEvent event = events.get(lcv);
            switch (lcv) {
                case 0: {
                    ListenersTest.checkPropertyChangeEvent(event, EMPTY, null, clazz, clazz);
                    continue block10;
                }
                case 1: {
                    ListenersTest.checkPropertyChangeEvent(event, CREATED_ON, 0L, clazz.getCreatedOn(), clazz);
                    continue block10;
                }
                case 2: {
                    ListenersTest.checkPropertyChangeEvent(event, EMPTY, null, order1, order1);
                    continue block10;
                }
                case 3: {
                    ListenersTest.checkPropertyChangeEvent(event, CREATED_ON, 0L, order1.getCreatedOn(), order1);
                    continue block10;
                }
                case 4: {
                    ListenersTest.checkPropertyChangeEvent(event, EMPTY, null, order2, order2);
                    continue block10;
                }
                case 5: {
                    ListenersTest.checkPropertyChangeEvent(event, CREATED_ON, 0L, order2.getCreatedOn(), order2);
                    continue block10;
                }
                case 6: {
                    ListenersTest.checkPropertyChangeEvent(event, "class", ph);
                    continue block10;
                }
                case 7: {
                    ListenersTest.checkPropertyChangeEvent(event, UPDATED_ON, null, ph.getUpdatedOn(), ph);
                    continue block10;
                }
                default: {
                    Assert.fail((String)("Should only be 8: " + lcv + " event=" + event));
                }
            }
        }
    }

    @Test
    public void testDeepRemove() throws Exception {
        ServiceLocator locator = LocatorUtilities.createLocator(PropertyBagCustomizerImpl.class, KingdomCustomizer.class, PhylaCustomizer.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("kingdom1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), KingdomConfig.class, true, true);
        RecordingVetoListener recorder = new RecordingVetoListener();
        rootHandle.addChangeListener(new VetoableChangeListener[]{recorder, new AuditableListener()});
        KingdomConfig kingdom = (KingdomConfig)rootHandle.getRoot();
        OldConfigTest.assertOriginalStateKingdom1(kingdom, hub, locator);
        Phylum ph = (Phylum)locator.getService(Phylum.class, "Alice", new Annotation[0]);
        Order order1 = (Order)xmlService.createBean(Order.class);
        order1.setName("Darwin");
        Order order2 = (Order)xmlService.createBean(Order.class);
        order2.setName("Bob");
        Clazz clazz = (Clazz)xmlService.createBean(Clazz.class);
        clazz.setName(LINN_NAME);
        clazz.addOrder(order1);
        clazz.addOrder(order2);
        clazz = ph.addClass(clazz);
        order1 = clazz.lookupOrder("Darwin");
        order2 = clazz.lookupOrder("Bob");
        long originalUpdated = ph.getUpdatedOn();
        recorder.clear();
        Assert.assertNotNull((Object)ph.removeClass(clazz));
        List<PropertyChangeEvent> events = recorder.getEvents();
        Assert.assertEquals((long)8L, (long)events.size());
        block10: for (int lcv = 0; lcv < events.size(); ++lcv) {
            PropertyChangeEvent event = events.get(lcv);
            switch (lcv) {
                case 0: {
                    ListenersTest.checkPropertyChangeEvent(event, EMPTY, order1, null, order1);
                    continue block10;
                }
                case 1: {
                    ListenersTest.checkPropertyChangeEvent(event, DELETED_ON, 0L, order1.getDeletedOn(), order1);
                    continue block10;
                }
                case 2: {
                    ListenersTest.checkPropertyChangeEvent(event, EMPTY, order2, null, order2);
                    continue block10;
                }
                case 3: {
                    ListenersTest.checkPropertyChangeEvent(event, DELETED_ON, 0L, order2.getDeletedOn(), order2);
                    continue block10;
                }
                case 4: {
                    ListenersTest.checkPropertyChangeEvent(event, EMPTY, clazz, null, clazz);
                    continue block10;
                }
                case 5: {
                    ListenersTest.checkPropertyChangeEvent(event, DELETED_ON, 0L, clazz.getDeletedOn(), clazz);
                    continue block10;
                }
                case 6: {
                    ListenersTest.checkPropertyChangeEvent(event, "class", ph);
                    continue block10;
                }
                case 7: {
                    ListenersTest.checkPropertyChangeEvent(event, UPDATED_ON, originalUpdated, ph.getUpdatedOn(), ph);
                    continue block10;
                }
                default: {
                    Assert.fail((String)("Should only be 8: " + lcv + " event=" + event));
                }
            }
        }
    }

    @Test
    public void testBasicCreate() throws Exception {
        ServiceLocator locator = LocatorUtilities.createLocator(PropertyBagCustomizerImpl.class, KingdomCustomizer.class, PhylaCustomizer.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("kingdom1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), KingdomConfig.class, true, true);
        RecordingVetoListener recorder = new RecordingVetoListener();
        rootHandle.addChangeListener(new VetoableChangeListener[]{recorder, new AuditableListener(), new DaveHatingListener()});
        KingdomConfig kingdom = (KingdomConfig)rootHandle.getRoot();
        OldConfigTest.assertOriginalStateKingdom1(kingdom, hub, locator);
        Phylum bob = (Phylum)xmlService.createBean(Phylum.class);
        bob.setName("Bob");
        Phyla phyla = kingdom.getPhyla();
        phyla.addPhylum(bob);
        bob = phyla.getPhylumByName("Bob");
        Assert.assertTrue((bob.getCreatedOn() > 0L ? 1 : 0) != 0);
        Instance bobInstance = hub.getCurrentDatabase().getInstance(OldConfigTest.PHYLUM_TYPE, OldConfigTest.BOB_INSTANCE);
        Assert.assertNotNull((Object)bobInstance);
        Map aliceMap = (Map)bobInstance.getBean();
        Assert.assertEquals((Object)"Bob", aliceMap.get(OldConfigTest.NAME_TAG));
        List<PropertyChangeEvent> events = recorder.getEvents();
        for (int lcv = 0; lcv < events.size(); ++lcv) {
            PropertyChangeEvent event = events.get(lcv);
            if (lcv == 0) {
                ListenersTest.checkPropertyChangeEvent(event, EMPTY, null, bob, bob);
                continue;
            }
            if (lcv == 1) {
                ListenersTest.checkPropertyChangeEvent(event, CREATED_ON, 0L, bob.getCreatedOn(), bob);
                continue;
            }
            if (lcv == 2) {
                ListenersTest.checkPropertyChangeEvent(event, "phylum", phyla);
                continue;
            }
            if (lcv == 3) {
                ListenersTest.checkPropertyChangeEvent(event, UPDATED_ON, null, phyla.getUpdatedOn(), phyla);
                continue;
            }
            Assert.fail((String)("Too many events: " + events + " lcv=" + lcv + " event=" + event));
        }
    }

    @Test
    public void testBasicCreateAnArray() throws Exception {
        ServiceLocator locator = LocatorUtilities.createLocator(PropertyBagCustomizerImpl.class, KingdomCustomizer.class, PhylaCustomizer.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("kingdom1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), KingdomConfig.class, true, true);
        rootHandle.addChangeListener(new VetoableChangeListener[]{new AuditableListener(), new DaveHatingListener()});
        KingdomConfig kingdom = (KingdomConfig)rootHandle.getRoot();
        OldConfigTest.assertOriginalStateKingdom1(kingdom, hub, locator);
        ScientistBean linnaeus = (ScientistBean)xmlService.createBean(ScientistBean.class);
        linnaeus.setName(LINN_NAME);
        linnaeus = kingdom.addScientist(linnaeus);
        Assert.assertTrue((linnaeus.getCreatedOn() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)linnaeus.getUpdatedOn());
        long kingdomUpdated = kingdom.getUpdatedOn();
        Assert.assertTrue((kingdomUpdated > 0L ? 1 : 0) != 0);
        linnaeus.setField(BIOLOGY_FIELD);
        Assert.assertTrue((linnaeus.getUpdatedOn() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)kingdomUpdated, (long)kingdom.getUpdatedOn());
    }

    @Test
    public void testBasicRemove() throws Exception {
        ServiceLocator locator = LocatorUtilities.createLocator(PropertyBagCustomizerImpl.class, KingdomCustomizer.class, PhylaCustomizer.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("kingdom1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), KingdomConfig.class, true, true);
        rootHandle.addChangeListener(new VetoableChangeListener[]{new AuditableListener()});
        KingdomConfig kingdom = (KingdomConfig)rootHandle.getRoot();
        OldConfigTest.assertOriginalStateKingdom1(kingdom, hub, locator);
        Phylum alice = kingdom.getPhyla().getPhylumByName("Alice");
        Phyla phyla = kingdom.getPhyla();
        alice = phyla.deletePhylum(alice);
        Assert.assertNotNull((Object)alice);
        Assert.assertTrue((alice.getDeletedOn() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((phyla.getUpdatedOn() > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testBasicRemoveAndAddOfDirectChild() throws Exception {
        ServiceLocator locator = LocatorUtilities.createLocator(PropertyBagCustomizerImpl.class, KingdomCustomizer.class, PhylaCustomizer.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("kingdom1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), KingdomConfig.class, true, true);
        rootHandle.addChangeListener(new VetoableChangeListener[]{new AuditableListener()});
        KingdomConfig kingdom = (KingdomConfig)rootHandle.getRoot();
        OldConfigTest.assertOriginalStateKingdom1(kingdom, hub, locator);
        Phyla phyla = kingdom.getPhyla();
        kingdom.setPhyla(null);
        Assert.assertTrue((phyla.getDeletedOn() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((kingdom.getUpdatedOn() > 0L ? 1 : 0) != 0);
        phyla = (Phyla)xmlService.createBean(Phyla.class);
        kingdom.setPhyla(phyla);
        phyla = kingdom.getPhyla();
        Assert.assertTrue((phyla.getCreatedOn() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((kingdom.getUpdatedOn() > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testBasicRemoveArray() throws Exception {
        ServiceLocator locator = LocatorUtilities.createLocator(PropertyBagCustomizerImpl.class, KingdomCustomizer.class, PhylaCustomizer.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("kingdom1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), KingdomConfig.class, true, true);
        rootHandle.addChangeListener(new VetoableChangeListener[]{new AuditableListener()});
        KingdomConfig kingdom = (KingdomConfig)rootHandle.getRoot();
        OldConfigTest.assertOriginalStateKingdom1(kingdom, hub, locator);
        ScientistBean darwin = kingdom.lookupScientist("Darwin");
        ScientistBean removed = kingdom.removeScientist(kingdom.getScientists()[0]);
        Assert.assertNotNull((Object)removed);
        Assert.assertEquals((Object)darwin, (Object)removed);
        Assert.assertEquals((long)0L, (long)kingdom.getScientists().length);
        Assert.assertTrue((darwin.getDeletedOn() > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testMultiTierRemoveAndAdd() throws Exception {
        ServiceLocator locator = LocatorUtilities.createLocator(PropertyBagCustomizerImpl.class, KingdomCustomizer.class, PhylaCustomizer.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("kingdom1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), KingdomConfig.class, true, true);
        rootHandle.addChangeListener(new VetoableChangeListener[]{new AuditableListener()});
        KingdomConfig kingdom = (KingdomConfig)rootHandle.getRoot();
        OldConfigTest.assertOriginalStateKingdom1(kingdom, hub, locator);
        Phylum alice = kingdom.getPhyla().getPhylumByName("Alice");
        Phyla phyla = kingdom.getPhyla();
        kingdom.setPhyla(null);
        Assert.assertTrue((alice.getDeletedOn() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((phyla.getDeletedOn() > 0L ? 1 : 0) != 0);
        Instance phylaInstance = hub.getCurrentDatabase().getInstance(OldConfigTest.PHYLA_TYPE, OldConfigTest.PHYLA_INSTANCE);
        Assert.assertNull((Object)phylaInstance);
        Instance aliceInstance = hub.getCurrentDatabase().getInstance(OldConfigTest.PHYLUM_TYPE, OldConfigTest.ALICE_INSTANCE);
        Assert.assertNull((Object)aliceInstance);
        Phylum bob = (Phylum)xmlService.createBean(Phylum.class);
        bob.setName("Bob");
        phyla = (Phyla)xmlService.createBean(Phyla.class);
        phyla.addPhylum(bob);
        kingdom.setPhyla(phyla);
        phyla = kingdom.getPhyla();
        bob = phyla.getPhylumByName("Bob");
        Assert.assertTrue((bob.getCreatedOn() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((phyla.getCreatedOn() > 0L ? 1 : 0) != 0);
        phylaInstance = hub.getCurrentDatabase().getInstance(OldConfigTest.PHYLA_TYPE, OldConfigTest.PHYLA_INSTANCE);
        Assert.assertNotNull((Object)phylaInstance);
        Instance bobInstance = hub.getCurrentDatabase().getInstance(OldConfigTest.PHYLUM_TYPE, OldConfigTest.BOB_INSTANCE);
        Assert.assertNotNull((Object)bobInstance);
        Map bobMap = (Map)bobInstance.getBean();
        Assert.assertEquals((Object)"Bob", bobMap.get(OldConfigTest.NAME_TAG));
        Assert.assertNull(bobMap.get(OldConfigTest.SHELL_TAG));
    }

    @Test
    public void testFailedCreate() throws Exception {
        ServiceLocator locator = LocatorUtilities.createLocator(PropertyBagCustomizerImpl.class, KingdomCustomizer.class, PhylaCustomizer.class, DaveHatingListener.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("kingdom1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), KingdomConfig.class, true, true);
        rootHandle.addChangeListener(new VetoableChangeListener[]{new AuditableListener(), new DaveHatingListener()});
        KingdomConfig kingdom = (KingdomConfig)rootHandle.getRoot();
        OldConfigTest.assertOriginalStateKingdom1(kingdom, hub, locator);
        Phylum dave = (Phylum)xmlService.createBean(Phylum.class);
        dave.setName(DAVE_NAME);
        Phyla phyla = kingdom.getPhyla();
        try {
            phyla.addPhylum(dave);
            Assert.fail((String)"Should not have succeeded");
        }
        catch (MultiException me) {
            Assert.assertTrue((String)me.getMessage(), (boolean)me.getMessage().contains(EXPECTED_MESSAGE));
        }
        OldConfigTest.assertOriginalStateKingdom1(kingdom, hub, locator);
    }

    @Test
    public void testFailedUpdate() throws Exception {
        ServiceLocator locator = LocatorUtilities.createLocator(PropertyBagCustomizerImpl.class, KingdomCustomizer.class, PhylaCustomizer.class, DaveHatingListener.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("kingdom1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), KingdomConfig.class, true, true);
        rootHandle.addChangeListener(new VetoableChangeListener[]{new DaveHatingListener(), new AuditableListener()});
        KingdomConfig kingdom = (KingdomConfig)rootHandle.getRoot();
        OldConfigTest.assertOriginalStateKingdom1(kingdom, hub, locator);
        Phyla phyla = kingdom.getPhyla();
        Phylum alice = phyla.getPhylumByName("Alice");
        try {
            alice.setShellType(DAVE_NAME);
            Assert.fail((String)"Should not have succeeded");
        }
        catch (MultiException me) {
            Assert.assertTrue((String)me.getMessage(), (boolean)me.getMessage().contains(EXPECTED_MESSAGE));
        }
        OldConfigTest.assertOriginalStateKingdom1(kingdom, hub, locator);
    }

    @Test
    public void testFailedUpdateOtherListenersCalled() throws Exception {
        ServiceLocator locator = LocatorUtilities.createDomLocator(PropertyBagCustomizerImpl.class, KingdomCustomizer.class, PhylaCustomizer.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("kingdom1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), KingdomConfig.class, true, true);
        AuditableListener auditableListener = new AuditableListener();
        rootHandle.addChangeListener(new VetoableChangeListener[]{new DaveHatingListener(), auditableListener});
        KingdomConfig kingdom = (KingdomConfig)rootHandle.getRoot();
        OldConfigTest.assertOriginalStateKingdom1(kingdom, hub, locator);
        Phyla phyla = kingdom.getPhyla();
        Phylum alice = phyla.getPhylumByName("Alice");
        try {
            alice.setShellType(CAROL_NAME);
            Assert.fail((String)"Should not have succeeded");
        }
        catch (MultiException me) {
            Assert.assertTrue((String)me.getMessage(), (boolean)me.getMessage().contains(EXPECTED_MESSAGE2));
        }
        Assert.assertEquals((long)0L, (long)alice.getUpdatedOn());
        Assert.assertEquals((long)2L, (long)auditableListener.getNumTimesCalled());
    }

    @Test
    public void testPropertyNotChangedOnVeto() throws Exception {
        ServiceLocator locator = LocatorUtilities.createDomLocator(PropertyBagCustomizerImpl.class, KingdomCustomizer.class, PhylaCustomizer.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("kingdom1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), KingdomConfig.class, true, true);
        rootHandle.addChangeListener(new VetoableChangeListener[]{new AuditableListener(), new HaterGonnaHate()});
        KingdomConfig kingdom = (KingdomConfig)rootHandle.getRoot();
        OldConfigTest.assertOriginalStateKingdom1(kingdom, hub, locator);
        ScientistBean darwin = kingdom.getScientists()[0];
        try {
            darwin.setField(BIOLOGY_FIELD);
            Assert.fail((String)"Should have failed because hater gonna hate");
        }
        catch (MultiException expected) {
            // empty catch block
        }
        Instance scienceInstance = hub.getCurrentDatabase().getInstance(OldConfigTest.SCIENTIST_TYPE, OldConfigTest.DARWIN_INSTANCE);
        Assert.assertNotNull((Object)scienceInstance);
        Map propMap = (Map)scienceInstance.getBean();
        Assert.assertEquals((Object)"Darwin", propMap.get(OldConfigTest.NAME_TAG));
        Assert.assertEquals((Object)"naturalist", propMap.get(OldConfigTest.FIELD_TAG));
        Assert.assertNull(propMap.get(UPDATED_ON));
        Assert.assertEquals((Object)"naturalist", (Object)darwin.getField());
        Assert.assertEquals((long)0L, (long)darwin.getUpdatedOn());
    }
}

