/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.hk2Config.test.customizers;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.inject.Singleton;
import org.glassfish.hk2.xml.hk2Config.test.beans.AuditableBean;

@Singleton
public class AuditableListener
implements VetoableChangeListener {
    private int numTimesCalled = 0;

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        ++this.numTimesCalled;
        if ("created-on".equals(evt.getPropertyName()) || "updated-on".equals(evt.getPropertyName()) || "deleted-on".equals(evt.getPropertyName())) {
            return;
        }
        if (!(evt.getSource() instanceof AuditableBean)) {
            return;
        }
        AuditableBean auditable = (AuditableBean)evt.getSource();
        if (evt.getOldValue() == null && evt.getNewValue() != null && evt.getNewValue() instanceof AuditableBean && auditable.equals(evt.getNewValue())) {
            auditable.setCreatedOn(System.currentTimeMillis());
            return;
        }
        if (evt.getOldValue() != null && evt.getNewValue() == null && evt.getOldValue() instanceof AuditableBean && auditable.equals(evt.getOldValue())) {
            auditable.setDeletedOn(System.currentTimeMillis());
            return;
        }
        auditable.setUpdatedOn(System.currentTimeMillis());
    }

    public int getNumTimesCalled() {
        return this.numTimesCalled;
    }
}

