/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.hk2Config.test.customizers;

import java.beans.PropertyVetoException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.glassfish.hk2.xml.api.XmlHk2ConfigurationBean;
import org.glassfish.hk2.xml.api.XmlService;
import org.glassfish.hk2.xml.hk2Config.test.beans.Phyla;
import org.glassfish.hk2.xml.hk2Config.test.beans.Phylum;
import org.glassfish.hk2.xml.hk2Config.test.beans.PropertyValue;
import org.glassfish.hk2.xml.hk2Config.test.beans.pv.NamedPropertyValue;

@Singleton
@Named
public class PhylaCustomizer {
    @Inject
    private Phyla phyla;
    @Inject
    private XmlService xmlService;

    public List<Phylum> getPhylumByType(Class<?> type) {
        LinkedList<Phylum> retVal = new LinkedList<Phylum>();
        List<Phylum> phylum = this.phyla.getPhylum();
        for (Phylum one : phylum) {
            if (!type.isAssignableFrom(one.getClass())) continue;
            retVal.add(one);
        }
        return retVal;
    }

    public Phylum getPhylumByName(Phyla phyla, String name) {
        XmlHk2ConfigurationBean configBean = (XmlHk2ConfigurationBean)phyla;
        Object retVal = configBean._lookupChild("phylum", name);
        return (Phylum)retVal;
    }

    public Phylum createPhylum(Map<String, PropertyValue> properties) throws PropertyVetoException {
        Phylum retVal = (Phylum)this.xmlService.createBean(Phylum.class);
        boolean nameSet = false;
        for (Map.Entry<String, PropertyValue> entry : properties.entrySet()) {
            String key = entry.getKey();
            PropertyValue prop = entry.getValue();
            if (!"name".equals(key)) continue;
            nameSet = true;
            NamedPropertyValue npv = (NamedPropertyValue)prop;
            retVal.setName(npv.getName());
        }
        if (!nameSet) {
            throw new RuntimeException("Name not set in createPhylum " + properties);
        }
        this.phyla.addPhylum(retVal);
        return retVal;
    }

    public Phylum deletePhylum(Phylum removeMe) {
        return this.phyla.removePhylum(removeMe);
    }
}

