/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.test.dynamic.adds;

import java.lang.annotation.Annotation;
import java.net.URL;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.configuration.hub.api.Hub;
import org.glassfish.hk2.configuration.hub.api.Instance;
import org.glassfish.hk2.configuration.hub.api.Type;
import org.glassfish.hk2.xml.api.XmlRootHandle;
import org.glassfish.hk2.xml.api.XmlService;
import org.glassfish.hk2.xml.test.basic.Employee;
import org.glassfish.hk2.xml.test.basic.Employees;
import org.glassfish.hk2.xml.test.basic.Financials;
import org.glassfish.hk2.xml.test.basic.OtherData;
import org.glassfish.hk2.xml.test.utilities.Utilities;
import org.junit.Assert;
import org.junit.Test;

public class AddsTest {
    private static final String DAVE = "Dave";
    private static final String EMPLOYEE_TYPE = "/employees/employee";
    private static final String OTHER_DATA_TYPE = "/employees/other-data";
    private static final String DAVE_INSTANCE = "employees.Dave";

    @Test
    public void testCreateAndAdd() {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        XmlRootHandle rootHandle = xmlService.createEmptyHandle(Employees.class);
        Assert.assertNull((Object)rootHandle.getRoot());
        rootHandle.addRoot();
        Employees root = (Employees)rootHandle.getRoot();
        Assert.assertNotNull((Object)root);
        Assert.assertNull((Object)root.getFinancials());
        Assert.assertNull(root.getEmployees());
        Assert.assertNull((Object)root.getCompanyName());
    }

    @Test
    public void testAddToExistingTree() throws Exception {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("Acme1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshall(url.toURI(), Employees.class);
        Employees employees = (Employees)rootHandle.getRoot();
        employees.addEmployees(DAVE);
        Employee daveDirect = employees.lookupEmployees(DAVE);
        Assert.assertNotNull((Object)daveDirect);
        Employee daveService = (Employee)locator.getService(Employee.class, DAVE, new Annotation[0]);
        Assert.assertNotNull((Object)daveService);
        Assert.assertNotNull((Object)hub.getCurrentDatabase().getInstance(EMPLOYEE_TYPE, DAVE_INSTANCE));
    }

    @Test
    public void testAddToExistingTreeUnKeyed() throws Exception {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("Acme1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshall(url.toURI(), Employees.class);
        Employees employees = (Employees)rootHandle.getRoot();
        employees.addOtherData(0);
        OtherData found = null;
        for (OtherData other : employees.getOtherData()) {
            Assert.assertNull(found);
            found = other;
        }
        Assert.assertNotNull(found);
        OtherData otherService = (OtherData)locator.getService(OtherData.class, new Annotation[0]);
        Assert.assertNotNull((Object)otherService);
        Assert.assertEquals((Object)found, (Object)otherService);
        Type type = hub.getCurrentDatabase().getType(OTHER_DATA_TYPE);
        Instance foundInstance = null;
        for (Instance i : type.getInstances().values()) {
            Assert.assertNull(foundInstance);
            foundInstance = i;
        }
        Assert.assertNotNull(foundInstance);
    }

    @Test
    public void testAddToExistingTreeDirect() throws Exception {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("Acme2.xml");
        XmlRootHandle rootHandle = xmlService.unmarshall(url.toURI(), Employees.class);
        Employees employees = (Employees)rootHandle.getRoot();
        Assert.assertNull((Object)employees.getFinancials());
        employees.addFinancials();
        Financials financials = employees.getFinancials();
        Assert.assertNotNull((Object)financials);
        Assert.assertNull((Object)financials.getExchange());
        Assert.assertNull((Object)financials.getSymbol());
        Assert.assertNotNull((Object)hub.getCurrentDatabase().getInstance("/employees/financials", "employees.financials"));
    }
}

