/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.test.readonly;

import java.lang.annotation.Annotation;
import java.net.URL;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.xml.api.XmlRootHandle;
import org.glassfish.hk2.xml.api.XmlService;
import org.glassfish.hk2.xml.test.readonly.AddressBean;
import org.glassfish.hk2.xml.test.readonly.BookBean;
import org.glassfish.hk2.xml.test.readonly.LibraryBean;
import org.glassfish.hk2.xml.test.utilities.Utilities;
import org.junit.Assert;
import org.junit.Test;

public class ReadOnlyTest {
    private static final String LIBRARY1_FILE = "library1.xml";
    private static final String LIBRARY_NAME = "Sesame Street Library";
    private static final String GEEK_SUBLIME_ISBN = "978-1-55597-685-9";
    private static final String GEEK_SUBLIME_NAME = "Geek Sublime";
    private static final String ESL_ISBN = "1-592-40087-6";
    private static final String ESL_NAME = "Eats, Shoots and Leaves";
    private static final String ALIEN_NAME = "Alien";
    private static final String HANNA_NAME = "Hannah and her Sisters";
    private static final String WOODS_NAME = "Into the Woods";
    private static final String ADDRESS_LINE_1 = "123 Sesame Street";
    private static final String ADDRESS_LINE_2 = "CO Grover";
    private static final String TOWN = "New York";
    private static final String STATE = "NY";
    private static final int ZIP = 10128;

    @Test
    public void testReadOnlyBeans() throws Exception {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource(LIBRARY1_FILE);
        XmlRootHandle rootHandle = xmlService.unmarshall(url.toURI(), LibraryBean.class);
        LibraryBean library = (LibraryBean)rootHandle.getRoot();
        Assert.assertEquals((Object)LIBRARY_NAME, (Object)library.getName());
        BookBean geekSublimeBook = library.getBooks().get(0);
        Assert.assertEquals((Object)GEEK_SUBLIME_ISBN, (Object)geekSublimeBook.getISBN());
        Assert.assertEquals((Object)GEEK_SUBLIME_NAME, (Object)geekSublimeBook.getName());
        BookBean eslBook = library.getBooks().get(1);
        Assert.assertEquals((Object)ESL_ISBN, (Object)eslBook.getISBN());
        Assert.assertEquals((Object)ESL_NAME, (Object)eslBook.getName());
        Assert.assertEquals((Object)ALIEN_NAME, (Object)library.getMovies().get(0).getName());
        Assert.assertEquals((Object)HANNA_NAME, (Object)library.getMovies().get(1).getName());
        Assert.assertEquals((Object)WOODS_NAME, (Object)library.getMovies().get(2).getName());
        AddressBean address = library.getAddress();
        Assert.assertNotNull((Object)address);
        Assert.assertEquals((Object)ADDRESS_LINE_1, (Object)address.getStreetAddress1());
        Assert.assertEquals((Object)ADDRESS_LINE_2, (Object)address.getStreetAddress2());
        Assert.assertEquals((Object)TOWN, (Object)address.getTown());
        Assert.assertEquals((Object)STATE, (Object)address.getState());
        Assert.assertEquals((long)10128L, (long)address.getZipCode());
    }
}

